/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.AsyncVideoI;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.IncrementallyLoadable;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VidCartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.XYCoordinateStringBuilder;

public class VideoPanel
extends InteractivePanel
implements PropertyChangeListener {
    protected static final int defaultWidth = 640;
    protected static final int defaultHeight = 480;
    public static final String PROPERTY_VIDEOPANEL_DATAFILE = "datafile";
    public static final String PROPERTY_VIDEOPANEL_IMAGESPACE = "imagespace";
    public boolean changed = false;
    public String defaultFileName;
    protected int progress;
    public int framesLoaded;
    protected VideoPlayer player;
    protected Video video = null;
    protected boolean playerVisible = true;
    protected boolean drawingInImageSpace = false;
    protected double imageWidth;
    protected double imageHeight;
    protected double xOffset;
    protected double yOffset;
    protected double imageBorder;
    protected ImageCoordSystem coords;
    protected Point2D pt = new Point2D.Double();
    protected File dataFile;
    protected String timeUnit = "s";
    protected Map<String, Class<? extends Filter>> filterClasses = new TreeMap<String, Class<? extends Filter>>();
    protected VideoIO.FinalizableLoader loader;
    private Video videoLoading;

    public VideoPanel() {
        this((Video)null);
    }

    public VideoPanel(Video video2) {
        this.setName("VideoPanel");
        this.squareAspect = true;
        this.addVideoPlayer();
        this.setCoordinateStringBuilder(new VidCartesianCoordinateStringBuilder());
        this.coords = new ImageCoordSystem();
        this.setVideo(video2);
        this.setImageSize(video2, true);
    }

    protected void addVideoPlayer() {
        this.player = new VideoPlayer(this);
        this.player.addFrameListener(this);
        this.add((Component)this.player, "South");
        VideoClip clip = this.player.getVideoClip();
        clip.addListener(this);
    }

    /*
     * Unable to fully structure code
     */
    private void setImageSize(Video video, boolean isConstructor) {
        if (video == null) ** GOTO lbl-1000
        d = video.getImageSize(false);
        if (d.width > 0) {
            this.setImageWidth(d.width);
            this.setImageHeight(d.height);
        } else lbl-1000:
        // 2 sources

        {
            this.setImageWidth(640.0);
            this.setImageHeight(480.0);
        }
        if (!isConstructor) {
            this.coords.setAllOriginsXY(0.0, 0.0);
        }
        if (isConstructor) {
            w = (int)this.getImageWidth();
            h = (int)this.getImageHeight();
            this.setPreferredSize(new Dimension(w, h + this.player.height));
            this.coords.setAllOriginsXY(this.imageWidth / 2.0, this.imageHeight / 2.0);
        } else {
            this.coords.setAllOriginsXY(this.imageWidth / 2.0, this.imageHeight / 2.0);
            if (video != null) {
                video.setProperty("measure", "invalidate");
            }
        }
    }

    public void setVideo(Video newVideo, boolean playAllSteps) {
        if (newVideo == this.video) {
            return;
        }
        if (this.videoLoading != null && this.videoLoading == newVideo) {
            this.videoLoading = null;
        }
        this.initializePlayer(this.video, newVideo, playAllSteps);
    }

    public void setVideo(Video newVideo) {
        this.setVideo(newVideo, false);
    }

    public Video getVideo() {
        return this.video;
    }

    private void initializePlayer(Video prev, Video newVideo, boolean playAllSteps) {
        if (prev != null) {
            prev.removePropertyChangeListener("asyncImageReady", this);
            prev.removePropertyChangeListener("asyncVideoReady", this);
        }
        if (newVideo != null) {
            newVideo.removePropertyChangeListener("asyncImageReady", this);
            newVideo.addPropertyChangeListener("asyncImageReady", this);
            newVideo.removePropertyChangeListener("asyncVideoReady", this);
            newVideo.addPropertyChangeListener("asyncVideoReady", this);
        }
        VideoClip prevClip = this.getPlayer().getVideoClip();
        VideoClip newClip = new VideoClip(newVideo);
        if (newVideo == null && prevClip != null) {
            XMLControlElement control = new XMLControlElement(prevClip);
            control.setValue("video", null);
            control.loadObject(newClip);
        }
        newClip.setPlayAllSteps(playAllSteps);
        this.getPlayer().setVideoClip(newClip);
        if (prev != null) {
            prev.dispose();
        }
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(double w) {
        BufferedImage vidImage;
        if (this.video != null && (vidImage = this.video.getImage()) != null) {
            w = Math.max(w, (double)vidImage.getWidth());
        }
        this.imageWidth = w;
    }

    public double getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(double h) {
        BufferedImage vidImage;
        if (this.video != null && (vidImage = this.video.getImage()) != null) {
            h = Math.max(h, (double)vidImage.getHeight());
        }
        this.imageHeight = h;
    }

    public double getImageBorder() {
        return this.imageBorder;
    }

    public void setImageBorder(double borderFraction) {
        this.imageBorder = borderFraction;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public boolean setTimeUnit(String unit) {
        if ("".equals(unit)) {
            unit = null;
        }
        if (unit == null) {
            return false;
        }
        if (this.timeUnit.equals(unit = unit.trim())) {
            return false;
        }
        try {
            Double.parseDouble(unit);
            return false;
        }
        catch (Exception exception) {
            this.timeUnit = unit;
            return true;
        }
    }

    public void setCoords(ImageCoordSystem newCoords) {
        if (this.video != null) {
            this.video.setCoords(newCoords);
        } else {
            this.coords = newCoords;
        }
    }

    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    public void setDataFile(File file) {
        File prev = this.dataFile;
        this.dataFile = file;
        if (file != null) {
            this.defaultFileName = XML.forwardSlash(file.getName());
        }
        this.firePropertyChange(PROPERTY_VIDEOPANEL_DATAFILE, prev, this.dataFile);
        OSPLog.fine("Data file: " + file);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public String getFilePath() {
        return this.defaultFileName;
    }

    public void setDrawingInImageSpace(boolean imagespace) {
        this.drawingInImageSpace = imagespace;
        if (imagespace) {
            this.setAutoscaleX(false);
            this.setAutoscaleY(false);
        } else {
            this.setAutoscaleX(true);
            this.setAutoscaleY(true);
        }
        this.firePropertyChange(PROPERTY_VIDEOPANEL_IMAGESPACE, null, (Object)imagespace);
        this.repaint();
    }

    public boolean isDrawingInImageSpace() {
        return this.drawingInImageSpace;
    }

    public VideoPlayer getPlayer() {
        return this.player;
    }

    public void setPlayerVisible(final boolean visible) {
        if (visible == this.playerVisible) {
            return;
        }
        Runnable setPlayerVis = new Runnable(){

            @Override
            public void run() {
                VideoPanel.this.playerVisible = visible;
                if (VideoPanel.this.playerVisible) {
                    VideoPanel.this.add((Component)VideoPanel.this.player, "South");
                } else {
                    VideoPanel.this.remove(VideoPanel.this.player);
                }
                VideoPanel.this.repaint();
            }
        };
        if (OSPRuntime.isJS) {
            setPlayerVis.run();
        } else {
            SwingUtilities.invokeLater(setPlayerVis);
        }
    }

    public boolean isPlayerVisible() {
        return this.playerVisible;
    }

    public int getStepNumber() {
        return this.getPlayer().getStepNumber();
    }

    public int getFrameNumber() {
        return this.getPlayer().getFrameNumber();
    }

    @Override
    public ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> list = super.getDrawables();
        if (this.isDrawingInImageSpace()) {
            for (Drawable d : list) {
                if (Trackable.class.isInstance(d)) continue;
                list.remove(d);
            }
        }
        return list;
    }

    @Override
    public synchronized ArrayList<Drawable> getDrawablesNoClone() {
        return this.getDrawables();
    }

    @Override
    public synchronized void addDrawable(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        if (drawable instanceof Video) {
            this.setVideo((Video)drawable);
        } else {
            super.addDrawable(drawable);
        }
        this.repaint();
    }

    @Override
    public synchronized void removeDrawable(Drawable drawable) {
        if (drawable == this.video) {
            this.setVideo(null);
        } else {
            super.removeDrawable(drawable);
        }
    }

    @Override
    public synchronized <T extends Drawable> void removeObjectsOfClass(Class<T> c) {
        if (this.video.getClass() == c) {
            this.setVideo(null);
        } else {
            super.removeObjectsOfClass(c);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.video != null) {
            super.addDrawable(this.video);
        }
    }

    public void addFilter(Class<? extends Filter> filterClass) {
        if (Filter.class.isAssignableFrom(filterClass)) {
            this.filterClasses.put(filterClass.getName(), filterClass);
        }
    }

    public void removeFilter(Class<?> filterClass) {
        if (Filter.class.isAssignableFrom(filterClass)) {
            this.filterClasses.remove(filterClass.getName());
        }
    }

    public void clearFilters() {
        this.filterClasses.clear();
    }

    public Map<String, Class<? extends Filter>> getFilters() {
        return this.filterClasses;
    }

    public void hideMouseBox() {
        this.setMessage(null, 0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[12] lbl104 : CaseStatement: default:\u000a, @NONE, blocks:[12] lbl104 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataTrack importData(Data data, Object source) {
        return null;
    }

    @Override
    protected void paintEverything(Graphics g) {
        if (this.playerVisible) {
            this.bottomGutter += this.player.height;
        }
        super.paintEverything(g);
        if (this.playerVisible) {
            this.bottomGutter -= this.player.height;
        }
    }

    @Override
    protected void scale(ArrayList<Drawable> drawables) {
        if (this.drawingInImageSpace) {
            this.xminPreferred = -this.imageBorder * this.imageWidth + this.xOffset;
            this.xmaxPreferred = this.imageWidth + this.imageBorder * this.imageWidth + this.xOffset;
            this.yminPreferred = this.imageHeight + this.imageBorder * this.imageHeight + this.yOffset;
            this.ymaxPreferred = -this.imageBorder * this.imageHeight + this.yOffset;
        }
        super.scale(drawables);
    }

    protected boolean checkImage() {
        Dimension d = this.getSize();
        if (this.playerVisible) {
            d.height -= this.player.height;
        }
        if (d.width <= 2 || d.height <= 2) {
            return false;
        }
        if (this.offscreenImage == null || d.width != this.offscreenImage.getWidth() || d.height != this.offscreenImage.getHeight()) {
            this.offscreenImage = new BufferedImage(d.width, d.height, 1);
        }
        return this.offscreenImage != null;
    }

    public Point2D getWorldMousePoint() {
        this.pt.setLocation(this.getMouseX(), this.getMouseY());
        if (this.isDrawingInImageSpace()) {
            int n = this.getFrameNumber();
            AffineTransform toWorld = this.getCoords().getToWorldTransform(n);
            toWorld.transform(this.pt, this.pt);
        }
        return this.pt;
    }

    public XYCoordinateStringBuilder getXYCoordinateStringBuilder(TPoint point) {
        return TPoint.xyStringBuilder;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setLoader(VideoIO.FinalizableLoader loader) {
        this.loader = loader;
    }

    public void setResourceLoading(Video video2) {
        this.videoLoading = video2;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getProgress() {
        return this.progress;
    }

    public void releaseResources() {
        if (this.videoLoading != null && this.videoLoading != this.video) {
            this.videoLoading.dispose();
        }
        if (this.video != null) {
            this.video.dispose();
        }
        this.video = null;
        this.videoLoading = null;
    }

    protected void offerReloadVM(String ext, String message) {
    }

    @Override
    public void dispose() {
        if (this.video != null) {
            this.video.removePropertyChangeListener("asyncImageReady", this);
            this.video.removePropertyChangeListener("asyncVideoReady", this);
        }
        this.video = null;
        if (this.coords != null) {
            this.coords.dispose();
        }
        this.coords = null;
        super.dispose();
    }

    public static class Loader
    implements XML.ObjectLoader,
    VideoIO.FinalizableLoader {
        public XMLControlElement control;
        public VideoClip clip;
        protected VideoPanel videoPanel;
        protected boolean finalized;

        @Override
        public Object createObject(XMLControl control) {
            return new VideoPanel();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            this.control = (XMLControlElement)control;
            this.videoPanel = (VideoPanel)obj;
            if (this.videoPanel.progress >= 80 || this.getClip(control)) {
                this.finalizeLoading();
            }
            return this.videoPanel;
        }

        public boolean getClip(XMLControl control) {
            Video video2;
            XMLControl child;
            if (!control.getPropertyNamesRaw().contains("videoclip")) {
                this.videoPanel.progress = 80;
                return true;
            }
            if (this.clip == null) {
                this.clip = (VideoClip)control.getObject("videoclip");
            }
            if (this.clip != null) {
                Video video3 = this.clip.getVideo();
                if (video3 instanceof IncrementallyLoadable) {
                    block14: {
                        XMLControl child2;
                        IncrementallyLoadable iVideo = (IncrementallyLoadable)((Object)this.clip.getVideo());
                        if (iVideo.getLoadableFrameCount() <= 1 && (child2 = control.getChildControl("videoclip")) != null && child2.getPropertyNamesRaw().contains("video_framecount")) {
                            int frameCount = child2.getInt("video_framecount");
                            iVideo.setLoadableFrameCount(frameCount);
                        }
                        if (!iVideo.loadMoreFrames(VideoIO.incrementToLoad)) break block14;
                        this.videoPanel.setResourceLoading(this.clip.getVideo());
                        this.videoPanel.framesLoaded = iVideo.getLoadedFrameCount();
                        this.videoPanel.progress = VideoIO.progressForFraction(iVideo.getLoadedFrameCount(), iVideo.getLoadableFrameCount());
                        return false;
                    }
                    try {
                        if (VideoIO.loadIncrementally) {
                            control.getObject("videoclip");
                        }
                        this.videoPanel.progress = 80;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (video3 instanceof AsyncVideoI) {
                    this.videoPanel.framesLoaded = ((AsyncVideoI)((Object)video3)).getLoadedFrameCount();
                    this.videoPanel.progress = ((AsyncVideoI)((Object)video3)).getProgress();
                } else {
                    this.videoPanel.progress = 80;
                }
            }
            if ((child = control.getChildControl("videoclip")) != null && !OSPRuntime.unzipFiles) {
                child.setBasepath(control.getBasepath());
            }
            if (this.clip != null && (video2 = this.clip.getVideo()) instanceof AsyncVideoI) {
                this.videoPanel.setLoader(this);
                video2.addPropertyChangeListener("asyncVideoReady", this.videoPanel);
                return false;
            }
            return true;
        }

        public Video finalizeClip() {
            Video video2;
            Video video3 = video2 = this.clip == null ? null : this.clip.getVideo();
            if (this.clip != null) {
                if (video2 instanceof AsyncVideoI) {
                    this.clip.loader.finalizeLoading();
                }
                this.videoPanel.getPlayer().setVideoClip(this.clip);
            }
            return video2;
        }

        @Override
        public void finalizeLoading() {
            this.videoPanel.setLoader(null);
            this.finalizeClip();
            this.videoPanel.setCoords((ImageCoordSystem)this.control.getObject("coords"));
            Collection drawables = (Collection)this.control.getObject("drawables");
            if (drawables != null) {
                Iterator it = drawables.iterator();
                while (it.hasNext()) {
                    this.videoPanel.addDrawable((Drawable)it.next());
                }
            }
        }

        @Override
        public boolean isFinalized() {
            return this.finalized;
        }

        public void finalize() {
            OSPLog.finalized(this);
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            VideoPanel vidPanel = (VideoPanel)obj;
            control.setValue("videoclip", vidPanel.getPlayer().getVideoClip());
            control.setValue("coords", vidPanel.getCoords());
            ArrayList<Drawable> list = vidPanel.getDrawables();
            list.remove(vidPanel.getVideo());
            if (!list.isEmpty()) {
                control.setValue("drawables", list);
            }
        }

        public void dispose() {
            this.control.dispose();
            this.control = null;
            this.videoPanel = null;
            this.finalized = true;
        }
    }
}

