/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPButton;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoPlayer
extends JComponent
implements PropertyChangeListener {
    private static final String SLIDER_REFRESH = "refresh";
    private static final String SLIDER_PROPERTY = "property";
    private static final String SLIDER_NEWCLIP = "newClip";
    public static final String PROPERTY_VIDEOPLAYER_BACKBUTTON = "backbutton";
    public static final String PROPERTY_VIDEOPLAYER_PLAYING = "playing";
    public static final String PROPERTY_VIDEOPLAYER_SLIDER = "slider";
    public static final String PROPERTY_VIDEOPLAYER_STEPBUTTON = "stepbutton";
    public static final String PROPERTY_VIDEOPLAYER_FRAMEDURATION = "frameduration";
    public static final String PROPERTY_VIDEOPLAYER_STEPNUMBER = "stepnumber";
    public static final String PROPERTY_VIDEOPLAYER_VIDEOCLIP = "videoclip";
    protected static Icon inOutIcon;
    protected static Icon playIcon;
    protected static Icon grayPlayIcon;
    protected static Icon pauseIcon;
    protected static Icon resetIcon;
    protected static Icon loopIcon;
    protected static Icon noloopIcon;
    protected static Icon videoClipIcon;
    protected static Icon stepIcon;
    protected static Icon grayStepIcon;
    protected static Icon backIcon;
    protected static Icon grayBackIcon;
    private static GoToDialog goToDialog;
    private static NumberFormat timeFormat;
    protected VideoPanel vidPanel;
    protected ClipControl clipControl;
    private String[] readoutTypes;
    private String readoutType;
    private boolean inspectorButtonVisible = true;
    protected int height = 54;
    private JToolBar toolbar;
    protected OSPButton readout;
    protected OSPButton playButton;
    protected OSPButton resetButton;
    private JSpinner rateSpinner;
    private OSPButton stepButton;
    private OSPButton stepSizeButton;
    private OSPButton backButton;
    private OSPButton loopButton;
    private OSPButton inspectorButton;
    private JSlider slider;
    private Hashtable<Integer, JLabel> sliderLabels;
    private JLabel inLabel;
    private JLabel outLabel;
    private ActionListener readoutListener;
    private ActionListener timeSetListener;
    private ActionListener goToListener;
    private String sliderCaret;
    private boolean disabled = false;
    private int mouseX;
    private int maxEndFrame;
    private int sliderInset;
    private ActionListener popupItemListener;
    private boolean playStarted;
    private boolean ignoreRateSpinner;
    private Timer slowRateTimer;
    private Color defaultSpinnerColor;
    private static Color slowSpinnerColor;
    private static Color cautionSpinnerColor;
    private double measuredRate;
    private static int ntest;
    protected ActionListener stepSizeBtnListener = e -> {
        VideoClip clip;
        int frameNumber;
        block3: {
            frameNumber = this.getFrameNumber();
            clip = this.getVideoClip();
            try {
                clip.setStepSize(Integer.parseInt(e.getActionCommand()));
            }
            catch (NumberFormatException ex) {
                String cur = String.valueOf(this.getVideoClip().getStepSize());
                String input = GUIUtils.showInputDialog(this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.StepSize.Message"), MediaRes.getString("VideoPlayer.Dialog.StepSize.Title"), -1, cur);
                if (input == null) break block3;
                int n = Integer.parseInt(input);
                clip.setStepSize(n);
            }
        }
        this.setStepNumber(clip.frameToStep(frameNumber));
        if (clip.inspector != null && clip.inspector.isVisible()) {
            clip.inspector.stepSizeField.setValue(clip.getStepSize());
        }
    };

    static {
        timeFormat = NumberFormat.getNumberInstance();
        String path = "/org/opensourcephysics/resources/media/images/in_out.gif";
        inOutIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/play.gif";
        playIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/play_gray.gif";
        grayPlayIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/pause.gif";
        pauseIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/reset.gif";
        resetIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/looping_on.gif";
        loopIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/looping_off.gif";
        noloopIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/video_clip.gif";
        videoClipIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/step.gif";
        stepIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/step_gray.gif";
        grayStepIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/back.gif";
        backIcon = ResourceLoader.getResizableIcon(path);
        path = "/org/opensourcephysics/resources/media/images/back_gray.gif";
        grayBackIcon = ResourceLoader.getResizableIcon(path);
        slowSpinnerColor = Color.red;
        cautionSpinnerColor = new Color(200, 80, 60);
    }

    public void addActionListener(PropertyChangeListener c) {
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_BACKBUTTON, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_PLAYING, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_SLIDER, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_STEPBUTTON, c);
    }

    public void removeActionListener(PropertyChangeListener c) {
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_BACKBUTTON, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_PLAYING, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_SLIDER, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_STEPBUTTON, c);
    }

    public void addFrameListener(PropertyChangeListener c) {
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_FRAMEDURATION, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_STEPNUMBER, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOPLAYER_VIDEOCLIP, c);
    }

    public void removeFrameListener(PropertyChangeListener c) {
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_FRAMEDURATION, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_STEPNUMBER, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOPLAYER_VIDEOCLIP, c);
    }

    public VideoPlayer(VideoPanel panel, VideoClip clip) {
        this(panel);
        this.setVideoClip(clip);
    }

    public VideoPlayer(VideoPanel panel) {
        this.vidPanel = panel;
        timeFormat.setMinimumIntegerDigits(1);
        timeFormat.setMaximumFractionDigits(3);
        timeFormat.setMinimumFractionDigits(3);
        if (timeFormat instanceof DecimalFormat) {
            ((DecimalFormat)timeFormat).setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        }
        this.createGUI();
        this.clipControl = ClipControl.getControl(new VideoClip(null));
        this.clipControl.addPropertyChangeListener(this);
        this.getVideoClip().addPropertyChangeListener(this);
        this.updatePlayButtonsLater(false);
        this.updateSlider(SLIDER_REFRESH, null);
    }

    public void setVideoClip(VideoClip clip) {
        boolean playing = this.clipControl.isPlaying();
        this.stop();
        if (this.getVideoClip() == clip) {
            ClipInspector inspector;
            boolean looping = this.clipControl.isLooping();
            double rate = this.clipControl.getRate();
            double duration = this.clipControl.getMeanFrameDuration();
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(clip);
            this.clipControl.addPropertyChangeListener(this);
            this.clipControl.setLooping(looping);
            this.clipControl.setRate(rate);
            this.clipControl.setFrameDuration(duration);
            if (playing) {
                this.clipControl.play();
            }
            if ((inspector = this.getVideoClip().inspector) != null) {
                inspector.clipControl = this.clipControl;
            }
        } else {
            VideoClip oldClip = this.getVideoClip();
            oldClip.removePropertyChangeListener(this);
            oldClip.hideClipInspector();
            oldClip.dispose();
            Video video2 = oldClip.getVideo();
            if (video2 != null) {
                video2.dispose();
            }
            oldClip.video = null;
            oldClip.removePropertyChangeListener(this);
            if (clip == null) {
                clip = new VideoClip(null);
            }
            clip.addPropertyChangeListener(this);
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(clip);
            this.clipControl.addPropertyChangeListener(this);
            this.setReadoutTypes("frame time step", clip.readoutType);
            this.updateLoopButton(this.clipControl.isLooping());
            this.updateValueAndPlayButtons();
            this.updateSlider(SLIDER_NEWCLIP, oldClip);
            System.gc();
        }
    }

    public VideoClip getVideoClip() {
        return this.clipControl == null ? null : this.clipControl.getVideoClip();
    }

    public ClipControl getClipControl() {
        return this.clipControl;
    }

    public void setReadoutTypes(String types, String typeToSelect) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        String list = types.toLowerCase();
        int i = list.indexOf("time");
        if (i >= 0) {
            map.put(i, "time");
        }
        if ((i = list.indexOf("step")) >= 0) {
            map.put(i, "step");
        }
        if ((i = list.indexOf("frame")) >= 0) {
            map.put(i, "frame");
        }
        if (map.isEmpty()) {
            return;
        }
        this.readoutTypes = map.values().toArray(new String[0]);
        if (typeToSelect == null) {
            typeToSelect = this.readoutTypes[0];
        }
        this.setReadoutType(typeToSelect);
    }

    public void setReadoutType(String type) {
        String name = type.toLowerCase();
        String tip = " " + MediaRes.getString("VideoPlayer.Readout.ToolTip");
        if (name.indexOf("time") >= 0) {
            this.readoutType = "time";
            String t = this.vidPanel.getTimeUnit();
            t = String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Time")) + " " + t;
            this.readout.setToolTipText(String.valueOf(t) + tip);
        } else if (name.indexOf("step") >= 0) {
            this.readoutType = "step";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Step")) + tip);
        } else if (name.indexOf("frame") >= 0) {
            this.readoutType = "frame";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Frame")) + tip);
        }
        boolean isListed = false;
        int i = 0;
        while (i < this.readoutTypes.length) {
            isListed = isListed || this.readoutTypes[i].equals(this.readoutType);
            ++i;
        }
        if (!isListed) {
            String[] newList = new String[this.readoutTypes.length + 1];
            newList[0] = this.readoutType;
            int i2 = 0;
            while (i2 < this.readoutTypes.length) {
                newList[i2 + 1] = this.readoutTypes[i2];
                ++i2;
            }
            this.readoutTypes = newList;
        }
        this.getVideoClip().readoutType = this.readoutType;
        this.updateValue();
    }

    public void play() {
        this.clipControl.play();
    }

    public void stop() {
        this.clipControl.stop();
    }

    public void step() {
        this.stop();
        this.clipControl.step();
    }

    public void back() {
        this.stop();
        this.clipControl.back();
    }

    public void setRate(double rate) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.rateSpinner.getEditor();
        boolean caution = this.measuredRate < rate * 0.9 && this.measuredRate > 0.0;
        editor.getTextField().setForeground(caution ? cautionSpinnerColor : this.defaultSpinnerColor);
        this.clipControl.setRate(rate);
    }

    public double getRate() {
        return this.clipControl.getRate();
    }

    public void setLooping(boolean looping) {
        if (this.isEnabled()) {
            this.clipControl.setLooping(looping);
        }
    }

    public boolean isLooping() {
        return this.clipControl.isLooping();
    }

    public void setStepNumber(int n) {
        this.clipControl.setStepNumber(n);
    }

    public int getStepNumber() {
        return this.clipControl.getStepNumber();
    }

    public int getFrameNumber() {
        return this.clipControl.getFrameNumber();
    }

    public double getTime() {
        return this.clipControl.getTime() + this.clipControl.clip.getStartTime();
    }

    public double getStepTime(int stepNumber) {
        if (stepNumber < 0 || stepNumber >= this.clipControl.clip.getStepCount()) {
            return Double.NaN;
        }
        return this.clipControl.getStepTime(stepNumber) + this.clipControl.clip.getStartTime();
    }

    public double getFrameTime(int frameNumber) {
        return this.clipControl.clip.getStartTime() + (double)(frameNumber - this.clipControl.clip.getStartFrameNumber()) * this.clipControl.getMeanFrameDuration();
    }

    public double getMeanStepDuration() {
        double duration = this.getClipControl().getMeanFrameDuration() * (double)this.getVideoClip().getStepSize();
        return duration;
    }

    public void setInspectorButtonVisible(final boolean visible) {
        if (visible == this.inspectorButtonVisible) {
            return;
        }
        this.inspectorButtonVisible = visible;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.this.toolbar == null) {
                    return;
                }
                if (visible) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.inspectorButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.inspectorButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        if (OSPRuntime.isJS) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public void setLoopingButtonVisible(final boolean visible) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (visible) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.loopButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.loopButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        if (OSPRuntime.isJS) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "stepnumber": {
                this.updateValueAndPlayButtons();
                this.firePropertyChange(PROPERTY_VIDEOPLAYER_STEPNUMBER, null, e.getNewValue());
                return;
            }
            case "frameduration": {
                this.updateValue();
                this.firePropertyChange(PROPERTY_VIDEOPLAYER_FRAMEDURATION, null, e.getNewValue());
                return;
            }
            case "playing": {
                if (!((Boolean)e.getNewValue()).booleanValue() && this.playStarted) {
                    this.playStarted = false;
                    this.measuredRate = this.clipControl.getMeasuredRate();
                    JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.rateSpinner.getEditor();
                    if (this.measuredRate / this.getRate() < 0.9) {
                        this.ignoreRateSpinner = true;
                        this.rateSpinner.setValue(this.measuredRate);
                        editor.getTextField().setForeground(slowSpinnerColor);
                        this.slowRateTimer.restart();
                    } else {
                        this.measuredRate = 0.0;
                        editor.getTextField().setForeground(this.defaultSpinnerColor);
                    }
                }
                this.updatePlayButtonsLater((Boolean)e.getNewValue());
                this.firePropertyChange(PROPERTY_VIDEOPLAYER_PLAYING, null, e.getNewValue());
                return;
            }
            case "looping": {
                this.updateLoopButton((Boolean)e.getNewValue());
                return;
            }
            case "rate": {
                this.rateSpinner.setValue(this.getRate());
                return;
            }
            case "starttime": {
                this.updateValue();
                return;
            }
            default: {
                return;
            }
            case "stepsize": {
                this.updateValue();
                break;
            }
            case "stepcount": {
                this.updateValueAndPlayButtons();
            }
            case "startframe": 
            case "framecount": 
        }
        this.updateSlider(SLIDER_PROPERTY, e.getPropertyName());
    }

    public void refresh() {
        if (this.readoutType == null) {
            return;
        }
        this.stepButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepForward.ToolTip"));
        this.backButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepBack.ToolTip"));
        this.resetButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Reset.ToolTip"));
        this.inspectorButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
        this.loopButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Looping.ToolTip"));
        this.setReadoutType(this.readoutType);
        this.updatePlayButtonsLater(this.clipControl.isPlaying());
        this.updateLoopButton(this.clipControl.isLooping());
        if (this.getVideoClip().inspector != null) {
            this.getVideoClip().inspector.refresh();
        }
    }

    @Override
    public void setLocale(Locale locale) {
        timeFormat = NumberFormat.getNumberInstance(locale);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.rateSpinner.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.disabled = !enabled;
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (!OSPRuntime.isJS) {
            super.paintChildren(g);
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.playButton = new OSPButton(playIcon, pauseIcon);
        this.playButton.setDisabledIcon(grayPlayIcon);
        this.playButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.doPlay();
            }
        });
        this.playButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    VideoPlayer.this.doPlay();
                }
            }
        });
        this.resetButton = new OSPButton(resetIcon);
        this.resetButton.setPressedIcon(resetIcon);
        this.resetButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.doReset();
            }
        });
        double minRate = 0.1;
        double maxRate = 4.0;
        SpinnerNumberModel model = new SpinnerNumberModel(1.0, 0.1, 4.0, 0.1);
        this.rateSpinner = new JSpinner(model){

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = Math.max(VideoPlayer.this.playButton.getPreferredSize().height, dim.height);
                dim.width = 5 * this.getFont().getSize() - 10 * FontSizer.getLevel();
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        final JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.rateSpinner, "0%");
        editor.getTextField().setHorizontalAlignment(2);
        editor.getTextField().setFont(new Font("Dialog", 0, 12));
        this.defaultSpinnerColor = editor.getTextField().getForeground();
        this.rateSpinner.setEditor(editor);
        this.rateSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (VideoPlayer.this.ignoreRateSpinner) {
                    return;
                }
                Double rate = (Double)VideoPlayer.this.rateSpinner.getValue();
                VideoPlayer.this.setRate(rate);
            }
        });
        editor.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    double prev = (Double)VideoPlayer.this.rateSpinner.getValue();
                    try {
                        String s = editor.getTextField().getText();
                        if (s.endsWith("%")) {
                            s = s.substring(0, s.length() - 1);
                        }
                        int i = Integer.parseInt(s);
                        double rate = Math.max((double)i / 100.0, 0.1);
                        if ((rate = Math.min(rate, 4.0)) != prev) {
                            VideoPlayer.this.rateSpinner.setValue(rate);
                        } else {
                            int r = (int)(prev * 100.0);
                            editor.getTextField().setText(String.valueOf(String.valueOf(r)) + "%");
                        }
                    }
                    catch (NumberFormatException ex) {
                        int r = (int)(prev * 100.0);
                        editor.getTextField().setText(String.valueOf(String.valueOf(r)) + "%");
                    }
                    editor.getTextField().selectAll();
                }
            }
        });
        this.stepButton = new OSPButton(stepIcon);
        this.stepButton.setDisabledIcon(grayStepIcon);
        this.stepButton.addActionListener((ActionEvent e) -> this.doStepButton((e.getModifiers() & 1) == 1));
        this.backButton = new OSPButton(backIcon);
        this.backButton.setDisabledIcon(grayBackIcon);
        this.backButton.addActionListener((ActionEvent e) -> this.doBackButton((e.getModifiers() & 1) == 1));
        MouseAdapter stepListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.fireButtonEvent(e.getSource() == VideoPlayer.this.stepButton ? VideoPlayer.PROPERTY_VIDEOPLAYER_STEPBUTTON : VideoPlayer.PROPERTY_VIDEOPLAYER_BACKBUTTON, true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.fireButtonEvent(e.getSource() == VideoPlayer.this.stepButton ? VideoPlayer.PROPERTY_VIDEOPLAYER_STEPBUTTON : VideoPlayer.PROPERTY_VIDEOPLAYER_BACKBUTTON, false);
            }
        };
        this.stepButton.addMouseListener(stepListener);
        this.backButton.addMouseListener(stepListener);
        this.readoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPlayer.this.setReadoutType(e.getActionCommand());
            }
        };
        this.goToListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPlayer.this.showGoToDialog();
            }
        };
        this.timeSetListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipInspector inspector;
                VideoClip clip = VideoPlayer.this.getVideoClip();
                String time = " (" + VideoPlayer.this.vidPanel.getTimeUnit() + "):";
                String response = GUIUtils.showInputDialog(VideoPlayer.this.vidPanel, String.valueOf(MediaRes.getString("VideoPlayer.Dialog.SetTime.Message")) + time, String.valueOf(MediaRes.getString("VideoPlayer.Dialog.SetTime.Title")) + " " + VideoPlayer.this.getFrameNumber(), -1, "" + VideoPlayer.this.getTime() / 1000.0);
                if (response != null) {
                    if (response.equals("")) {
                        clip.setStartTime(Double.NaN);
                    } else {
                        try {
                            double t = Double.parseDouble(response);
                            double t0 = t * 1000.0 - VideoPlayer.this.clipControl.getTime();
                            clip.setStartTime(t0);
                        }
                        catch (NumberFormatException t) {
                            // empty catch block
                        }
                    }
                }
                if ((inspector = clip.inspector) != null && inspector.isVisible()) {
                    inspector.t0Field.setValue(clip.getStartTime() / 1000.0);
                }
            }
        };
        this.slider = new JSlider(0, 9, 0);
        this.slider.setName(PROPERTY_VIDEOPLAYER_SLIDER + ++ntest);
        this.slider.setOpaque(false);
        this.slider.setMinorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.slider.addChangeListener(e -> this.doSliderChanged());
        this.inLabel = new JLabel(inOutIcon);
        this.outLabel = new JLabel(inOutIcon);
        this.sliderLabels = new Hashtable();
        this.sliderLabels.put(0, this.inLabel);
        this.sliderLabels.put(9, this.outLabel);
        this.slider.setLabelTable(this.sliderLabels);
        this.slider.setPaintLabels(true);
        MouseListener defaultUIMouseListener = this.slider.getMouseListeners()[0];
        MouseMotionListener defaultUIMouseMotionListener = this.slider.getMouseMotionListeners()[0];
        this.slider.removeMouseListener(defaultUIMouseListener);
        this.slider.removeMouseMotionListener(defaultUIMouseMotionListener);
        MouseInputAdapter inOutSetter = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                VideoPlayer.this.sliderMovedAction(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.sliderPressedAction(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                VideoPlayer.this.sliderDraggedAction(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VideoPlayer.this.sliderReleasedAction(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                VideoPlayer.this.fireButtonEvent(VideoPlayer.PROPERTY_VIDEOPLAYER_SLIDER, false);
            }
        };
        this.slider.addMouseListener(inOutSetter);
        this.slider.addMouseMotionListener(inOutSetter);
        if (defaultUIMouseListener != null) {
            this.slider.addMouseListener(defaultUIMouseListener);
        }
        if (defaultUIMouseMotionListener != null) {
            this.slider.addMouseMotionListener(defaultUIMouseMotionListener);
        }
        InputMap im = this.slider.getInputMap(0);
        ActionMap am = SwingUtilities.getUIActionMap(this.slider);
        if (am != null) {
            am.put(im.get(KeyStroke.getKeyStroke(33, 0)), null);
            am.put(im.get(KeyStroke.getKeyStroke(34, 0)), null);
        }
        this.slider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                VideoPlayer.this.doSliderKey(e.getKeyCode());
            }
        });
        this.readout = new OSPButton();
        this.readout.setHeightComponent(this.rateSpinner);
        this.readout.setText("0.00");
        this.readout.setForeground(new Color(204, 51, 51));
        this.readout.addActionListener((ActionEvent e) -> this.doReadoutPopup());
        this.readout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    VideoPlayer.this.readout.doClick(0);
                }
            }
        });
        this.stepSizeButton = new OSPButton();
        this.stepSizeButton.setHeightComponent(this.rateSpinner);
        this.stepSizeButton.setText("1");
        this.stepSizeButton.setForeground(new Color(204, 51, 51));
        this.stepSizeButton.addActionListener((ActionEvent e) -> this.doStepSize());
        this.stepSizeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    VideoPlayer.this.stepSizeButton.doClick(0);
                }
            }
        });
        this.inspectorButton = new OSPButton(videoClipIcon);
        this.inspectorButton.addActionListener((ActionEvent e) -> this.doInspector());
        this.loopButton = new OSPButton(noloopIcon, loopIcon);
        this.loopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
            }
        });
        this.loopButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
                }
            }
        });
        this.toolbar.add(this.readout);
        this.toolbar.add(this.rateSpinner);
        this.toolbar.add(this.resetButton);
        this.toolbar.add(this.playButton);
        this.toolbar.add(this.slider);
        this.toolbar.add(this.backButton);
        this.toolbar.add(this.stepSizeButton);
        this.toolbar.add(this.stepButton);
        this.toolbar.add(this.loopButton);
        if (this.inspectorButtonVisible) {
            this.toolbar.add(this.inspectorButton);
        }
        this.slowRateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSpinner.NumberEditor editor = (JSpinner.NumberEditor)VideoPlayer.this.rateSpinner.getEditor();
                editor.getTextField().setForeground(cautionSpinnerColor);
                VideoPlayer.this.rateSpinner.setValue(VideoPlayer.this.getRate());
                VideoPlayer.this.ignoreRateSpinner = false;
            }
        });
        this.slowRateTimer.setRepeats(false);
    }

    protected void doSliderKey(int keyCode) {
        if (this.disabled) {
            return;
        }
        switch (keyCode) {
            case 33: {
                this.back();
                break;
            }
            case 34: {
                this.step();
            }
        }
    }

    protected void doPlay() {
        if (this.disabled || !this.playButton.isEnabled()) {
            return;
        }
        if (this.playButton.isSelected()) {
            this.stop();
        } else {
            this.playStarted = true;
            this.play();
        }
    }

    protected void doReset() {
        if (this.disabled) {
            return;
        }
        this.stop();
        this.clipControl.setStepNumber(0);
        this.updatePlayButtonsLater(false);
    }

    protected void fireButtonEvent(String name, boolean b) {
        if (this.disabled) {
            return;
        }
        this.firePropertyChange(name, null, (Object)b);
    }

    private void doBackButton(boolean isShiftDown) {
        if (this.disabled) {
            return;
        }
        if (isShiftDown) {
            this.stop();
            this.setStepNumber(this.getStepNumber() - 5);
        } else {
            this.back();
        }
    }

    private void doStepButton(boolean isShiftDown) {
        if (this.disabled) {
            return;
        }
        if (isShiftDown) {
            this.stop();
            this.setStepNumber(this.getStepNumber() + 5);
        } else {
            this.step();
        }
    }

    private void doStepSize() {
        if (this.disabled) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        int i = 1;
        while (i < 6) {
            JMenuItem item = new JMenuItem(String.valueOf(i));
            item.addActionListener(this.stepSizeBtnListener);
            popup.add(item);
            ++i;
        }
        popup.addSeparator();
        JMenuItem item = new JMenuItem(MediaRes.getString("VideoPlayer.Button.StepSize.Other"));
        item.addActionListener(this.stepSizeBtnListener);
        popup.add(item);
        FontSizer.setFonts(popup);
        popup.show(this.stepSizeButton, 0, this.stepSizeButton.getHeight());
    }

    private void doInspector() {
        ClipInspector inspector;
        if (this.disabled) {
            return;
        }
        Frame frame = null;
        Container c = this.vidPanel.getTopLevelAncestor();
        if (c instanceof Frame) {
            frame = (Frame)c;
        }
        if ((inspector = this.getVideoClip().getClipInspector(this.clipControl, frame)).isVisible()) {
            return;
        }
        Point p0 = new Frame().getLocation();
        Point loc = inspector.getLocation();
        if (loc.x == p0.x && loc.y == p0.y) {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - inspector.getBounds().width) / 2;
            int y = (dim.height - inspector.getBounds().height) / 2;
            inspector.setLocation(x, y);
        }
        inspector.initialize();
        inspector.setVisible(true);
    }

    private void doReadoutPopup() {
        if (this.disabled || this.readoutTypes.length < 2) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        JMenu displayMenu = new JMenu(MediaRes.getString("VideoPlayer.Readout.Menu.Display"));
        popup.add(displayMenu);
        int i = 0;
        while (i < this.readoutTypes.length) {
            JMenuItem item;
            String type = this.readoutTypes[i];
            if (type.equals("step")) {
                item = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Step"));
                item.setSelected(type.equals(this.readoutType));
                item.setActionCommand(type);
                item.addActionListener(this.readoutListener);
                displayMenu.add(item);
            } else if (type.equals("time")) {
                item = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Time"));
                item.setSelected(type.equals(this.readoutType));
                item.setActionCommand(type);
                item.addActionListener(this.readoutListener);
                displayMenu.add(item);
                popup.addSeparator();
                if (this.getTime() != 0.0) {
                    String s = MediaRes.getString("VideoPlayer.Popup.Menu.SetTimeToZero");
                    item = new JMenuItem(s);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (VideoPlayer.this.disabled) {
                                return;
                            }
                            double t0 = -VideoPlayer.this.clipControl.getTime();
                            VideoPlayer.this.getVideoClip().setStartTime(t0);
                        }
                    });
                    item.addActionListener(this.readoutListener);
                    popup.add(item);
                }
                item = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                item.setActionCommand(type);
                item.addActionListener(this.timeSetListener);
                item.addActionListener(this.readoutListener);
                popup.add(item);
                item = new JMenuItem(String.valueOf(MediaRes.getString("VideoPlayer.Readout.Menu.GoTo")) + "...");
                item.setActionCommand(type);
                item.addActionListener(this.goToListener);
                popup.add(item);
            } else {
                item = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Frame"));
                item.setSelected(type.equals(this.readoutType));
                item.setActionCommand(type);
                item.addActionListener(this.readoutListener);
                displayMenu.add(item);
            }
            ++i;
        }
        FontSizer.setFonts(popup);
        popup.show(this.readout, 0, this.readout.getHeight());
    }

    private void doSliderChanged() {
        if (this.clipControl.isPlaying()) {
            return;
        }
        VideoClip clip = this.getVideoClip();
        int i = this.slider.getValue();
        if (i < clip.getStartFrameNumber()) {
            this.slider.setValue(clip.getStartFrameNumber());
            return;
        }
        if (i > clip.getEndFrameNumber()) {
            this.slider.setValue(clip.getEndFrameNumber());
            return;
        }
        OSPRuntime.setTimeout("VP-sliderState", 25, true, () -> {
            int stepNo = clip.frameToStep(i);
            int frameNo = clip.stepToFrame(stepNo);
            int currentStep = this.getStepNumber();
            boolean isIncluded = clip.includesFrame(i);
            if (stepNo != currentStep && !this.disabled) {
                this.setStepNumber(stepNo);
                return;
            }
            if (!isIncluded) {
                this.slider.setValue(frameNo);
                return;
            }
        });
    }

    protected void sliderMovedAction(MouseEvent e) {
        this.sliderCaret = null;
        if (this.disabled) {
            return;
        }
        int yMin = this.slider.getHeight() - this.inLabel.getHeight() - 2;
        if (this.sliderInset == 0) {
            this.sliderInset = this.slider.getInsets().left + 7;
        }
        if (e.getY() > yMin) {
            int end;
            int xend;
            int x = e.getX();
            VideoClip clip = this.getVideoClip();
            double pixPerFrame = ((double)this.slider.getWidth() - 2.0 * (double)this.sliderInset) / (double)(clip.getFrameCount() - 1);
            String hint = " " + MediaRes.getString("VideoPlayer.InOutMarker.ToolTip");
            int start = this.getVideoClip().getStartFrameNumber();
            int xstart = (int)((double)this.sliderInset + (double)start * pixPerFrame);
            if ((xstart != (xend = (int)((double)this.sliderInset + (double)(end = this.getVideoClip().getEndFrameNumber()) * pixPerFrame)) || start == 0) && x < xend + 8 && x > xend - 8) {
                this.sliderCaret = "out";
                this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + end + hint);
            } else if (x < xstart + 8 && x > xstart - 8) {
                this.sliderCaret = "in";
                this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + start + hint);
            }
        }
        if (this.sliderCaret == null) {
            this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
            this.slider.setToolTipText(MediaRes.getString("VideoPlayer.Slider.ToolTip"));
        } else {
            this.vidPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
            e.consume();
        }
    }

    protected void sliderPressedAction(MouseEvent e) {
        block24: {
            if (this.disabled) {
                return;
            }
            this.stop();
            int frameNum = this.clipControl.getFrameNumber();
            this.maxEndFrame = this.getVideoClip().getEndFrameNumber();
            int start = this.getVideoClip().getStartFrameNumber();
            int end = this.getVideoClip().getEndFrameNumber();
            if (this.sliderCaret == "out" && frameNum < start) {
                this.sliderCaret = "in";
            } else if (this.sliderCaret == "in" && frameNum > end) {
                this.sliderCaret = "out";
            }
            if (OSPRuntime.isPopupTrigger(e)) {
                String s;
                JPopupMenu popup = new JPopupMenu();
                JMenuItem item = new JMenuItem(String.valueOf(MediaRes.getString("ClipInspector.Title")) + "...");
                item.addActionListener((ActionEvent ea) -> {
                    ClipInspector inspector;
                    if (this.disabled) {
                        return;
                    }
                    Frame frame = null;
                    Container c = this.vidPanel.getTopLevelAncestor();
                    if (c instanceof Frame) {
                        frame = (Frame)c;
                    }
                    if ((inspector = this.getVideoClip().getClipInspector(this.clipControl, frame)).isVisible()) {
                        return;
                    }
                    Point p0 = new Frame().getLocation();
                    Point loc = inspector.getLocation();
                    if (loc.x == p0.x && loc.y == p0.y) {
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        int x = (dim.width - inspector.getBounds().width) / 2;
                        int y = (dim.height - inspector.getBounds().height) / 2;
                        inspector.setLocation(x, y);
                    }
                    inspector.initialize();
                    inspector.setVisible(true);
                });
                popup.add(item);
                popup.addSeparator();
                boolean showTrim = false;
                if ((this.getVideoClip().getVideo() == null || this.getVideoClip().getVideo().getFrameCount() == 1) && this.getVideoClip().getFrameCount() > this.getVideoClip().getEndFrameNumber() + 1) {
                    showTrim = true;
                }
                if (showTrim) {
                    String s2 = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.TrimFrames");
                    item = new JMenuItem(s2);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            VideoPlayer.this.getVideoClip().trimFrameCount();
                        }
                    });
                    popup.add(item);
                    popup.addSeparator();
                }
                if (this.popupItemListener == null) {
                    this.popupItemListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            VideoClip clip = VideoPlayer.this.getVideoClip();
                            int val = VideoPlayer.this.clipControl.getFrameNumber();
                            if ("in".equals(e.getActionCommand())) {
                                clip.setStartFrameNumber(val, VideoPlayer.this.maxEndFrame);
                                if (clip.inspector != null && clip.inspector.isVisible()) {
                                    clip.inspector.startField.setValue(clip.getStartFrameNumber());
                                }
                            } else {
                                clip.setEndFrameNumber(val);
                                if (clip.inspector != null && clip.inspector.isVisible()) {
                                    clip.inspector.endField.setValue(clip.getEndFrameNumber());
                                }
                            }
                            VideoPlayer.this.refresh();
                        }
                    };
                }
                boolean isIn = "in".equals(this.sliderCaret);
                if (this.sliderCaret == null || isIn) {
                    s = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetIn");
                    s = String.valueOf(s) + " (" + frameNum + ")";
                    item = new JMenuItem(s);
                    item.setActionCommand("in");
                    item.addActionListener(this.popupItemListener);
                    popup.add(item);
                }
                if (!isIn) {
                    this.sliderCaret = "out";
                    s = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetOut");
                    s = String.valueOf(s) + " (" + frameNum + ")";
                    item = new JMenuItem(s);
                    item.setActionCommand("out");
                    item.addActionListener(this.popupItemListener);
                    popup.add(item);
                }
                this.sliderCaret = null;
                boolean includeTimeItems = false;
                String[] stringArray = this.readoutTypes;
                int n = this.readoutTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (type.equals("time")) {
                        includeTimeItems = true;
                    }
                    ++n2;
                }
                if (includeTimeItems) {
                    popup.addSeparator();
                    if (this.getTime() != 0.0) {
                        String s3 = MediaRes.getString("VideoPlayer.Popup.Menu.SetTimeToZero");
                        item = new JMenuItem(s3);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (VideoPlayer.this.disabled) {
                                    return;
                                }
                                double t0 = -VideoPlayer.this.clipControl.getTime();
                                VideoPlayer.this.getVideoClip().setStartTime(t0);
                            }
                        });
                        item.addActionListener(this.readoutListener);
                        popup.add(item);
                    }
                    item = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                    item.setActionCommand("time");
                    item.addActionListener(this.timeSetListener);
                    item.addActionListener(this.readoutListener);
                    popup.add(item);
                }
                FontSizer.setFonts(popup);
                popup.show(this.slider, e.getX(), e.getY());
                return;
            }
            if (this.sliderCaret == null) break block24;
            this.stop();
            this.mouseX = e.getX();
            switch (this.sliderCaret) {
                case "in": {
                    this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + start);
                    if (start == frameNum) break;
                    SwingUtilities.invokeLater(() -> this.slider.setValue(start));
                    break;
                }
                case "out": {
                    this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + end);
                    if (end == frameNum) break;
                    SwingUtilities.invokeLater(() -> this.slider.setValue(end));
                }
            }
            e.consume();
        }
    }

    protected void sliderDraggedAction(MouseEvent e) {
        if (this.disabled || this.sliderCaret == null) {
            return;
        }
        VideoClip clip = this.getVideoClip();
        clip.setAdjusting(true);
        int start = clip.getStartFrameNumber();
        int end = clip.getEndFrameNumber();
        boolean increasing = e.getX() > this.mouseX;
        this.mouseX = e.getX();
        int lastFrame = clip.getFrameCount() - 1;
        int val = Math.round(lastFrame * (e.getX() - this.sliderInset) / (this.slider.getWidth() - 2 * this.sliderInset));
        if (start == end) {
            this.sliderCaret = increasing ? "out" : "in";
        }
        val = increasing ? Math.min(val, lastFrame + this.getVideoClip().getStepSize()) : Math.min(val, lastFrame);
        val = Math.max(val, 0);
        switch (this.sliderCaret) {
            case "in": {
                if (!clip.setStartFrameNumber(val, this.maxEndFrame)) break;
                int newStart = clip.getStartFrameNumber();
                SwingUtilities.invokeLater(() -> this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + newStart));
                if (!clip.isDefaultStartTime) {
                    double startTime = clip.getStartTime();
                    clip.setStartTime(startTime += (double)(newStart - start) * this.clipControl.getMeanFrameDuration());
                }
                this.clipControl.setStepNumber(0);
                if (clip.inspector != null && clip.inspector.isVisible()) {
                    clip.inspector.startField.setValue(newStart);
                    clip.inspector.t0Field.setValue(clip.getStartTime() / 1000.0);
                }
                this.updateValue();
                break;
            }
            case "out": {
                if (!clip.setEndFrameNumber(val)) break;
                this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + end);
                this.clipControl.setStepNumber(clip.getStepCount() - 1);
                if (clip.inspector == null || !clip.inspector.isVisible()) break;
                clip.inspector.endField.setValue(clip.getEndFrameNumber());
            }
        }
        e.consume();
    }

    protected void sliderReleasedAction(MouseEvent e) {
        if (this.disabled) {
            return;
        }
        if (this.sliderCaret != null) {
            this.vidPanel.setMessage(null);
            e.consume();
        }
        this.getVideoClip().setAdjusting(false);
    }

    private void updatePlayButtonsLater(boolean playing) {
        SwingUtilities.invokeLater(() -> this.updatePlayButtonsPosted(playing));
    }

    protected void updatePlayButtonsPosted(boolean playing) {
        if (this.getVideoClip() == null) {
            return;
        }
        int stepCount = this.getVideoClip().getStepCount();
        boolean canPlay = stepCount > 1;
        this.playButton.setEnabled(canPlay && (playing || this.getStepNumber() < stepCount - 1));
        this.stepButton.setEnabled(canPlay && (playing || this.getStepNumber() < stepCount - 1));
        this.backButton.setEnabled(canPlay && (playing || this.getStepNumber() > 0));
        this.playButton.setSelected(playing);
        if (playing) {
            this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Pause.ToolTip"));
            this.playButton.setPressedIcon(pauseIcon);
            this.playButton.setIcon(pauseIcon);
        } else {
            this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Play.ToolTip"));
            this.playButton.setPressedIcon(playIcon);
            this.playButton.setIcon(playIcon);
        }
    }

    private void updateLoopButton(boolean looping) {
        if (looping == this.loopButton.isSelected()) {
            return;
        }
        this.loopButton.setSelected(looping);
        if (looping) {
            this.loopButton.setPressedIcon(loopIcon);
            this.loopButton.setIcon(loopIcon);
        } else {
            this.loopButton.setPressedIcon(noloopIcon);
            this.loopButton.setIcon(noloopIcon);
        }
    }

    private void updateValueAndPlayButtons() {
        this.updateValue();
        this.updatePlayButtonsLater(this.clipControl.isPlaying());
    }

    private void updateValue() {
        String display;
        int frameNumber = this.clipControl.getFrameNumber();
        int startFrame = this.getVideoClip().getStartFrameNumber();
        int endFrame = this.getVideoClip().getEndFrameNumber();
        if (frameNumber < startFrame) {
            this.clipControl.setStepNumber(0);
        } else if (frameNumber > endFrame) {
            this.clipControl.setStepNumber(this.getVideoClip().getStepCount());
        }
        this.slider.setValue(this.clipControl.getFrameNumber());
        int stepNumber = this.clipControl.getStepNumber();
        if ("step".equals(this.readoutType)) {
            display = stepNumber < 10 ? "00" + stepNumber : (stepNumber < 100 ? "0" + stepNumber : "" + stepNumber);
        } else if ("frame".equals(this.readoutType)) {
            int n = this.clipControl.getFrameNumber();
            display = n < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n);
        } else {
            if (timeFormat instanceof DecimalFormat) {
                DecimalFormat format = (DecimalFormat)timeFormat;
                double dur = this.getMeanStepDuration();
                if (dur < 10.0) {
                    format.applyPattern("0.00E0");
                } else if (dur < 100.0) {
                    format.applyPattern("0.000");
                } else if (dur < 1000.0) {
                    format.applyPattern("0.00");
                } else if (dur < 10000.0) {
                    format.applyPattern("0.0");
                } else {
                    format.applyPattern("0.00E0");
                }
            }
            display = timeFormat.format(this.getTime() / 1000.0);
        }
        this.readout.setText(display);
        if (!this.ignoreRateSpinner) {
            this.rateSpinner.setValue(this.getRate());
        }
        this.stepSizeButton.setText("" + this.getVideoClip().getStepSize());
        this.stepSizeButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepSize.ToolTip"));
        this.rateSpinner.setToolTipText(MediaRes.getString("VideoPlayer.Spinner.Rate.ToolTip"));
        if (stepNumber == this.getVideoClip().getStepCount() - 1) {
            this.updatePlayButtonsLater(this.clipControl.isPlaying());
        }
        FontSizer.setFonts(this.toolbar);
    }

    private void updateSlider(final String option, final Object o) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                VideoPlayer.this.updateSliderAsync(option, o);
            }
        };
        if (o == null || o == "stepcount") {
            OSPRuntime.setTimeout("VP-updateSlider", 200, o != null, r);
        } else {
            r.run();
        }
    }

    /*
     * Exception decompiling
     */
    protected void updateSliderAsync(String option, Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl41 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl41 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void showGoToDialog() {
        if (goToDialog == null) {
            goToDialog = new GoToDialog(this);
            Container c = this.getParent();
            while (c != null) {
                if (c instanceof JSplitPane) {
                    Dimension dim = c.getSize();
                    Point p = c.getLocationOnScreen();
                    int x = (dim.width - VideoPlayer.goToDialog.getBounds().width) / 2;
                    int y = (dim.height - VideoPlayer.goToDialog.getBounds().height) / 2;
                    goToDialog.setLocation(p.x + x, p.y + y);
                    break;
                }
                c = c.getParent();
            }
        } else {
            goToDialog.setPlayer(this);
        }
        goToDialog.setVisible(true);
    }

    public void dispose() {
        this.clipControl.dispose();
        this.clipControl = null;
        if (this.toolbar != null) {
            this.toolbar.removeAll();
        }
        this.toolbar = null;
        this.vidPanel = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    protected static class GoToDialog
    extends JDialog {
        static HashMap<VideoPlayer, String[]> prev = new HashMap();
        VideoPlayer player;
        JButton okButton;
        JButton cancelButton;
        JLabel frameLabel;
        JLabel timeLabel;
        JLabel stepLabel;
        JTextField frameField;
        JTextField timeField;
        JTextField stepField;
        KeyAdapter keyListener;
        FocusAdapter focusListener;
        String prevFrame;
        String prevTime;
        String prevStep;
        Color error_red = new Color(255, 140, 160);

        public GoToDialog(VideoPlayer vidPlayer) {
            super(JOptionPane.getFrameForComponent(vidPlayer.vidPanel), true);
            this.setPlayer(vidPlayer);
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            this.okButton = new JButton(DisplayRes.getString("GUIUtils.Ok"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String input = stepField.getText();
                    if (input != null && !input.equals("")) {
                        try {
                            int n = Integer.parseInt(input);
                            player.clipControl.setStepNumber(n);
                            player.refresh();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.setVisible(false);
                }
            });
            this.cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JTextField field = (JTextField)e.getSource();
                    if (e.getKeyCode() == 10) {
                        okButton.doClick(0);
                    } else {
                        field.setBackground(Color.white);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextField field = (JTextField)e.getSource();
                    if (e.getKeyCode() != 10) {
                        this.setValues(field);
                    }
                }
            };
            this.focusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JTextField field = (JTextField)e.getSource();
                    field.setBackground(Color.white);
                }
            };
            this.frameField = new JTextField(6);
            this.frameField.addKeyListener(this.keyListener);
            this.frameField.addFocusListener(this.focusListener);
            this.timeField = new JTextField(6);
            this.timeField.addKeyListener(this.keyListener);
            this.timeField.addFocusListener(this.focusListener);
            this.stepField = new JTextField(6);
            this.stepField.addKeyListener(this.keyListener);
            this.stepField.addFocusListener(this.focusListener);
            this.frameLabel = new JLabel();
            this.timeLabel = new JLabel();
            this.stepLabel = new JLabel();
            Box box = Box.createVerticalBox();
            JPanel framePanel = new JPanel();
            framePanel.add(this.frameLabel);
            framePanel.add(this.frameField);
            box.add(framePanel);
            JPanel timePanel = new JPanel();
            timePanel.add(this.timeLabel);
            timePanel.add(this.timeField);
            box.add(timePanel);
            JPanel stepPanel = new JPanel();
            stepPanel.add(this.stepLabel);
            stepPanel.add(this.stepField);
            box.add(stepPanel);
            contentPane.add((Component)box, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            contentPane.add((Component)buttonPanel, "South");
            this.refreshGUI();
            this.pack();
        }

        public void refreshGUI() {
            this.setTitle(MediaRes.getString("VideoPlayer.GoToDialog.Title"));
            this.okButton.setText(DisplayRes.getString("GUIUtils.Ok"));
            this.cancelButton.setText(DisplayRes.getString("GUIUtils.Cancel"));
            this.frameLabel.setText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.MenuItem.Frame")) + ":");
            String t = this.player.vidPanel.getTimeUnit();
            this.timeLabel.setText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.MenuItem.Time")) + " (" + t + "):");
            this.stepLabel.setText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.MenuItem.Step")) + ":");
            ArrayList<JLabel> labels = new ArrayList<JLabel>();
            labels.add(this.frameLabel);
            labels.add(this.timeLabel);
            labels.add(this.stepLabel);
            Font font = this.frameLabel.getFont();
            int w = 0;
            for (JLabel next : labels) {
                Rectangle2D rect = font.getStringBounds(String.valueOf(next.getText()) + " ", OSPRuntime.frc);
                w = Math.max(w, (int)rect.getWidth() + 1);
            }
            Dimension labelSize = new Dimension(w, 20);
            for (JLabel next : labels) {
                next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
                next.setPreferredSize(labelSize);
                next.setHorizontalAlignment(11);
            }
        }

        public void setPlayer(VideoPlayer vidPlayer) {
            if (this.player != null && this.player != vidPlayer) {
                prev.put(this.player, new String[]{this.prevFrame, this.prevTime, this.prevStep});
                String[] former = prev.get(vidPlayer);
                if (former != null) {
                    this.prevFrame = former[0];
                    this.prevTime = former[1];
                    this.prevStep = former[2];
                    this.frameField.setText(this.prevFrame);
                    this.timeField.setText(this.prevTime);
                    this.stepField.setText(this.prevStep);
                }
            }
            this.player = vidPlayer;
        }

        private void setValues(JTextField inputField) {
            String input = inputField.getText();
            if ("".equals(input)) {
                this.prevFrame = "";
                this.prevTime = "";
                this.prevStep = "";
            } else {
                VideoClip clip = this.player.getVideoClip();
                if (inputField == this.frameField) {
                    this.prevFrame = input;
                    try {
                        int frameNum;
                        int entered = frameNum = Integer.parseInt(input);
                        frameNum = Math.max(clip.getFirstFrameNumber(), frameNum);
                        frameNum = Math.min(clip.getEndFrameNumber(), frameNum);
                        int stepNum = clip.frameToStep(frameNum);
                        frameNum = clip.stepToFrame(stepNum);
                        double t = this.player.getStepTime(stepNum) / 1000.0;
                        this.prevTime = timeFormat.format(t);
                        this.prevStep = String.valueOf(stepNum);
                        if (frameNum != entered) {
                            this.frameField.setBackground(this.error_red);
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.prevTime = "";
                        this.prevStep = "";
                        this.frameField.setBackground(this.error_red);
                    }
                } else if (inputField == this.timeField) {
                    this.prevTime = input;
                    try {
                        input = input.replaceAll(",", ".");
                        double t = Double.valueOf(input) * 1000.0;
                        double dt = this.player.getMeanStepDuration();
                        int n = (int)((t - clip.getStartTime()) / dt);
                        int stepNum = Math.max(0, n);
                        stepNum = Math.min(stepNum, clip.getStepCount() - 1);
                        int frameNum = clip.stepToFrame(stepNum);
                        double tmin = this.player.getFrameTime(clip.getFirstFrameNumber());
                        double tmax = this.player.getFrameTime(clip.getLastFrameNumber());
                        if (t < tmin || t > tmax) {
                            this.timeField.setBackground(this.error_red);
                        }
                        this.prevFrame = String.valueOf(frameNum);
                        this.prevStep = String.valueOf(stepNum);
                    }
                    catch (NumberFormatException ex) {
                        this.prevFrame = "";
                        this.prevStep = "";
                        this.timeField.setBackground(this.error_red);
                    }
                } else {
                    try {
                        int stepNum = Integer.parseInt(input);
                        stepNum = Math.max(0, stepNum);
                        stepNum = Math.min(clip.getStepCount() - 1, stepNum);
                        int frameNum = clip.stepToFrame(stepNum);
                        double t = this.player.getStepTime(stepNum) / 1000.0;
                        this.prevFrame = String.valueOf(frameNum);
                        this.prevTime = timeFormat.format(t);
                        this.prevStep = String.valueOf(stepNum);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.frameField.setText(this.prevFrame);
            this.timeField.setText(this.prevTime);
            this.stepField.setText(this.prevStep);
        }

        @Override
        public void setVisible(boolean vis) {
            if (vis) {
                this.prevFrame = "";
                this.prevTime = "";
                this.prevStep = "";
                this.frameField.setText(this.prevFrame);
                this.timeField.setText(this.prevTime);
                this.stepField.setText(this.prevStep);
                this.frameField.setBackground(Color.white);
                this.timeField.setBackground(Color.white);
                this.stepField.setBackground(Color.white);
                FontSizer.setFonts(this, FontSizer.getLevel());
                this.refreshGUI();
                this.pack();
            }
            super.setVisible(vis);
        }
    }
}

