/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;

public interface VideoType {
    public static final String TYPE_GIF = "Gif";
    public static final String TYPE_IMAGE = "Image";

    default public Video getVideo(String path) {
        return this.getVideo(path, null, null);
    }

    default public XMLControl getVideoControlForExportOnly(String videoTarget, String vidDir, XMLControl clipXMLControl) {
        Video video2 = this.getVideo(XML.getName(videoTarget), vidDir, null);
        clipXMLControl.setValue("video", video2);
        return clipXMLControl.getChildControl("video");
    }

    public Video getVideo(String var1, String var2, XMLControl var3);

    public boolean isType(Video var1);

    public VideoRecorder getRecorder();

    public boolean canRecord();

    public String getDescription();

    public String getDefaultExtension();

    public VideoFileFilter[] getFileFilters();

    public VideoFileFilter getDefaultFileFilter();

    public String getTypeName();

    default public boolean accepts(File file) {
        VideoFileFilter[] filters = this.getFileFilters();
        int i = filters.length;
        while (--i >= 0) {
            if (!filters[i].accept(file)) continue;
            return true;
        }
        return false;
    }

    default public String _toString() {
        String s = "";
        VideoFileFilter[] videoFileFilterArray = this.getFileFilters();
        int n = videoFileFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            VideoFileFilter f = videoFileFilterArray[n2];
            s = String.valueOf(s) + " " + f;
            ++n2;
        }
        return "[" + this.getTypeName() + " " + s + "]";
    }
}

