/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifDecoder;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class GifVideo
extends VideoAdapter {
    protected GifDecoder decoder;
    private Timer timer;
    private HashSet<DrawingPanel> panels = new HashSet();

    public GifVideo(String gifName) throws IOException {
        this.load(gifName);
        this.createTimer();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        this.panels.add(panel);
        super.draw(panel, g);
    }

    @Override
    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        if (!this.timer.isRunning()) {
            if (this.getFrameNumber() >= this.getEndFrameNumber()) {
                this.setFrameNumber(this.getStartFrameNumber());
            }
            this.timer.restart();
            this.firePropertyChange("playing", null, Boolean.TRUE);
        }
    }

    @Override
    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.firePropertyChange("playing", null, Boolean.FALSE);
        }
    }

    @Override
    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        n = this.getFrameNumber();
        int index = Math.min(n, this.decoder.getFrameCount() - 1);
        this.rawImage = this.decoder.getFrame(index);
        this.invalidateVideoAndFilter();
        this.notifyFrame(n, false);
        for (DrawingPanel panel : this.panels) {
            panel.repaint();
        }
    }

    @Override
    public double getEndTime() {
        int n = this.getEndFrameNumber();
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    @Override
    public double getFrameCountDurationMS() {
        int n = this.getFrameCount() - 1;
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    protected void load(String gifName) throws IOException {
        this.decoder = new GifDecoder();
        int status = this.decoder.read(gifName);
        if (status == 2) {
            throw new IOException("Gif " + gifName + " not found");
        }
        if (status == 1) {
            throw new IOException("File format error");
        }
        this.setProperty("name", gifName);
        if (gifName.indexOf(":") == -1) {
            this.setProperty("path", XML.forwardSlash(gifName));
            Resource res = ResourceLoader.getResource(gifName);
            if (res != null) {
                this.setProperty("absolutePath", res.getAbsolutePath());
            }
        } else {
            this.setProperty("path", XML.getRelativePath(gifName));
            this.setProperty("absolutePath", gifName);
        }
        this.setFrameCount(this.decoder.getFrameCount());
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.setStartTimes();
        this.setImage(this.decoder.getFrame(0));
    }

    @Override
    protected void setStartTimes() {
        this.startTimesMS = new double[this.frameCount];
        this.startTimesMS[0] = 0.0;
        int i = 1;
        while (i < this.startTimesMS.length) {
            this.startTimesMS[i] = this.startTimesMS[i - 1] + (double)this.decoder.getDelay(i - 1);
            ++i;
        }
    }

    private void setImage(BufferedImage image) {
        this.rawImage = image;
        this.size.width = image.getWidth();
        this.size.height = image.getHeight();
        this.refreshBufferedImage();
        this.coords = new ImageCoordSystem(this.frameCount, this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private void createTimer() {
        int delay = this.decoder.getDelay(0);
        this.timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GifVideo.this.getFrameNumber() < GifVideo.this.getEndFrameNumber()) {
                    int delay = GifVideo.this.decoder.getDelay(GifVideo.this.getFrameNumber() + 1);
                    GifVideo.this.timer.setDelay((int)((double)delay / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getFrameNumber() + 1);
                } else if (GifVideo.this.looping) {
                    int delay = GifVideo.this.decoder.getDelay(GifVideo.this.getStartFrameNumber());
                    GifVideo.this.timer.setDelay((int)((double)delay / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getStartFrameNumber());
                } else {
                    GifVideo.this.stop();
                }
            }
        });
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    public String getTypeName() {
        return "Gif";
    }

    static class Loader
    extends VideoAdapter.Loader {
        Loader() {
        }

        @Override
        protected VideoAdapter createVideo(String path) throws IOException {
            GifVideo video2 = new GifVideo(path);
            VideoType gifType = VideoIO.getVideoType("Gif", null);
            if (gifType != null) {
                video2.setProperty("video_type", gifType);
            }
            return video2;
        }
    }
}

