/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.io.IOException;
import java.io.OutputStream;
import org.opensourcephysics.media.gif.BitUtils;

class ScreenDescriptor {
    short localScreenWidth_;
    short localScreenHeight_;
    private byte byte_;
    byte backgroundColorIndex_;
    byte pixelAspectRatio_;

    ScreenDescriptor(short width, short height, int numColors) {
        this.localScreenWidth_ = width;
        this.localScreenHeight_ = height;
        this.SetGlobalColorTableSize((byte)(BitUtils.BitsNeeded(numColors) - 1));
        this.SetGlobalColorTableFlag((byte)1);
        this.SetSortFlag((byte)0);
        this.SetColorResolution((byte)7);
        this.backgroundColorIndex_ = 0;
        this.pixelAspectRatio_ = 0;
    }

    void Write(OutputStream output) throws IOException {
        BitUtils.WriteWord(output, this.localScreenWidth_);
        BitUtils.WriteWord(output, this.localScreenHeight_);
        output.write(this.byte_);
        output.write(this.backgroundColorIndex_);
        output.write(this.pixelAspectRatio_);
    }

    void SetGlobalColorTableSize(byte num) {
        this.byte_ = (byte)(this.byte_ | num & 7);
    }

    void SetSortFlag(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 1) << 3);
    }

    void SetColorResolution(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 7) << 4);
    }

    void SetGlobalColorTableFlag(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 1) << 7);
    }
}

