/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.mov;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javajs.async.SwingJSUtils;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.AsyncVideoI;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.mov.MovieVideo;
import org.opensourcephysics.tools.ResourceLoader;
import swingjs.api.js.DOMNode;
import swingjs.api.js.HTML5Video;
import swingjs.api.js.JSFunction;

public class JSMovieVideo
extends MovieVideo
implements AsyncVideoI {
    private static final int FORCE_TO_START = -99;
    boolean debugHTMLVideo = false;
    static boolean useMediaInfo = true;
    State state;
    public String err;
    private int frame;
    private HTML5Video jsvideo;
    private JDialog videoDialog;
    protected int progress;
    protected Map<String, Object> mediaInfo;

    @Override
    public Object getProperty(String name) {
        return super.getProperty(name);
    }

    JSMovieVideo(String fileName, String basePath, XMLControl control) throws IOException {
        super(fileName, basePath, control);
        OSPLog.finest("JSMovieVideo loading " + this.path + " local?: " + this.isLocal);
        if (!VideoIO.checkMP4(this.path, null, null)) {
            this.frameNumber = Integer.MIN_VALUE;
            return;
        }
        if (this.isExport) {
            return;
        }
        this.firePropertyChange("progress", fileName, 0);
        if (this.state == null) {
            this.state = new State(this, this.allowControlData ? control : null);
        }
        this.state.load(this.path);
    }

    @Override
    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        int n = this.getFrameNumber() + 1;
        this.playing = true;
        this.firePropertyChange("playing", null, Boolean.TRUE);
        this.setFrameNumber(n);
    }

    @Override
    public void stop() {
        this.playing = false;
        this.firePropertyChange("playing", null, Boolean.FALSE);
    }

    @Override
    public BufferedImage getImage() {
        return this.rawImage == null ? null : super.getImage();
    }

    @Override
    public void setFrameNumber(int n) {
        if (n < 0) {
            this.frameNumber = n;
            n = 0;
        }
        super.setFrameNumber(n);
        this.state.getImage(this.getFrameNumber());
    }

    public void setFrameNumberContinued(int n, double t) {
        BufferedImage bi = HTML5Video.getImage(this.jsvideo, 1);
        if (bi == null) {
            return;
        }
        this.rawImage = bi;
        this.invalidateVideoAndFilter();
        this.notifyFrame(n, false);
        this.firePropertyChange("asyncImageReady", null, n);
        if (this.isPlaying()) {
            SwingUtilities.invokeLater(() -> this.continuePlaying());
        }
    }

    @Override
    public double getFrameCountDurationMS() {
        return this.jsvideo == null ? -1.0 : HTML5Video.getDuration(this.jsvideo) * 1000.0;
    }

    @Override
    public void setRate(double rate) {
        super.setRate(rate);
        if (this.isPlaying()) {
            this.setFrameNumber(this.getFrameNumber());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        DOMNode.dispose(this.jsvideo);
        this.videoDialog.dispose();
    }

    protected void continuePlaying() {
        int n = this.getFrameNumber();
        if (n < this.getEndFrameNumber()) {
            this.setFrameNumber(++n);
        } else if (this.looping) {
            this.setFrameNumber(this.getStartFrameNumber());
        } else {
            this.stop();
        }
    }

    @Override
    public String getTypeName() {
        return "JS";
    }

    @Override
    protected void setFrameCount(int n) {
        super.setFrameCount(n);
        this.coords = new ImageCoordSystem(this.frameCount, this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    @Override
    protected void finalizeLoading() {
        this.videoDialog.setVisible(false);
        if (this.startTimesMS == null) {
            if (this.frameTimes.size() == 0) {
                this.firePropertyChange("progress", this.fileName, this.frame);
                this.dispose();
                this.err = "no frames";
            }
            this.setFrameCount(this.frameTimes.size());
        }
        OSPLog.debug("JSMovieVideo " + this.size + "\n duration:" + this.rawDuration + " act. frameCount:" + this.frameCount);
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.setStartTimes();
        this.firePropertyChange("progress", this.fileName, this.frame);
        this.frameNumber = -1;
        this.firePropertyChange("asyncVideoHaveFrames", null, this);
        this.firePropertyChange("asyncVideoReady", this.fileName, this);
        this.setFrameNumber(-99);
    }

    public void cantRead() {
        JOptionPane.showMessageDialog(null, "Video file format or compression method could not be read.");
        VideoIO.setCanceled(true);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public static File createThumbnailFile(Dimension defaultThumbnailDimension, String sourcePath, String thumbPath) {
        return null;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getLoadedFrameCount() {
        return this.frame;
    }

    @Override
    protected boolean seekMS(double timeMS) {
        HTML5Video.setCurrentTime(this.jsvideo, timeMS / 1000.0);
        return true;
    }

    @Override
    protected BufferedImage getImageForMSTimePoint(double timeMS) {
        this.seekMS(timeMS);
        BufferedImage bi = HTML5Video.getImage(this.jsvideo, 1);
        if (bi != null) {
            this.rawImage = bi;
        }
        return bi;
    }

    @Override
    protected String getPlatform() {
        String engine = useMediaInfo ? "MediaInfo - " : "";
        return String.valueOf(engine) + "?";
    }

    public static class Loader
    extends MovieVideo.Loader {
        @Override
        protected JSMovieVideo createVideo(XMLControl control, String path) throws IOException {
            JSMovieVideo video2 = new JSMovieVideo(path, null, control);
            if (video2.getFrameNumber() < 0) {
                return null;
            }
            this.setVideo(path, video2, "JS");
            return video2;
        }
    }

    private static class State
    implements SwingJSUtils.StateMachine {
        static final int STATE_ERROR = -99;
        static final int STATE_IDLE = -1;
        static final int STATE_SET_FROM_CONTROL = 30;
        static final int STATE_PLAY_WITH_CALLBACK = 40;
        static final int STATE_PLAY_ALL_INIT = 41;
        static final int STATE_PLAY_ALL_DONE = 42;
        static final int STATE_FIND_FRAMES_INIT = 0;
        static final int STATE_FIND_FRAMES_LOOP = 1;
        static final int STATE_FIND_FRAMES_WAIT = 2;
        static final int STATE_FIND_FRAMES_READY = 3;
        static final int STATE_GET_MEDIAINFO_INIT = 4;
        static final int STATE_GET_MEDIAINFO_DONE = 5;
        static final int STATE_FIND_FRAMES_DONE = 9;
        static final int STATE_LOAD_VIDEO_INIT = 10;
        static final int STATE_LOAD_VIDEO_READY = 12;
        static final int STATE_GET_IMAGE_INIT = 20;
        static final int STATE_GET_IMAGE_READY = 22;
        private SwingJSUtils.StateHelper helper;
        private double t;
        private double offset = 0.0;
        private double lastT = -1.0;
        private ActionListener onevent = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (helper.getState()) {
                    case 2: {
                        helper.setState(3);
                        break;
                    }
                    case 41: {
                        helper.setState(42);
                    }
                }
                this.next(Integer.MIN_VALUE);
            }
        };
        private Object[] readyListener;
        private int thisFrame = -1;
        private Object[] debugListeners;
        private boolean canSeek = true;
        private String playThroughOrSeeked = "canplaythrough";
        private XMLControl control;
        private JSMovieVideo v;

        State(JSMovieVideo v, XMLControl control) {
            this.helper = new SwingJSUtils.StateHelper(this);
            this.control = control;
            this.v = v;
        }

        public void load(String path) {
            this.helper.next(10);
        }

        protected void next(int stateNext) {
            this.helper.delayedState(10, stateNext);
        }

        public void getImage(int n) {
            if (this.thisFrame == n) {
                return;
            }
            this.thisFrame = n;
            this.t = this.v.getFrameTime(n) / 1000.0;
            this.next(20);
        }

        private void dispose() {
            this.removeReadyListener();
        }

        private void seekToNextFrame() {
            try {
                Runnable next = new Runnable(){

                    @Override
                    public void run() {
                        this.next(3);
                    }
                };
                JSFunction f = null;
                this.v.jsvideo.seekToNextFrame().then(f, null);
            }
            catch (Throwable e) {
                this.v.err = "JSMovieVideo cannot seek to next Frame";
                e.printStackTrace();
            }
        }

        private void setReadyListener(String event) {
            if (this.readyListener != null) {
                return;
            }
            this.readyListener = HTML5Video.addActionListener(this.v.jsvideo, this.onevent, event);
            if (this.v.debugHTMLVideo) {
                this.debugListeners = HTML5Video.addActionListener(this.v.jsvideo, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object[] o = (Object[])e.getSource();
                        Object jsEvent = o[1];
                        Object target = null;
                        System.out.println("JSMovieVideo.debugging.actionPerformed " + e.getActionCommand() + " " + target);
                    }
                }, new String[0]);
                int i = 0;
                while (i < this.debugListeners.length) {
                    i += 2;
                }
            }
        }

        private void removeReadyListener() {
            HTML5Video.removeActionListener(this.v.jsvideo, this.readyListener);
            this.readyListener = null;
            if (this.v.debugHTMLVideo) {
                HTML5Video.removeActionListener(this.v.jsvideo, this.debugListeners);
                this.debugListeners = null;
            }
        }

        @Override
        public boolean stateLoop() {
            while (this.helper.isAlive()) {
                switch (this.v.err == null ? this.helper.getState() : -99) {
                    case -1: {
                        return false;
                    }
                    case 10: {
                        this.v.videoDialog = HTML5Video.createDialog(null, this.v.url, 500, false, new Function<HTML5Video, Void>(){

                            @Override
                            public Void apply(HTML5Video video2) {
                                v.jsvideo = video2;
                                canSeek = DOMNode.getAttr(v.jsvideo, "seekToNextFrame") != null;
                                if (!canSeek) {
                                    playThroughOrSeeked = "seeked";
                                }
                                this.next(12);
                                return null;
                            }
                        });
                        return true;
                    }
                    case 12: {
                        this.v.videoDialog.setVisible(true);
                        Dimension d = HTML5Video.getSize(this.v.jsvideo);
                        ((JSMovieVideo)this.v).size.width = d.width;
                        ((JSMovieVideo)this.v).size.height = d.height;
                        this.v.rawDuration = HTML5Video.getDuration(this.v.jsvideo);
                        this.v.frameTimes = new ArrayList();
                        if (((JSMovieVideo)this.v).size.width == 0) {
                            this.v.cantRead();
                            this.helper.next(3);
                        } else {
                            if (this.control != null) {
                                this.control = this.v.setFromControl(this.control);
                            }
                            this.helper.next(this.control != null ? 30 : (useMediaInfo ? 4 : (this.canSeek ? 0 : 40)));
                            this.control = null;
                        }
                        return true;
                    }
                    case 4: {
                        this.v.videoDialog.setVisible(false);
                        final Consumer<String> failed = new Consumer<String>(){

                            @Override
                            public void accept(String err) {
                                System.err.println("JSMovieVideo MediaInfo Error: " + err);
                                control = null;
                                helper.next(12);
                                this.stateLoop();
                            }
                        };
                        final long t1 = System.currentTimeMillis();
                        byte[] bytes = null;
                        try {
                            bytes = ResourceLoader.getURLBytes(this.v.url.toString());
                            if (bytes == null) {
                                bytes = ResourceLoader.getLimitedStreamBytes(this.v.url.openStream(), -1L, null, true);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (bytes == null) {
                            failed.accept("no byte[] for " + this.v.url);
                        } else {
                            final long t2 = System.currentTimeMillis();
                            final byte[] b = bytes;
                            OSPRuntime.jsutil.getMediaInfoAsync(bytes, "Video", "/core/ES6/mediainfo.js", (Consumer)new Consumer<Map<String, Object>>(){

                                @Override
                                public void accept(Map<String, Object> info) {
                                    String err = v.setFromMediaTrackInfo(info);
                                    if (err == null) {
                                        System.out.println("JSMovieVideo reading " + b.length + " bytes " + (t2 - t1) + " ms; MediaInfo analysis " + (System.currentTimeMillis() - t2) + " ms");
                                        for (Map.Entry<String, Object> e : info.entrySet()) {
                                            System.out.println(String.valueOf(e.getKey()) + "=" + e.getValue());
                                        }
                                        helper.setState(5);
                                        this.stateLoop();
                                    } else {
                                        failed.accept("MediaInfo not usable: " + err);
                                    }
                                }
                            }, (Consumer)failed);
                        }
                        return true;
                    }
                    case 40: {
                        HTML5Video.requestVideoFrameCallback(this.v.jsvideo, new Consumer<Object>(){

                            @Override
                            public void accept(Object metadata) {
                                this.processVideoFrameCallback(metadata);
                            }
                        });
                        this.helper.next(41);
                        break;
                    }
                    case 41: {
                        this.setReadyListener("ended");
                        HTML5Video.startVideo(this.v.jsvideo);
                        return false;
                    }
                    case 42: {
                        this.removeReadyListener();
                        this.helper.setState(0);
                        break;
                    }
                    case 0: {
                        this.v.err = null;
                        if (this.v.rawDuration == 0.0) {
                            this.v.rawDuration = HTML5Video.getDuration(this.v.jsvideo);
                        }
                        this.t = 0.0;
                        this.lastT = 0.0;
                        if (this.canSeek) {
                            this.v.frameTimes.add(this.t);
                            this.v.seekMS(0.0);
                            this.setReadyListener(this.playThroughOrSeeked);
                            this.helper.setState(1);
                            break;
                        }
                        HTML5Video.cancelVideoFrameCallback(this.v.jsvideo);
                        this.helper.setState(9);
                        break;
                    }
                    case 1: {
                        if (this.t >= this.v.rawDuration) {
                            this.helper.setState(9);
                            break;
                        }
                        this.helper.setState(2);
                        this.seekToNextFrame();
                        return false;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        if (VideoIO.isCanceled()) {
                            this.v.firePropertyChange("progress", this.v.fileName, null);
                            this.dispose();
                            this.v.err = "Canceled by user";
                            this.v.progress = -999;
                            return false;
                        }
                        this.t = HTML5Video.getCurrentTime(this.v.jsvideo);
                        if (this.t > this.lastT && this.t < this.v.rawDuration) {
                            this.lastT = this.t;
                            this.v.frameTimes.add(this.t);
                            String string = this.v.fileName;
                            JSMovieVideo jSMovieVideo = this.v;
                            int n = jSMovieVideo.frame;
                            jSMovieVideo.frame = n + 1;
                            this.v.firePropertyChange("progress", string, n);
                            this.v.progress = VideoIO.progressForFraction(this.v.frame, this.v.frameCount);
                        }
                        this.helper.setState(1);
                        break;
                    }
                    case 5: 
                    case 30: {
                        this.offset = 0.5 / (double)this.v.nominalFrameRate;
                    }
                    case 9: {
                        this.helper.setState(-1);
                        this.v.finalizeLoading();
                        this.v.frameTimes = null;
                        this.thisFrame = -1;
                        this.v.progress = 80;
                        break;
                    }
                    case 20: {
                        this.helper.setState(22);
                        this.setReadyListener(this.playThroughOrSeeked);
                        this.v.seekMS((this.offset + this.t) * 1000.0);
                        return true;
                    }
                    case 22: {
                        this.v.setFrameNumberContinued(this.thisFrame, this.t);
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }

        protected void processVideoFrameCallback(Object metadata) {
            double t = 0.0;
            this.v.frameTimes.add(t);
            JSMovieVideo jSMovieVideo = this.v;
            jSMovieVideo.frame = jSMovieVideo.frame + 1;
            String string = this.v.fileName;
            JSMovieVideo jSMovieVideo2 = this.v;
            int n = jSMovieVideo2.frame;
            jSMovieVideo2.frame = n + 1;
            this.v.firePropertyChange("progress", string, n);
            this.v.progress = VideoIO.progressForFraction(this.v.frame, this.v.frameCount);
        }
    }
}

