/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.mov;

import java.io.File;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.mov.JSMovieVideo;
import org.opensourcephysics.media.mov.MovieVideoType;
import org.opensourcephysics.tools.ResourceLoader;

public class JSMovieVideoType
extends MovieVideoType {
    static boolean registered;

    static {
        JSMovieVideoType.register();
    }

    public static void register() {
        String[] JS_VIDEO_EXTENSIONS;
        String[] stringArray = JS_VIDEO_EXTENSIONS = new String[]{"mov", "mp4", "ogg"};
        int n = JS_VIDEO_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            VideoFileFilter filter = new VideoFileFilter(ext, new String[]{ext});
            VideoIO.addVideoType(new JSMovieVideoType(filter));
            ResourceLoader.addExtractExtension(ext);
            ++n2;
        }
        registered = true;
    }

    public JSMovieVideoType() {
    }

    public JSMovieVideoType(VideoFileFilter filter) {
        super(filter);
        this.setRecordable(false);
    }

    @Override
    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("JSVideoType.Description");
    }

    @Override
    public boolean isType(Video video2) {
        if (video2.getClass() != JSMovieVideo.class) {
            return false;
        }
        if (this.singleTypeFilter == null) {
            return true;
        }
        String name = (String)video2.getProperty("name");
        return this.singleTypeFilter.accept(new File(name));
    }

    @Override
    public Video getVideo(String name, String basePath, XMLControl control) {
        JSMovieVideo video2 = null;
        try {
            video2 = new JSMovieVideo(name, basePath, control);
            if (video2.getFrameNumber() == Integer.MIN_VALUE) {
                video2 = null;
            } else {
                video2.setProperty("video_type", this);
            }
        }
        catch (Exception e) {
            if (name != null) {
                OSPLog.fine(String.valueOf(this.getDescription()) + ": " + e.getMessage());
                video2 = null;
            }
            e.printStackTrace();
        }
        return video2;
    }

    @Override
    public VideoRecorder getRecorder() {
        OSPLog.warning("JSMovieVideoType unable to record");
        return null;
    }

    @Override
    public String getTypeName() {
        return "JS";
    }
}

