/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.mov;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.mov.JSMovieVideo;
import org.opensourcephysics.media.mov.JSMovieVideoType;
import org.opensourcephysics.tools.ResourceLoader;

public class MovieFactory {
    public static final String ENGINE_NONE = "none";
    public static final String ENGINE_JS = "JS";
    public static final String ENGINE_XUGGLE = "Xuggle";
    private static String xuggleClassPath;
    private static String xugglePropertiesPath;
    private static String movieEngineName;
    public static boolean hadXuggleError;
    public static boolean xuggleIsPresent;
    public static boolean xuggleNeeds32bitVM;
    private static PropertyChangeListener[] errorListener;

    static {
        block7: {
            xuggleClassPath = "org.opensourcephysics.media.xuggle.";
            xugglePropertiesPath = "org/opensourcephysics/resources/xuggle/xuggle.properties";
            movieEngineName = ENGINE_NONE;
            hadXuggleError = false;
            xuggleIsPresent = false;
            xuggleNeeds32bitVM = false;
            int code = -1;
            try {
                if (OSPRuntime.isJS) {
                    if (JSMovieVideoType.registered) {
                        movieEngineName = ENGINE_JS;
                        xuggleIsPresent = false;
                    }
                } else {
                    Class<?> type = Class.forName(String.valueOf(xuggleClassPath) + "DiagnosticsForXuggle");
                    Method m = type.getMethod("getStatusCode", null);
                    code = (Integer)m.invoke(type, null);
                    Class.forName(String.valueOf(xuggleClassPath) + "XuggleVideo");
                    xuggleIsPresent = true;
                    movieEngineName = ENGINE_XUGGLE;
                }
            }
            catch (Throwable e) {
                if (OSPRuntime.isJS) break block7;
                if (code == 7) {
                    xuggleNeeds32bitVM = true;
                    OSPLog.config("Xuggle installed but must be run in a 32-bit Java VM on Windows.");
                } else {
                    OSPLog.config("Xuggle not installed? " + xuggleClassPath + "XuggleVideo failed");
                }
                String jarPath = OSPRuntime.getLaunchJarPath();
                xuggleIsPresent = jarPath != null && ResourceLoader.getResource(String.valueOf(jarPath) + "!/" + xugglePropertiesPath) != null;
            }
        }
        errorListener = new PropertyChangeListener[]{new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("xuggle_error")) {
                    hadXuggleError = true;
                    OSPLog.removePropertyChangeListener(errorListener[0]);
                    errorListener[0] = null;
                }
            }
        }};
        OSPLog.addPropertyChangeListener(errorListener[0]);
    }

    public static File createThumbnailFile(Dimension defaultThumbnailDimension, String sourcePath, String thumbPath) {
        if (MovieFactory.hasVideoEngine()) {
            if (OSPRuntime.isJS) {
                return JSMovieVideo.createThumbnailFile(defaultThumbnailDimension, sourcePath, thumbPath);
            }
            String className = String.valueOf(xuggleClassPath) + "XuggleThumbnailTool";
            Class[] types = new Class[]{Dimension.class, String.class, String.class};
            try {
                Class<?> xuggleClass = Class.forName(className);
                Method method = xuggleClass.getMethod("createThumbnailFile", types);
                return (File)method.invoke(null, defaultThumbnailDimension, sourcePath, thumbPath);
            }
            catch (Exception ex) {
                OSPLog.fine("failed to create thumbnail: " + ex.toString());
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getMovieEngineName(boolean forDialog) {
        return forDialog && movieEngineName == ENGINE_NONE ? MediaRes.getString("VideoIO.Engine.None") : movieEngineName;
    }

    public static boolean hasVideoEngine() {
        return movieEngineName != ENGINE_NONE;
    }

    public static void startMovieThumbnailTool() {
        if (OSPRuntime.isJS) {
            return;
        }
        if (MovieFactory.hasVideoEngine()) {
            try {
                Class.forName(String.valueOf(xuggleClassPath) + "XuggleThumbnailTool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static String[] getUpdatedVideoEngines() {
        if (!OSPRuntime.isJS && movieEngineName.equals(ENGINE_XUGGLE)) {
            try {
                Class<?> clas;
                Method method;
                Object result;
                String codebase = OSPRuntime.getLaunchJarDirectory();
                if (codebase != null && ((Boolean)(result = (method = (clas = Class.forName("org.opensourcephysics.media.xuggle.DiagnosticsForXuggle")).getMethod("copyXuggleJarsTo", File.class)).invoke(null, new File(codebase)))).booleanValue()) {
                    return new String[]{ENGINE_XUGGLE};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void showAbout(String engineName, String requester) {
        if (engineName == ENGINE_XUGGLE) {
            try {
                Class<?> clas = Class.forName("org.opensourcephysics.media.xuggle.DiagnosticsForXuggle");
                Method method = clas.getMethod("aboutXuggle", String.class);
                method.invoke(null, requester);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

