/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.mov;

import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class MovieVideo
extends VideoAdapter {
    public static final String PROPERTY_VIDEO_PROGRESS = "progress";
    public static final String PROPERTY_VIDEO_STALLED = "stalled";
    protected static final String PLATFORM_JAVA = "Java";
    protected static final double TIME_SLOP_MS = 0.1;
    protected String fileName;
    protected URL url;
    protected ArrayList<Double> frameTimes;
    protected boolean allowControlData;
    protected double rawDuration;
    protected int nominalFrameRate;
    private String sourcePlatform;
    protected String path;
    protected boolean isLocal;
    protected boolean isExport;
    protected int rawFrameCount;
    protected XMLControl control;
    protected boolean isVariableFrameRate;
    protected double frameRateMinimum;
    protected double frameRateMaximum;

    protected abstract String getPlatform();

    protected abstract boolean seekMS(double var1);

    protected abstract void finalizeLoading() throws IOException;

    protected abstract BufferedImage getImageForMSTimePoint(double var1);

    public MovieVideo(String fileName, String basePath, XMLControl control) throws IOException {
        Resource res;
        this.fileName = fileName;
        boolean isJava = this.getPlatform() == PLATFORM_JAVA;
        this.allowControlData = true;
        this.addFramePropertyListeners();
        this.isExport = control != null && !"video".equals(control.getPropertyName());
        this.baseDir = basePath;
        this.path = this.getAbsolutePath(fileName);
        Resource resource = isJava ? ResourceLoader.getResource(fileName) : (res = ResourceLoader.isHTTP(this.path) ? new Resource(new URL(this.path)) : new Resource(new File(this.path)));
        if (res == null) {
            throw new IOException("unable to create resource for " + fileName);
        }
        this.url = res.getURL();
        this.isLocal = this.url.getProtocol().toLowerCase().indexOf("file") >= 0;
        this.path = this.isLocal ? res.getAbsolutePath() : this.url.toExternalForm();
        this.setProperty("name", XML.getName(fileName));
        this.setProperty("absolutePath", res.getAbsolutePath());
        if (fileName.indexOf(":") < 0) {
            this.setProperty("path", XML.forwardSlash(fileName));
        } else if (!isJava) {
            this.setProperty("path", XML.getRelativePath(fileName));
        } else if (fileName.contains("!/")) {
            String dir = fileName.substring(0, fileName.indexOf("!/"));
            dir = XML.getDirectoryPath(dir);
            this.setProperty("path", XML.getPathRelativeTo(fileName, dir));
        } else {
            this.setProperty("path", res.getAbsolutePath());
        }
    }

    @Override
    protected void setStartTimes() {
        if (this.startTimesMS == null) {
            this.startTimesMS = new double[this.frameCount];
            this.startTimesMS[0] = 0.0;
            int i = 1;
            while (i < this.startTimesMS.length) {
                this.startTimesMS[i] = this.frameTimes.get(i) * 1000.0;
                ++i;
            }
        }
    }

    private void addFramePropertyListeners() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        int n = frames.length;
        while (i < n) {
            if (frames[i].getName().equals("Tracker")) {
                this.addPropertyChangeListener(PROPERTY_VIDEO_PROGRESS, (PropertyChangeListener)((Object)frames[i]));
                this.addPropertyChangeListener(PROPERTY_VIDEO_STALLED, (PropertyChangeListener)((Object)frames[i]));
                break;
            }
            ++i;
        }
    }

    protected int getFrameNumberBefore(double time) {
        time += 0.1;
        int i = 0;
        while (i < this.startTimesMS.length) {
            if (time < this.startTimesMS[i]) {
                return i - 1;
            }
            ++i;
        }
        return time < this.rawDuration * 1000.0 ? this.startTimesMS.length - 1 : -1;
    }

    protected XMLControl setFromControl(XMLControl control) {
        int count = control.getInt("frame_count");
        if (count == Integer.MIN_VALUE) {
            return null;
        }
        String platform = control.getString("platform");
        if (!OSPRuntime.isJS && platform.equals(PLATFORM_JAVA)) {
            return null;
        }
        this.sourcePlatform = platform == null ? "unknown" : platform;
        this.frameCount = count;
        this.startTimesMS = (double[])control.getObject("start_times");
        this.rawDuration = control.getDouble("duration");
        this.nominalFrameRate = control.getInt("frame_rate");
        return control;
    }

    protected String setFromMediaTrackInfo(Map<String, Object> info) {
        String key = null;
        try {
            key = "Duration";
            double duration = Double.parseDouble((String)info.get("Duration"));
            key = "FrameRate";
            double precisionFrameRate = Double.parseDouble((String)info.get("FrameRate"));
            key = "FrameRate_Mode";
            String frameRateMode = (String)info.get("FrameRate_Mode");
            if ("VFR".equals(frameRateMode)) {
                this.isVariableFrameRate = true;
                key = "FrameRate_Minimum";
                this.frameRateMinimum = Double.parseDouble((String)info.get("FrameRate_Minimum"));
                key = "FrameRate_Maximum";
                this.frameRateMaximum = Double.parseDouble((String)info.get("FrameRate_Maximum"));
            }
            key = "FrameCount";
            this.frameCount = Integer.parseInt((String)info.get("FrameCount"));
            this.nominalFrameRate = (int)Math.round(precisionFrameRate);
            this.rawDuration = duration;
            this.startTimesMS = new double[this.frameCount];
            int i = 0;
            while (i < this.frameCount) {
                this.startTimesMS[i] = (double)(i * 1000) / precisionFrameRate;
                ++i;
            }
            System.out.println("MovieVideo: found " + frameRateMode + " FrameRate " + precisionFrameRate + " FrameCount " + this.frameCount + " Duration " + this.rawDuration + " (" + precisionFrameRate * (double)this.frameCount + " calc)");
            if (this.isVariableFrameRate) {
                System.out.println("MovieVideo: Variable frame rate " + this.frameRateMinimum + " - " + this.frameRateMaximum);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "MovieVideo MediaInfo parse error for " + key + ": " + e.getMessage();
        }
    }

    public static abstract class Loader
    extends VideoAdapter.Loader {
        @Override
        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            MovieVideo vid = (MovieVideo)obj;
            control.setValue("start_times", vid.startTimesMS, 3);
            double rawDuration = vid.rawDuration;
            control.setValue("duration", rawDuration);
            int fc = vid.frameCount;
            control.setValue("frame_count", fc);
            int fps = (int)Math.round((double)fc / rawDuration);
            control.setValue("frame_rate", fps);
            String platform = vid.sourcePlatform == null ? vid.getPlatform() : vid.sourcePlatform;
            control.setValue("platform", platform);
        }

        public void setVideo(String path, MovieVideo video2, String engine) {
            String ext = XML.getExtension(path);
            VideoType type = VideoIO.getVideoType(engine, ext);
            if (type != null) {
                video2.setProperty("video_type", type);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            try {
                String fullpath = control.getString("absolutePath");
                if (fullpath != null) {
                    return this.createVideo(control, fullpath);
                }
                String path = control.getString("path");
                if (OSPRuntime.checkTempDirCache) {
                    path = String.valueOf(OSPRuntime.tempDir) + path;
                }
                return this.createVideo(control, path);
            }
            catch (IOException ex) {
                OSPLog.fine(ex.getMessage());
                return null;
            }
        }

        @Override
        protected Video createVideo(String path) throws IOException {
            return null;
        }

        protected abstract Object createVideo(XMLControl var1, String var2) throws IOException;
    }
}

