/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.mov;

import java.util.TreeSet;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.mov.MovieFactory;

public abstract class MovieVideoType
implements VideoType {
    protected static TreeSet<VideoFileFilter> movieFileFilters = new TreeSet();
    protected boolean recordable = true;
    protected VideoFileFilter singleTypeFilter;

    static {
        MovieFactory.startMovieThumbnailTool();
    }

    public MovieVideoType() {
    }

    public MovieVideoType(VideoFileFilter filter) {
        this();
        if (filter != null) {
            this.singleTypeFilter = filter;
            movieFileFilters.add(filter);
        }
    }

    @Override
    public boolean canRecord() {
        return this.recordable;
    }

    public void setRecordable(boolean recordable) {
        this.recordable = recordable;
    }

    @Override
    public VideoFileFilter[] getFileFilters() {
        if (this.singleTypeFilter != null) {
            return new VideoFileFilter[]{this.singleTypeFilter};
        }
        return movieFileFilters.toArray(new VideoFileFilter[0]);
    }

    @Override
    public VideoFileFilter getDefaultFileFilter() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.singleTypeFilter == null ? null : this.singleTypeFilter.getDescription();
    }

    @Override
    public String getDefaultExtension() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDefaultExtension();
        }
        return null;
    }
}

