/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.xuggler.IContainer;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.xuggle.XuggleRes;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.JREFinder;

public class DiagnosticsForXuggle
extends Diagnostics {
    public static final String REQUEST_TRACKER = "Tracker";
    static String newline = System.getProperty("line.separator", "\n");
    static int vmBitness;
    static String codeBase;
    static String xuggleHome;
    static File[] codeBaseJars;
    static File[] xuggleHomeJars;
    static String pathEnvironment;
    static String pathValue;
    static String requester;

    static {
        if (!OSPRuntime.isJS) {
            vmBitness = OSPRuntime.getVMBitness();
            try {
                URL url = DiagnosticsForXuggle.class.getProtectionDomain().getCodeSource().getLocation();
                File myJarFile = new File(url.toURI());
                codeBase = myJarFile.getParent();
            }
            catch (Exception url) {
                // empty catch block
            }
            xuggleHome = System.getenv("XUGGLE_HOME");
            if (xuggleHome == null) {
                xuggleHome = (String)OSPRuntime.getPreference("XUGGLE_HOME");
            }
            String[] xuggleNames = TrackerStarter.getXuggleJarNames(OSPRuntime.getLaunchJarPath());
            xuggleHomeJars = new File[xuggleNames.length];
            codeBaseJars = new File[xuggleNames.length];
        }
    }

    private DiagnosticsForXuggle() {
    }

    public static void aboutXuggle() {
        int status = DiagnosticsForXuggle.getStatusCode();
        OSPLog.config("status code = " + status);
        OSPLog.config("XUGGLE_HOME = " + xuggleHome);
        OSPLog.config("Code base = " + codeBase);
        String javaHome = System.getProperty("java.home");
        String bitness = "(" + vmBitness + "-bit): ";
        OSPLog.config("Java VM " + bitness + javaHome);
        if (xuggleHome != null) {
            int j;
            boolean usesServer = TrackerStarter.usesXuggleServer(OSPRuntime.getLaunchJarPath());
            File xuggleSrc = usesServer ? new File(xuggleHome) : new File(xuggleHome, "share/java/jars");
            File[] xuggleJars = xuggleSrc.listFiles(TrackerStarter.xuggleFileFilter);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String[] jarDates = new String[xuggleJars.length];
            String[] jarSizes = new String[xuggleJars.length];
            String fileData = "Xuggle home files: ";
            int i = xuggleJars.length - 1;
            while (i >= 0) {
                jarDates[i] = " (modified " + sdf.format(xuggleJars[i].lastModified());
                jarSizes[i] = ", size " + xuggleJars[i].length() / 1024L + "kB) ";
                if (i < xuggleJars.length - 1) {
                    fileData = String.valueOf(fileData) + ", ";
                }
                fileData = String.valueOf(fileData) + xuggleJars[i].getName() + jarDates[i] + jarSizes[i];
                --i;
            }
            String[] xuggleNames = TrackerStarter.getXuggleJarNames(OSPRuntime.getLaunchJarPath());
            int i2 = 0;
            while (i2 < xuggleNames.length) {
                block32: {
                    j = 0;
                    while (j < xuggleJars.length) {
                        if (!xuggleJars[j].getName().startsWith(xuggleNames[i2])) {
                            ++j;
                            continue;
                        }
                        break block32;
                    }
                    fileData = String.valueOf(fileData) + ", " + xuggleNames[i2] + " NOT FOUND";
                }
                ++i2;
            }
            OSPLog.config(fileData);
            xuggleJars = new File(codeBase).listFiles(TrackerStarter.xuggleFileFilter);
            jarDates = new String[xuggleJars.length];
            jarSizes = new String[xuggleJars.length];
            fileData = "Code base files: ";
            i2 = xuggleJars.length - 1;
            while (i2 >= 0) {
                jarDates[i2] = " (modified " + sdf.format(xuggleJars[i2].lastModified());
                jarSizes[i2] = ", size " + xuggleJars[i2].length() / 1024L + "kB) ";
                if (i2 < xuggleJars.length - 1) {
                    fileData = String.valueOf(fileData) + ", ";
                }
                fileData = String.valueOf(fileData) + xuggleJars[i2].getName() + jarDates[i2] + jarSizes[i2];
                --i2;
            }
            i2 = 0;
            while (i2 < xuggleNames.length) {
                block33: {
                    j = 0;
                    while (j < xuggleJars.length) {
                        if (!xuggleJars[j].getName().startsWith(xuggleNames[i2])) {
                            ++j;
                            continue;
                        }
                        break block33;
                    }
                    fileData = String.valueOf(fileData) + ", " + xuggleNames[i2] + " NOT FOUND";
                }
                ++i2;
            }
            OSPLog.config(fileData);
            if (status == 0) {
                String fileInfo = newline;
                String path = " " + XuggleRes.getString("Xuggle.Dialog.Unknown");
                String className = "com.xuggle.xuggler.IContainer";
                try {
                    Class<?> xuggleClass = Class.forName(className);
                    URL url = xuggleClass.getProtectionDomain().getCodeSource().getLocation();
                    File codeFile = new File(url.toURI());
                    path = " " + codeFile.getAbsolutePath();
                    DateFormat format = DateFormat.getDateInstance(3);
                    Date date = new Date(codeFile.lastModified());
                    long size = codeFile.length();
                    fileInfo = " (" + format.format(date) + ", " + size + " bytes)";
                }
                catch (Exception xuggleClass) {
                    // empty catch block
                }
                String version = DiagnosticsForXuggle.getXuggleVersion();
                String message = String.valueOf(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Version")) + " " + version + fileInfo + newline + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Home") + " " + xuggleHome + newline + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Path") + path;
                JOptionPane.showMessageDialog(dialogOwner, message, XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Title"), 1);
            } else {
                String[] diagnostic = DiagnosticsForXuggle.getDiagnosticMessage(status, requester);
                Box box = Box.createVerticalBox();
                box.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                String[] codeFile = diagnostic;
                int message = diagnostic.length;
                int version = 0;
                while (version < message) {
                    String line = codeFile[version];
                    box.add(new JLabel(line));
                    ++version;
                }
                boolean showPrefsQuestionForTracker = false;
                if (status == 7 && REQUEST_TRACKER.equals(requester) && dialogOwner != null) {
                    if (OSPRuntime.isWindows()) {
                        TreeSet<File> jreDirs = JREFinder.getFinder().getJREs(32);
                        showPrefsQuestionForTracker = !jreDirs.isEmpty();
                    } else if (OSPRuntime.isMac()) {
                        showPrefsQuestionForTracker = true;
                    }
                }
                boolean showCopyJarsQuestionForTracker = false;
                if (status == 5 && REQUEST_TRACKER.equals(requester) && dialogOwner != null) {
                    showCopyJarsQuestionForTracker = true;
                }
                if (showPrefsQuestionForTracker) {
                    box.add(new JLabel("  "));
                    String question = XuggleRes.getString("Xuggle.Dialog.AboutXuggle.ShowPrefs.Question");
                    box.add(new JLabel(question));
                    int response = JOptionPane.showConfirmDialog(dialogOwner, box, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 0, 1);
                    if (response == 0) {
                        try {
                            Class<?> trackerClass = Class.forName("org.opensourcephysics.cabrillo.tracker.TFrame");
                            if (dialogOwner.getClass().equals(trackerClass)) {
                                Method m = trackerClass.getMethod("showPrefsDialog", String.class);
                                m.invoke((Object)dialogOwner, "runtime");
                            }
                        }
                        catch (Exception trackerClass) {}
                    }
                } else if (showCopyJarsQuestionForTracker) {
                    box.add(new JLabel("  "));
                    String question = XuggleRes.getString("Xuggle.Dialog.AboutXuggle.CopyJars.Question");
                    box.add(new JLabel(question));
                    int response = JOptionPane.showConfirmDialog(dialogOwner, box, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 0, 2);
                    if (response == 0) {
                        String source = XML.forwardSlash(xuggleHome);
                        if (!xuggleNames[0].contains("-server-")) {
                            source = String.valueOf(source) + "/share/java/jars";
                        }
                        if (!TrackerStarter.copyXuggleJarsTo(codeBase, source)) {
                            JOptionPane.showMessageDialog(dialogOwner, "Unable to copy xuggle jars", "Copy Failure", 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(dialogOwner, box, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 2);
                }
            }
        }
    }

    public static void aboutXuggle(String request) {
        requester = request;
        DiagnosticsForXuggle.aboutXuggle();
    }

    public static File[] getXuggleJarFiles(String dir) {
        String[] xuggleNames = TrackerStarter.getXuggleJarNames(OSPRuntime.getLaunchJarPath());
        File[] jarFiles = new File[xuggleNames.length];
        int i = 0;
        while (i < jarFiles.length) {
            String next = String.valueOf(xuggleNames[i]) + ".jar";
            File file = new File(dir, next);
            jarFiles[i] = file.exists() ? file : null;
            ++i;
        }
        return jarFiles;
    }

    public static int getStatusCode() {
        boolean mismatched;
        codeBaseJars = DiagnosticsForXuggle.getXuggleJarFiles(codeBase);
        pathEnvironment = OSPRuntime.isWindows() ? "Path" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
        pathValue = System.getenv(pathEnvironment);
        try {
            IContainer.make();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error er) {
            er.printStackTrace();
        }
        boolean completeCodeBase = codeBaseJars[0] != null;
        int i = 1;
        while (i < codeBaseJars.length) {
            completeCodeBase = completeCodeBase && codeBaseJars[i] != null;
            ++i;
        }
        if (xuggleHome == null) {
            return completeCodeBase ? 2 : 1;
        }
        boolean usesServer = TrackerStarter.usesXuggleServer(OSPRuntime.getLaunchJarPath());
        File xuggleSrc = usesServer ? new File(xuggleHome) : new File(xuggleHome, "share/java/jars");
        TrackerStarter.xuggleVersionIndex = usesServer ? 0 : 1;
        boolean completeHome = false;
        if (xuggleSrc.exists()) {
            xuggleHomeJars = xuggleSrc.listFiles(TrackerStarter.xuggleFileFilter);
            boolean bl = completeHome = xuggleHomeJars.length > 0 && xuggleHomeJars[0] != null;
        }
        if (!completeHome) {
            return 3;
        }
        if (!completeCodeBase) {
            return 5;
        }
        boolean bl = mismatched = xuggleHomeJars[0].length() != codeBaseJars[0].length();
        if (mismatched) {
            return 5;
        }
        if (vmBitness == 32) {
            return 7;
        }
        return -1;
    }

    public static String[] getDiagnosticMessage(int status, String requester) {
        if (status == 0) {
            return new String[]{"OK"};
        }
        ArrayList<String> message = new ArrayList<String>();
        String[] xuggleNames = TrackerStarter.getXuggleJarNames(OSPRuntime.getLaunchJarPath());
        switch (status) {
            case 1: {
                message.add(XuggleRes.getString("Xuggle.Dialog.NoXuggle.Message1"));
                message.add(" ");
                if (!REQUEST_TRACKER.equals(requester)) break;
                message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                message.add("https://www.compadre.org/osp/items/detail.cfm?ID=7365");
                break;
            }
            case 2: {
                message.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message1"));
                if (!REQUEST_TRACKER.equals(requester)) break;
                message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                message.add("https://www.compadre.org/osp/items/detail.cfm?ID=7365");
                break;
            }
            case 3: {
                message.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message1"));
                if (!REQUEST_TRACKER.equals(requester)) break;
                message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                break;
            }
            case 4: {
                message.add(XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message1"));
                message.add("\"" + pathEnvironment + "\" " + XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message2"));
                break;
            }
            case 5: {
                String missingJars = "";
                int i = 0;
                while (i < xuggleNames.length) {
                    if (codeBaseJars[i] == null) {
                        if (missingJars.length() > 1) {
                            missingJars = String.valueOf(missingJars) + ", ";
                        }
                        missingJars = String.valueOf(missingJars) + xuggleNames[i] + ".jar";
                    }
                    ++i;
                }
                String source = XML.forwardSlash(xuggleHome);
                if (!xuggleNames[0].contains("-server-")) {
                    source = String.valueOf(source) + "/share/java/jars";
                }
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.NotWorking.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.Missing.Message"));
                message.add(" ");
                message.add(missingJars);
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message2"));
                message.add(" ");
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + source);
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.TargetDirectory.Message")) + " " + codeBase);
                break;
            }
            case 6: {
                String missingJars = "";
                int i = 0;
                while (i < xuggleNames.length) {
                    if (codeBaseJars[i] == null) {
                        if (missingJars.length() > 1) {
                            missingJars = String.valueOf(missingJars) + ", ";
                        }
                        missingJars = String.valueOf(missingJars) + xuggleNames[i];
                    }
                    ++i;
                }
                String source = XML.forwardSlash(xuggleHome);
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.NotWorking.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.Mismatched.Message"));
                message.add(" ");
                message.add(missingJars);
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message2"));
                message.add(" ");
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + source);
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.TargetDirectory.Message")) + " " + codeBase);
                break;
            }
            case 7: {
                message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message2"));
                if (!REQUEST_TRACKER.equals(requester)) break;
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message3"));
                message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message4"));
                break;
            }
            case 8: {
                message.add(XuggleRes.getString("Xuggle.Dialog.UnsupportedVersion.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.UnsupportedVersion.Message2"));
                break;
            }
            default: {
                message.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.UnknownProblem.Message"));
            }
        }
        return message.toArray(new String[message.size()]);
    }

    public static String getXuggleVersion() {
        String xuggleVersion = XuggleRes.getString("Xuggle.Dialog.Unknown");
        int status = DiagnosticsForXuggle.getStatusCode();
        if (status == 0) {
            try {
                String name = "com.xuggle.xuggler.Version";
                Class<?> xuggleClass = Class.forName(name);
                Method method = xuggleClass.getMethod("getVersionString", new Class[0]);
                xuggleVersion = (String)method.invoke(null, null);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return xuggleVersion;
    }

    public static File getXuggleJar() {
        if (xuggleHome == null) {
            return null;
        }
        File[] jars = new File(xuggleHome).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String[] xuggleNames = TrackerStarter.getXuggleJarNames(OSPRuntime.getLaunchJarPath());
                return file.getName().startsWith(xuggleNames[0]);
            }
        });
        if (jars.length > 0) {
            return jars[0];
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(DiagnosticsForXuggle.getXuggleVersion());
        DiagnosticsForXuggle.aboutXuggle(REQUEST_TRACKER);
    }
}

