/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import java.io.File;
import java.io.IOException;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.mov.MovieVideoType;
import org.opensourcephysics.media.xuggle.XuggleVideo;
import org.opensourcephysics.media.xuggle.XuggleVideoRecorder;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleMovieVideoType
extends MovieVideoType {
    public static void register() {
        String[][] EXTENSIONS;
        String[][] stringArrayArray = new String[11][];
        String[] stringArray = new String[2];
        stringArray[1] = "avi";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[2];
        stringArray2[1] = "dv";
        stringArrayArray[1] = stringArray2;
        stringArrayArray[2] = new String[]{"flv", "flv"};
        String[] stringArray3 = new String[2];
        stringArray3[1] = "m2ts";
        stringArrayArray[3] = stringArray3;
        String[] stringArray4 = new String[2];
        stringArray4[1] = "mod";
        stringArrayArray[4] = stringArray4;
        stringArrayArray[5] = new String[]{"mov", "mov"};
        stringArrayArray[6] = new String[]{"mp4", "mp4"};
        String[] stringArray5 = new String[2];
        stringArray5[1] = "mpg";
        stringArrayArray[7] = stringArray5;
        stringArrayArray[8] = new String[]{"wmv", "asf"};
        String[] stringArray6 = new String[2];
        stringArray6[1] = "mts";
        stringArrayArray[9] = stringArray6;
        String[] stringArray7 = new String[2];
        stringArray7[1] = "ogg";
        stringArrayArray[10] = stringArray7;
        String[][] stringArrayArray2 = EXTENSIONS = stringArrayArray;
        int n = EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] ext = stringArrayArray2[n2];
            boolean isRecordable = ext[0] != null;
            String containerType = ext[1];
            String[] extensions = new String[]{ext[isRecordable ? 0 : 1]};
            VideoFileFilter filter = new VideoFileFilter(containerType, extensions);
            XuggleMovieVideoType vidType = new XuggleMovieVideoType(filter);
            vidType.setRecordable(isRecordable);
            VideoIO.addVideoType(vidType);
            ResourceLoader.addExtractExtension(ext[0]);
            ++n2;
        }
    }

    public XuggleMovieVideoType() {
    }

    public XuggleMovieVideoType(VideoFileFilter filter) {
        super(filter);
    }

    @Override
    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("XuggleVideoType.Description");
    }

    @Override
    public boolean isType(Video video2) {
        if (!video2.getClass().equals(XuggleVideo.class)) {
            return false;
        }
        if (this.singleTypeFilter == null) {
            return true;
        }
        String name = (String)video2.getProperty("name");
        return this.singleTypeFilter.accept(new File(name));
    }

    @Override
    public Video getVideo(String name, String basePath, XMLControl control) {
        XuggleVideo video2;
        try {
            video2 = new XuggleVideo(XML.getResolvedPath(name, basePath), control);
            video2.setProperty("video_type", this);
        }
        catch (IOException ex) {
            OSPLog.fine(String.valueOf(this.getDescription()) + ": " + ex.getMessage());
            video2 = null;
        }
        return video2;
    }

    @Override
    public VideoRecorder getRecorder() {
        return new XuggleVideoRecorder(this);
    }

    @Override
    public String getTypeName() {
        return "Xuggle";
    }

    public String toString() {
        return "[" + this.getTypeName() + " " + this.getDescription() + "]";
    }
}

