/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.IncrementallyLoadable;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.mov.MovieVideo;
import org.opensourcephysics.media.mov.SmoothPlayable;
import org.opensourcephysics.media.xuggle.XuggleMovieVideoType;
import org.opensourcephysics.media.xuggle.XuggleThumbnailTool;

public class XuggleVideo
extends MovieVideo
implements SmoothPlayable,
IncrementallyLoadable {
    private BufferedImage[] imageCache;
    private int cacheMax = 0;
    private RandomAccessFile raf;
    private Long[] packetTimeStamps;
    private Long[] keyTimeStamps;
    private IContainer container;
    private IStreamCoder videoDecoder;
    private IVideoResampler resampler;
    private IPacket packet;
    private IVideoPicture picture;
    private double timebase;
    private IConverter converter;
    private ArrayList<Long> packetTSList;
    private ArrayList<Long> keyTSList;
    private ArrayList<BufferedImage> imageList;
    private int index = 0;
    private long keyTimeStamp = Long.MIN_VALUE;
    private int packetCount;
    private int firstDisplayPacket = 0;
    private int streamIndex = -1;
    private long keyTS0 = Long.MIN_VALUE;
    private long systemStartPlayTime;
    private double frameStartPlayTime;
    private boolean playSmoothly = false;
    protected double[] rawStartTimes;
    private static String DEBUG_DIR;
    IVideoPicture newPic;
    private boolean fullyLoaded;

    static {
        IContainer.make();
        XuggleThumbnailTool.start();
        XuggleMovieVideoType.register();
        DEBUG_DIR = "c:/temp/tmp/";
    }

    protected int getRawFrameNumberBefore(double time) {
        if (this.rawStartTimes == null) {
            return this.getFrameNumberBefore(time);
        }
        time += 0.1;
        int i = 0;
        while (i < this.rawStartTimes.length) {
            if (time < this.rawStartTimes[i]) {
                return i - 1;
            }
            ++i;
        }
        return time < this.rawDuration * 1000.0 ? this.rawStartTimes.length - 1 : -1;
    }

    XuggleVideo(String fileName, XMLControl control) throws IOException {
        super(fileName, null, control);
        OSPLog.finest("Xuggle video loading " + this.path + " local?: " + this.isLocal);
        if (this.isExport) {
            return;
        }
        this.frameCount = -1;
        this.control = control;
        String err = this.openContainer();
        if (err != null) {
            this.dispose();
            throw new IOException(err);
        }
        this.packetTSList = new ArrayList();
        this.keyTSList = new ArrayList();
        this.frameTimes = new ArrayList();
        this.firePropertyChange("progress", fileName, 0);
        this.firstDisplayPacket = 0;
        if (!VideoIO.loadIncrementally) {
            while (this.loadMoreFrames(500)) {
            }
        }
    }

    @Override
    protected void finalizeLoading() throws IOException {
        this.packetCount = this.frameCount = this.packetTSList.size();
        if (this.packetCount == this.firstDisplayPacket) {
            this.firePropertyChange("progress", this.path, null);
            this.dispose();
            throw new IOException("packets loaded but no complete picture");
        }
        System.out.println("XuggleVideo found " + this.firstDisplayPacket + " incomplete out of " + this.packetCount + " total packets");
        if (this.cacheMax > 0) {
            int nImages = this.imageList.size();
            this.imageCache = new BufferedImage[nImages + this.firstDisplayPacket];
            int i = 0;
            int p = this.firstDisplayPacket;
            while (i < nImages) {
                this.imageCache[p++] = this.imageList.get(i);
                ++i;
            }
            this.imageList = null;
        }
        this.packetTimeStamps = this.packetTSList.toArray(new Long[this.packetCount]);
        this.keyTimeStamps = this.keyTSList.toArray(new Long[this.packetCount]);
        this.packetTSList = null;
        this.keyTSList = null;
        this.startFrameNumber = 0;
        this.frameCount = this.packetCount - this.firstDisplayPacket;
        this.endFrameNumber = this.frameCount - 1;
        this.rawDuration = (double)this.container.getDuration() / 1000000.0;
        this.setStartTimes();
        this.rawStartTimes = this.startTimesMS;
        this.rawFrameCount = this.frameCount;
        if (this.control != null) {
            this.control = this.setFromControl(this.control);
        }
        if (this.control == null) {
            this.rawStartTimes = null;
        } else {
            this.setForControl();
        }
        this.fullyLoaded = true;
        this.seekToStart();
        this.loadPictureFromNextPacket();
        BufferedImage img = this.getImage(0);
        this.firePropertyChange("progress", this.path, null);
        if (img == null) {
            this.dispose();
            throw new IOException("No images");
        }
        this.setImage(img);
    }

    private void setForControl() {
        this.rawStartTimes = null;
    }

    @Override
    public boolean loadMoreFrames(int n) throws IOException {
        boolean continuing;
        if (this.isFullyLoaded()) {
            return false;
        }
        int finalIndex = this.index + n;
        long lastDTS = Long.MIN_VALUE;
        boolean haveImages = false;
        while (this.index < finalIndex && this.container.readNextPacket(this.packet) >= 0) {
            if (VideoIO.isCanceled()) {
                this.firePropertyChange("progress", this.path, null);
                this.dispose();
                throw new IOException("Canceled by user");
            }
            if (!this.isCurrentStream()) continue;
            long dts = this.packet.getTimeStamp();
            if (this.keyTimeStamp == Long.MIN_VALUE || this.packet.isKeyPacket()) {
                this.keyTimeStamp = dts;
            }
            int offset = 0;
            int size = this.packet.getSize();
            while (offset < size) {
                int bytesDecoded = this.videoDecoder.decodeVideo(this.picture, this.packet, offset);
                if (bytesDecoded < 0) break;
                offset += bytesDecoded;
                if (this.picture.isComplete()) continue;
                if (!haveImages) {
                    ++this.firstDisplayPacket;
                    continue;
                }
                System.out.println("!! XuggleVideo picture was incomplete! dts=" + dts + " index=" + this.index);
            }
            if (dts == lastDTS) continue;
            lastDTS = dts;
            boolean isComplete = this.picture.isComplete();
            if (isComplete) {
                haveImages = true;
            }
            if (this.cacheMax > 0 && isComplete && this.imageList.size() < this.cacheMax - this.firstDisplayPacket) {
                this.imageList.add(this.getBufferedImage());
            }
            this.packetTSList.add(dts);
            this.keyTSList.add(this.keyTimeStamp);
            if (this.keyTS0 == Long.MIN_VALUE) {
                this.keyTS0 = dts;
            }
            this.frameTimes.add((double)(dts - this.keyTS0) * this.timebase);
            this.firePropertyChange("progress", this.path, this.index++);
        }
        boolean bl = continuing = this.index == finalIndex;
        if (!continuing && !this.isFullyLoaded()) {
            this.finalizeLoading();
        }
        return continuing;
    }

    void debugCache() {
        if (this.imageCache != null) {
            int i = 0;
            while (i < this.imageCache.length) {
                this.dumpImage(i, this.imageCache[i], "img");
                ++i;
            }
        }
    }

    @Override
    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        int n = this.getFrameNumber() + 1;
        this.playing = true;
        this.firePropertyChange("playing", null, new Boolean(true));
        this.startPlayingAtFrame(n);
    }

    @Override
    public void stop() {
        this.playing = false;
        this.firePropertyChange("playing", null, new Boolean(false));
    }

    @Override
    public void setFrameNumber(int n) {
        if (n == this.frameNumber) {
            return;
        }
        super.setFrameNumber(n);
        n = this.getFrameNumber();
        BufferedImage bi = this.getImage(n);
        if (bi == null) {
            return;
        }
        this.rawImage = bi;
        this.invalidateVideoAndFilter();
        this.notifyFrame(n, false);
        if (this.isPlaying()) {
            SwingUtilities.invokeLater(() -> this.continuePlaying());
        }
    }

    @Override
    public void setRate(double rate) {
        super.setRate(rate);
        if (this.isPlaying()) {
            this.startPlayingAtFrame(this.getFrameNumber());
        }
    }

    @Override
    public double getFrameCountDurationMS() {
        int n = this.getFrameCount();
        if (n == 1) {
            return 100.0;
        }
        return this.rawDuration * 1000.0;
    }

    @Override
    public void setSmoothPlay(boolean smooth) {
        this.playSmoothly = smooth;
    }

    @Override
    public boolean isSmoothPlay() {
        return this.playSmoothly;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeXuggle();
    }

    private void disposeXuggle() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.raf = null;
        }
        if (this.videoDecoder != null) {
            this.videoDecoder.close();
            this.videoDecoder.delete();
            this.videoDecoder = null;
        }
        if (this.picture != null) {
            this.picture.delete();
            this.picture = null;
        }
        if (this.packet != null) {
            this.packet.delete();
            this.packet = null;
        }
        if (this.container != null) {
            if (this.container.isOpened()) {
                this.container.close();
            }
            this.container.delete();
            this.container = null;
        }
        if (this.newPic != null) {
            this.newPic.delete();
            this.newPic = null;
        }
        if (this.converter != null) {
            this.converter.delete();
            this.converter = null;
        }
        if (this.resampler != null) {
            this.resampler.delete();
            this.resampler = null;
        }
        this.frameTimes = null;
        this.imageCache = null;
        this.firstDisplayPacket = -1;
        this.streamIndex = -1;
        this.rawImage = null;
        this.resampler = null;
        this.keyTS0 = Long.MIN_VALUE;
    }

    private void startPlayingAtFrame(int frameNumber) {
        this.systemStartPlayTime = System.currentTimeMillis();
        this.frameStartPlayTime = this.getFrameTime(frameNumber);
        this.setFrameNumber(frameNumber);
    }

    protected void continuePlaying() {
        int endNo;
        int n = this.getFrameNumber();
        if (n < (endNo = this.getEndFrameNumber())) {
            long elapsedTime = System.currentTimeMillis() - this.systemStartPlayTime;
            double frameTime = this.frameStartPlayTime + this.getRate() * (double)elapsedTime;
            int frameToPlay = this.getFrameNumberBefore(frameTime);
            while (frameToPlay > -1 && frameToPlay <= n) {
                elapsedTime = System.currentTimeMillis() - this.systemStartPlayTime;
                frameTime = this.frameStartPlayTime + this.getRate() * (double)elapsedTime;
                frameToPlay = this.getFrameNumberBefore(frameTime);
            }
            if (frameToPlay == -1) {
                frameToPlay = endNo;
            }
            this.setFrameNumber(frameToPlay);
        } else if (this.looping) {
            this.startPlayingAtFrame(this.getStartFrameNumber());
        } else {
            this.stop();
        }
    }

    private String openContainer() {
        this.disposeXuggle();
        this.container = IContainer.make();
        if (this.isLocal) {
            try {
                this.raf = new RandomAccessFile(this.path, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            this.raf = null;
            System.out.println("!!XuggleVideo path should be local!" + this.path);
        }
        if ((this.raf == null ? this.container.open(this.path, IContainer.Type.READ, null) : this.container.open(this.raf, IContainer.Type.READ, null)) < 0) {
            return "Container could not be opened for " + this.path;
        }
        if (this.streamIndex < 0) {
            int nStreams = this.container.getNumStreams();
            int i = 0;
            while (i < nStreams) {
                IStream nextStream = this.container.getStream((long)i);
                IStreamCoder coder = nextStream.getStreamCoder();
                if (coder.getCodecType().equals((Object)ICodec.Type.CODEC_TYPE_VIDEO)) {
                    this.streamIndex = i;
                    this.videoDecoder = coder;
                    this.timebase = nextStream.getTimeBase().getValue();
                    break;
                }
                ++i;
            }
            if (this.streamIndex < 0) {
                return "no video stream found in " + this.path;
            }
        } else {
            this.videoDecoder = this.container.getStream((long)this.streamIndex).getStreamCoder();
            this.timebase = this.container.getStream((long)this.streamIndex).getTimeBase().getValue();
        }
        if (this.videoDecoder.open() < 0) {
            return "unable to open video decoder in " + this.path;
        }
        this.newPicture();
        this.packet = IPacket.make();
        return null;
    }

    private void newPicture() {
        this.picture = IVideoPicture.make((IPixelFormat.Type)this.videoDecoder.getPixelType(), (int)this.videoDecoder.getWidth(), (int)this.videoDecoder.getHeight());
    }

    @Override
    protected boolean seekMS(double timeMS) {
        long timestamp = this.timeSecToTimeStamp(timeMS / 1000.0);
        return this.container.seekKeyFrame(this.streamIndex, Long.MIN_VALUE, timestamp, Long.MAX_VALUE, IContainer.SEEK_FLAG_ANY) >= 0;
    }

    @Override
    protected BufferedImage getImageForMSTimePoint(double timeMS) {
        this.seekMS(timeMS);
        if (!this.loadPictureFromNextPacket()) {
            return null;
        }
        return this.picture.isComplete() ? this.getBufferedImage() : null;
    }

    private long timeSecToTimeStamp(double timeSec) {
        return (long)(timeSec / this.timebase);
    }

    private boolean seekToStart() {
        return this.container.seekKeyFrame(-1, Long.MIN_VALUE, 0L, Long.MAX_VALUE, IContainer.SEEK_FLAG_BACKWARDS) >= 0;
    }

    private void dumpImage(int i, BufferedImage bi, String froot) {
        if (DEBUG_DIR == null) {
            return;
        }
        try {
            String ii = "00" + i;
            File outputfile = new File(String.valueOf(DEBUG_DIR) + froot + ii.substring(ii.length() - 2) + ".png");
            ImageIO.write((RenderedImage)bi, "png", outputfile);
            System.out.println("XuggleVideo " + outputfile + " created");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setImage(BufferedImage image) {
        this.rawImage = image;
        this.size.width = image.getWidth();
        this.size.height = image.getHeight();
        this.refreshBufferedImage();
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private boolean isCurrentStream() {
        return this.packet.getStreamIndex() == this.streamIndex;
    }

    private boolean loadPictureForKeyTimeStamp(long keyTS) {
        boolean doReset;
        long dts = this.packet.getTimeStamp();
        long delta = keyTS - dts;
        if (delta == 0L) {
            return true;
        }
        if (keyTS == this.keyTimeStamps[0]) {
            this.resetContainer();
            this.loadPictureFromNextPacket();
            return true;
        }
        long seekTS = keyTS;
        boolean bl = (delta < 0L || delta > (long)this.packet.getTimeBase().getDenominator()) && this.container.seekKeyFrame(this.streamIndex, seekTS, seekTS, seekTS, delta < 0L ? IContainer.SEEK_FLAG_BACKWARDS : 0) < 0 ? true : (doReset = false);
        if (doReset) {
            this.resetContainer();
        }
        while (this.container.readNextPacket(this.packet) >= 0) {
            dts = this.packet.getTimeStamp();
            if (dts == keyTS && this.packet.getStreamIndex() == this.streamIndex) {
                this.loadPictureFromPacket();
                return true;
            }
            if (this.firstDisplayPacket <= 0 || dts >= keyTS) continue;
            this.loadPictureFromPacket();
        }
        return false;
    }

    private void resetContainer() {
        if (!this.seekToStart()) {
            this.openContainer();
        }
    }

    private BufferedImage loadPictureForFrame(int frameNumber) {
        long keyTS;
        boolean justLoadNext;
        int index = this.frameNumberToContainerIndex(frameNumber);
        long targetTS = this.packetTimeStamps[index];
        long currentTS = this.packet.getTimeStamp();
        boolean bl = justLoadNext = currentTS >= (keyTS = this.keyTimeStamps[index].longValue()) && currentTS < targetTS;
        if ((currentTS != targetTS || !this.isCurrentStream()) && (justLoadNext ? this.loadPictureFromNextPacket() : this.loadPictureForKeyTimeStamp(keyTS))) {
            while (this.isCurrentStream() && (currentTS = this.packet.getTimeStamp()) != targetTS) {
                this.loadPictureFromNextPacket();
            }
        }
        return this.picture.isComplete() ? this.getBufferedImage() : null;
    }

    private int frameNumberToContainerIndex(int n) {
        return (n + this.firstDisplayPacket) % this.packetCount;
    }

    private BufferedImage getImage(int frameNumber) {
        if (frameNumber < 0 || frameNumber >= this.frameCount) {
            return null;
        }
        int index = this.frameNumberToContainerIndex(frameNumber);
        BufferedImage bi = this.imageCache != null && index < this.imageCache.length ? this.imageCache[index] : null;
        return bi == null ? this.loadPictureForFrame(frameNumber) : bi;
    }

    private BufferedImage getBufferedImage() {
        if (this.picture.getPixelType() == IPixelFormat.Type.BGR24) {
            this.newPic = this.picture;
        } else {
            if (this.resampler == null) {
                this.resampler = IVideoResampler.make((int)this.picture.getWidth(), (int)this.picture.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.picture.getWidth(), (int)this.picture.getHeight(), (IPixelFormat.Type)this.picture.getPixelType());
                if (this.resampler == null) {
                    OSPLog.warning("Could not create color space resampler");
                    return null;
                }
                this.newPic = IVideoPicture.make((IPixelFormat.Type)this.resampler.getOutputPixelFormat(), (int)this.picture.getWidth(), (int)this.picture.getHeight());
            }
            if (this.resampler.resample(this.newPic, this.picture) < 0 || this.newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                OSPLog.warning("Could not encode video as BGR24");
                return null;
            }
        }
        if (this.converter == null) {
            this.converter = ConverterFactory.createConverter((String)ConverterFactory.findRegisteredConverter((String)"XUGGLER-BGR-24").getDescriptor(), (IVideoPicture)this.newPic);
        }
        BufferedImage image = this.converter.toImage(this.newPic);
        if (this.playSmoothly) {
            System.gc();
        }
        return image;
    }

    private boolean loadPictureFromNextPacket() {
        while (this.container.readNextPacket(this.packet) >= 0) {
            if (!this.isCurrentStream()) continue;
            return this.loadPictureFromPacket();
        }
        return false;
    }

    private boolean loadPictureFromPacket() {
        int offset = 0;
        int size = this.packet.getSize();
        while (offset < size) {
            int bytesDecoded = this.videoDecoder.decodeVideo(this.picture, this.packet, offset);
            if (bytesDecoded < 0) {
                return false;
            }
            offset += bytesDecoded;
            if (this.picture.isComplete()) break;
        }
        return true;
    }

    @Override
    public String getTypeName() {
        return "Xuggle";
    }

    @Override
    public int getLoadedFrameCount() {
        return this.index;
    }

    @Override
    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    @Override
    public int getLoadableFrameCount() {
        return this.endFrameNumber + 1;
    }

    @Override
    public void setLoadableFrameCount(int n) {
        this.endFrameNumber = n - 1;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    protected String getPlatform() {
        return "Java";
    }

    public static class Loader
    extends MovieVideo.Loader {
        @Override
        protected VideoAdapter createVideo(XMLControl control, String path) throws IOException {
            XuggleVideo video2 = new XuggleVideo(path, control);
            this.setVideo(path, video2, "Xuggle");
            return video2;
        }
    }
}

