/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Comparator;
import java.util.StringTokenizer;

public abstract class ArrayLib {
    public static int IndexMax;
    public static int IndexMin;
    public static final int SORT_THRESHOLD = 30;

    public static final double max(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
                IndexMax = i;
            }
            ++i;
        }
        return max;
    }

    public static final double min(double[] a) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < a.length) {
            if (a[i] < min) {
                min = a[i];
                IndexMin = i;
            }
            ++i;
        }
        return min;
    }

    public static final int getIndexMax() {
        return IndexMax;
    }

    public static final int getIndexMin() {
        return IndexMin;
    }

    public static final double sum(double[] a) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static final int binarySearch(int[] a, int key) {
        int x1 = 0;
        int x2 = a.length;
        int i = x2 / 2;
        while (x1 < x2) {
            if (a[i] == key) {
                return i;
            }
            if (a[i] < key) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(int[] a, int key, int length) {
        int x1 = 0;
        int x2 = length;
        int i = x2 / 2;
        while (x1 < x2) {
            if (a[i] == key) {
                return i;
            }
            if (a[i] < key) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(int[] a, int key, int begin, int end) {
        int x1 = begin;
        int x2 = end;
        int i = x1 + (x2 - x1) / 2;
        while (x1 < x2) {
            if (a[i] == key) {
                return i;
            }
            if (a[i] < key) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(Object[] a, Object key) {
        int x1 = 0;
        int x2 = a.length;
        int i = x2 / 2;
        while (x1 < x2) {
            int c = ((Comparable)a[i]).compareTo(key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(Object[] a, Object key, int length) {
        int x1 = 0;
        int x2 = length;
        int i = x2 / 2;
        while (x1 < x2) {
            int c = ((Comparable)a[i]).compareTo(key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(Object[] a, Object key, int begin, int end) {
        int x1 = begin;
        int x2 = end;
        int i = x1 + (x2 - x1) / 2;
        while (x1 < x2) {
            int c = ((Comparable)a[i]).compareTo(key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(Object[] a, Object key, Comparator<Object> cp) {
        int x1 = 0;
        int x2 = a.length;
        int i = x2 / 2;
        while (x1 < x2) {
            int c = cp.compare(a[i], key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(Object[] a, Object key, Comparator<Object> cp, int length) {
        int x1 = 0;
        int x2 = length;
        int i = x2 / 2;
        while (x1 < x2) {
            int c = cp.compare(a[i], key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int binarySearch(Object[] a, Object key, Comparator<Object> cp, int begin, int end) {
        int x1 = begin;
        int x2 = end;
        int i = x1 + (x2 - x1) / 2;
        while (x1 < x2) {
            int c = cp.compare(a[i], key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * (i + 1);
    }

    public static final int find(int[] a, int key) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int find(int[] a, int key, int length) {
        int i = 0;
        while (i < length) {
            if (a[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int find(int[] a, int key, int begin, int end) {
        int i = begin;
        while (i < end) {
            if (a[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int[] resize(int[] a, int size) {
        if (a.length >= size) {
            return a;
        }
        int[] b = new int[size];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static final float[] resize(float[] a, int size) {
        if (a.length >= size) {
            return a;
        }
        float[] b = new float[size];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static final double[] resize(double[] a, int size) {
        if (a.length >= size) {
            return a;
        }
        double[] b = new double[size];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static final Object[] resize(Object[] a, int size) {
        if (a.length >= size) {
            return a;
        }
        Object[] b = new Object[size];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static final int[] trim(int[] a, int size) {
        if (a.length == size) {
            return a;
        }
        int[] b = new int[size];
        System.arraycopy(a, 0, b, 0, size);
        return b;
    }

    public static final float[] trim(float[] a, int size) {
        if (a.length == size) {
            return a;
        }
        float[] b = new float[size];
        System.arraycopy(a, 0, b, 0, size);
        return b;
    }

    public static final double[] trim(double[] a, int size) {
        if (a.length == size) {
            return a;
        }
        double[] b = new double[size];
        System.arraycopy(a, 0, b, 0, size);
        return b;
    }

    public static final Object[] trim(Object[] a, int size) {
        if (a.length == size) {
            return a;
        }
        Object[] b = new Object[size];
        System.arraycopy(a, 0, b, 0, size);
        return b;
    }

    public static final void sort(int[] a, double[] b) {
        ArrayLib.mergesort(a, b, 0, a.length - 1);
    }

    public static final void sort(int[] a, double[] b, int length) {
        ArrayLib.mergesort(a, b, 0, length - 1);
    }

    public static final void sort(int[] a, double[] b, int begin, int end) {
        ArrayLib.mergesort(a, b, begin, end - 1);
    }

    protected static final void insertionsort(int[] a, double[] b, int p, int r) {
        int j = p + 1;
        while (j <= r) {
            int key = a[j];
            double val = b[j];
            int i = j - 1;
            while (i >= p && a[i] > key) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = val;
            ++j;
        }
    }

    protected static final void mergesort(int[] a, double[] b, int p, int r) {
        if (p >= r) {
            return;
        }
        if (r - p + 1 < 30) {
            ArrayLib.insertionsort(a, b, p, r);
        } else {
            int q = (p + r) / 2;
            ArrayLib.mergesort(a, b, p, q);
            ArrayLib.mergesort(a, b, q + 1, r);
            ArrayLib.merge(a, b, p, q, r);
        }
    }

    protected static final void merge(int[] a, double[] b, int p, int q, int r) {
        int[] t = new int[r - p + 1];
        double[] v = new double[r - p + 1];
        int p1 = p;
        int p2 = q + 1;
        int i = 0;
        while (p1 <= q && p2 <= r) {
            if (a[p1] < a[p2]) {
                v[i] = b[p1];
                t[i] = a[p1++];
            } else {
                v[i] = b[p2];
                t[i] = a[p2++];
            }
            ++i;
        }
        while (p1 <= q) {
            v[i] = b[p1];
            t[i] = a[p1];
            ++p1;
            ++i;
        }
        while (p2 <= r) {
            v[i] = b[p2];
            t[i] = a[p2];
            ++p2;
            ++i;
        }
        i = 0;
        p1 = p;
        while (i < t.length) {
            b[p1] = v[i];
            a[p1] = t[i];
            ++i;
            ++p1;
        }
    }

    public static final void sort(int[] a, int[] b) {
        ArrayLib.mergesort(a, b, 0, a.length - 1);
    }

    public static final void sort(int[] a, int[] b, int length) {
        ArrayLib.mergesort(a, b, 0, length - 1);
    }

    public static final void sort(int[] a, int[] b, int begin, int end) {
        ArrayLib.mergesort(a, b, begin, end - 1);
    }

    protected static final void insertionsort(int[] a, int[] b, int p, int r) {
        int j = p + 1;
        while (j <= r) {
            int key = a[j];
            int val = b[j];
            int i = j - 1;
            while (i >= p && a[i] > key) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = val;
            ++j;
        }
    }

    protected static final void mergesort(int[] a, int[] b, int p, int r) {
        if (p >= r) {
            return;
        }
        if (r - p + 1 < 30) {
            ArrayLib.insertionsort(a, b, p, r);
        } else {
            int q = (p + r) / 2;
            ArrayLib.mergesort(a, b, p, q);
            ArrayLib.mergesort(a, b, q + 1, r);
            ArrayLib.merge(a, b, p, q, r);
        }
    }

    protected static final void merge(int[] a, int[] b, int p, int q, int r) {
        int[] t = new int[r - p + 1];
        int[] v = new int[r - p + 1];
        int p1 = p;
        int p2 = q + 1;
        int i = 0;
        while (p1 <= q && p2 <= r) {
            if (a[p1] < a[p2]) {
                v[i] = b[p1];
                t[i] = a[p1++];
            } else {
                v[i] = b[p2];
                t[i] = a[p2++];
            }
            ++i;
        }
        while (p1 <= q) {
            v[i] = b[p1];
            t[i] = a[p1];
            ++p1;
            ++i;
        }
        while (p2 <= r) {
            v[i] = b[p2];
            t[i] = a[p2];
            ++p2;
            ++i;
        }
        i = 0;
        p1 = p;
        while (i < t.length) {
            b[p1] = v[i];
            a[p1] = t[i];
            ++i;
            ++p1;
        }
    }

    public static final void sort(int[] a, Object[] b, int begin, int end) {
        int length = end - begin;
        if (length < 30) {
            ArrayLib.insertionsort(a, b, begin, end - 1);
            return;
        }
        int[] ks = new int[length];
        Object[] vs = new Object[length];
        int i = 0;
        int idx = begin;
        while (i < length) {
            ks[i] = a[idx];
            vs[i] = b[idx];
            ++i;
            ++idx;
        }
        ArrayLib.mergesort(ks, a, vs, b, begin, end, -begin);
    }

    public static final void sort(int[] a, Object[] b, int[] abuf, Object[] bbuf, int begin, int end) {
        int length = end - begin;
        if (length < 30) {
            ArrayLib.insertionsort(a, b, begin, end - 1);
            return;
        }
        int i = 0;
        int idx = begin;
        while (i < length) {
            abuf[i] = a[idx];
            bbuf[i] = b[idx];
            ++i;
            ++idx;
        }
        ArrayLib.mergesort(abuf, a, bbuf, b, begin, end, -begin);
    }

    protected static final void insertionsort(int[] a, Object[] b, int p, int r) {
        int j = p + 1;
        while (j <= r) {
            int key = a[j];
            Object val = b[j];
            int i = j - 1;
            while (i >= p && a[i] > key) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = val;
            ++j;
        }
    }

    protected static void mergesort(int[] ks, int[] kd, Object[] vs, Object[] vd, int lo, int hi, int off) {
        int length = hi - lo;
        if (length < 30) {
            ArrayLib.insertionsort(kd, vd, lo, hi - 1);
            return;
        }
        int dlo = lo;
        int dhi = hi;
        int mid = (lo += off) + (hi += off) >> 1;
        ArrayLib.mergesort(kd, ks, vd, vs, lo, mid, -off);
        ArrayLib.mergesort(kd, ks, vd, vs, mid, hi, -off);
        if (ks[mid - 1] <= ks[mid]) {
            System.arraycopy(ks, lo, kd, dlo, length);
            System.arraycopy(vs, lo, vd, dlo, length);
            return;
        }
        int i = dlo;
        int p = lo;
        int q = mid;
        while (i < dhi) {
            if (q >= hi || p < mid && ks[p] <= ks[q]) {
                vd[i] = vs[p];
                kd[i] = ks[p++];
            } else {
                vd[i] = vs[q];
                kd[i] = ks[q++];
            }
            ++i;
        }
    }

    protected static final void merge(int[] a, Object[] b, int p, int q, int r) {
        int[] t = new int[r - p + 1];
        Object[] v = new Object[r - p + 1];
        int p1 = p;
        int p2 = q + 1;
        int i = 0;
        while (p1 <= q && p2 <= r) {
            if (a[p1] < a[p2]) {
                v[i] = b[p1];
                t[i] = a[p1++];
            } else {
                v[i] = b[p2];
                t[i] = a[p2++];
            }
            ++i;
        }
        while (p1 <= q) {
            v[i] = b[p1];
            t[i] = a[p1];
            ++p1;
            ++i;
        }
        while (p2 <= r) {
            v[i] = b[p2];
            t[i] = a[p2];
            ++p2;
            ++i;
        }
        i = 0;
        p1 = p;
        while (i < t.length) {
            b[p1] = v[i];
            a[p1] = t[i];
            ++i;
            ++p1;
        }
    }

    public static final void sort(double[] a, int[] b) {
        ArrayLib.mergesort(a, b, 0, a.length - 1);
    }

    public static final void sort(double[] a, int[] b, int length) {
        ArrayLib.mergesort(a, b, 0, length - 1);
    }

    public static final void sort(double[] a, int[] b, int begin, int end) {
        ArrayLib.mergesort(a, b, begin, end - 1);
    }

    protected static final void insertionsort(double[] a, int[] b, int p, int r) {
        int j = p + 1;
        while (j <= r) {
            double key = a[j];
            int val = b[j];
            int i = j - 1;
            while (i >= p && a[i] > key) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = val;
            ++j;
        }
    }

    protected static final void mergesort(double[] a, int[] b, int p, int r) {
        if (p >= r) {
            return;
        }
        if (r - p + 1 < 30) {
            ArrayLib.insertionsort(a, b, p, r);
        } else {
            int q = (p + r) / 2;
            ArrayLib.mergesort(a, b, p, q);
            ArrayLib.mergesort(a, b, q + 1, r);
            ArrayLib.merge(a, b, p, q, r);
        }
    }

    protected static final void merge(double[] a, int[] b, int p, int q, int r) {
        double[] t = new double[r - p + 1];
        int[] v = new int[r - p + 1];
        int p1 = p;
        int p2 = q + 1;
        int i = 0;
        while (p1 <= q && p2 <= r) {
            if (a[p1] < a[p2]) {
                v[i] = b[p1];
                t[i] = a[p1++];
            } else {
                v[i] = b[p2];
                t[i] = a[p2++];
            }
            ++i;
        }
        while (p1 <= q) {
            v[i] = b[p1];
            t[i] = a[p1];
            ++p1;
            ++i;
        }
        while (p2 <= r) {
            v[i] = b[p2];
            t[i] = a[p2];
            ++p2;
            ++i;
        }
        i = 0;
        p1 = p;
        while (i < t.length) {
            b[p1] = v[i];
            a[p1] = t[i];
            ++i;
            ++p1;
        }
    }

    public static final void sort(float[] a, int[] b) {
        ArrayLib.mergesort(a, b, 0, a.length - 1);
    }

    public static final void sort(float[] a, int[] b, int length) {
        ArrayLib.mergesort(a, b, 0, length - 1);
    }

    public static final void sort(float[] a, int[] b, int begin, int end) {
        ArrayLib.mergesort(a, b, begin, end - 1);
    }

    protected static final void insertionsort(float[] a, int[] b, int p, int r) {
        int j = p + 1;
        while (j <= r) {
            float key = a[j];
            int val = b[j];
            int i = j - 1;
            while (i >= p && a[i] > key) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = val;
            ++j;
        }
    }

    protected static final void mergesort(float[] a, int[] b, int p, int r) {
        if (p >= r) {
            return;
        }
        if (r - p + 1 < 30) {
            ArrayLib.insertionsort(a, b, p, r);
        } else {
            int q = (p + r) / 2;
            ArrayLib.mergesort(a, b, p, q);
            ArrayLib.mergesort(a, b, q + 1, r);
            ArrayLib.merge(a, b, p, q, r);
        }
    }

    protected static final void merge(float[] a, int[] b, int p, int q, int r) {
        float[] t = new float[r - p + 1];
        int[] v = new int[r - p + 1];
        int p1 = p;
        int p2 = q + 1;
        int i = 0;
        while (p1 <= q && p2 <= r) {
            if (a[p1] < a[p2]) {
                v[i] = b[p1];
                t[i] = a[p1++];
            } else {
                v[i] = b[p2];
                t[i] = a[p2++];
            }
            ++i;
        }
        while (p1 <= q) {
            v[i] = b[p1];
            t[i] = a[p1];
            ++p1;
            ++i;
        }
        while (p2 <= r) {
            v[i] = b[p2];
            t[i] = a[p2];
            ++p2;
            ++i;
        }
        i = 0;
        p1 = p;
        while (i < t.length) {
            b[p1] = v[i];
            a[p1] = t[i];
            ++i;
            ++p1;
        }
    }

    public static final void sort(Object[] a, int[] b, Comparator<Object> cmp) {
        ArrayLib.mergesort(a, b, 0, a.length - 1, cmp);
    }

    public static final void sort(Object[] a, int[] b, int length, Comparator<Object> cmp) {
        ArrayLib.mergesort(a, b, 0, length - 1, cmp);
    }

    public static final void sort(Object[] a, int[] b, int begin, int end, Comparator<Object> cmp) {
        ArrayLib.mergesort(a, b, begin, end - 1, cmp);
    }

    protected static final void insertionsort(Object[] a, int[] b, int p, int r, Comparator<Object> cmp) {
        int j = p + 1;
        while (j <= r) {
            Object key = a[j];
            int val = b[j];
            int i = j - 1;
            while (i >= p && cmp.compare(a[i], key) > 0) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = val;
            ++j;
        }
    }

    protected static final void mergesort(Object[] a, int[] b, int p, int r, Comparator<Object> cmp) {
        if (p >= r) {
            return;
        }
        if (r - p + 1 < 30) {
            ArrayLib.insertionsort(a, b, p, r, cmp);
        } else {
            int q = (p + r) / 2;
            ArrayLib.mergesort(a, b, p, q, cmp);
            ArrayLib.mergesort(a, b, q + 1, r, cmp);
            ArrayLib.merge(a, b, p, q, r, cmp);
        }
    }

    protected static final void merge(Object[] a, int[] b, int p, int q, int r, Comparator<Object> cmp) {
        Object[] t = new Object[r - p + 1];
        int[] v = new int[r - p + 1];
        int p1 = p;
        int p2 = q + 1;
        int i = 0;
        while (p1 <= q && p2 <= r) {
            if (cmp.compare(a[p1], a[p2]) < 0) {
                v[i] = b[p1];
                t[i] = a[p1++];
            } else {
                v[i] = b[p2];
                t[i] = a[p2++];
            }
            ++i;
        }
        while (p1 <= q) {
            v[i] = b[p1];
            t[i] = a[p1];
            ++p1;
            ++i;
        }
        while (p2 <= r) {
            v[i] = b[p2];
            t[i] = a[p2];
            ++p2;
            ++i;
        }
        i = 0;
        p1 = p;
        while (i < t.length) {
            b[p1] = v[i];
            a[p1] = t[i];
            ++i;
            ++p1;
        }
    }

    public static int[] getIntArray(String filename) {
        int[] array = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            String line = br.readLine();
            br.close();
            StringTokenizer st = new StringTokenizer(line);
            int maxlen = st.countTokens();
            int len = 0;
            array = new int[maxlen];
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.startsWith("#")) continue;
                array[len++] = Integer.parseInt(tok);
            }
            if (len != maxlen) {
                array = ArrayLib.trim(array, len);
            }
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

