/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Butcher5
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] estimated_state;

    public Butcher5(ODE ode) {
        super(ode);
    }

    @Override
    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rate3 = new double[this.numEqn];
        this.rate4 = new double[this.numEqn];
        this.rate5 = new double[this.numEqn];
        this.rate6 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    @Override
    public double step() {
        double[] state = this.ode.getState();
        if (state == null) {
            return this.stepSize;
        }
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(state, this.rate1);
        int i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + this.stepSize * this.rate1[i] / 4.0;
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + this.stepSize * (this.rate1[i] + this.rate2[i]) / 8.0;
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate3);
        i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + this.stepSize * (-0.5 * this.rate2[i] + this.rate3[i]);
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate4);
        i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + this.stepSize * (3.0 * this.rate1[i] + 9.0 * this.rate4[i]) / 16.0;
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate5);
        i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + this.stepSize * (-3.0 * this.rate1[i] + 2.0 * this.rate2[i] + 12.0 * this.rate3[i] - 12.0 * this.rate4[i] + 8.0 * this.rate5[i]) / 7.0;
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate6);
        i = 0;
        while (i < this.numEqn) {
            state[i] = state[i] + this.stepSize * (7.0 * this.rate1[i] + 32.0 * this.rate3[i] + 12.0 * this.rate4[i] + 32.0 * this.rate5[i] + 7.0 * this.rate6[i]) / 90.0;
            ++i;
        }
        return this.stepSize;
    }
}

