/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODESolverException;

public class CashKarp45
implements ODEAdaptiveSolver {
    int error_code = 0;
    static final double[][] a = new double[][]{{0.2}, {0.075, 0.225}, {0.3, -0.9, 1.2}, {-0.2037037037037037, 2.5, -2.5925925925925926, 1.2962962962962963}, {0.029495804398148147, 0.341796875, 0.041594328703703706, 0.40034541377314814, 0.061767578125}};
    static final double[] b5 = new double[]{0.09788359788359788, 0.0, 0.4025764895330113, 0.21043771043771045, 0.0, 0.2891022021456804};
    static final double[] er = new double[]{0.004293774801587302, 0.0, -0.018668586093857832, 0.03415502683080808, 0.019321986607142856, -0.03910220214568041};
    static final int numStages = 6;
    private double stepSize = 0.01;
    private int numEqn = 0;
    private double[] temp_state;
    private double[][] k;
    private double truncErr;
    private ODE ode;
    protected double tol = 1.0E-6;
    protected boolean enableExceptions = false;

    public CashKarp45(ODE _ode) {
        this.ode = _ode;
        this.initialize(this.stepSize);
    }

    @Override
    public void initialize(double _stepSize) {
        this.stepSize = _stepSize;
        double[] state = this.ode.getState();
        if (state == null) {
            return;
        }
        if (this.numEqn != state.length) {
            this.numEqn = state.length;
            this.temp_state = new double[this.numEqn];
            this.k = new double[6][this.numEqn];
        }
    }

    @Override
    public double step() {
        int s;
        this.error_code = 0;
        int iterations = 10;
        double currentStep = this.stepSize;
        double error = 0.0;
        double[] state = this.ode.getState();
        this.ode.getRate(state, this.k[0]);
        do {
            double fac;
            --iterations;
            currentStep = this.stepSize;
            int s2 = 1;
            while (s2 < 6) {
                int i = 0;
                while (i < this.numEqn) {
                    this.temp_state[i] = state[i];
                    int j = 0;
                    while (j < s2) {
                        this.temp_state[i] = this.temp_state[i] + this.stepSize * a[s2 - 1][j] * this.k[j][i];
                        ++j;
                    }
                    ++i;
                }
                this.ode.getRate(this.temp_state, this.k[s2]);
                ++s2;
            }
            error = 0.0;
            int i = 0;
            while (i < this.numEqn) {
                this.truncErr = 0.0;
                s = 0;
                while (s < 6) {
                    this.truncErr += this.stepSize * er[s] * this.k[s][i];
                    ++s;
                }
                error = Math.max(error, Math.abs(this.truncErr));
                ++i;
            }
            if (error <= (double)1.4E-45f) {
                error = this.tol / 100000.0;
            }
            if (error > this.tol) {
                double fac2 = 0.9 * Math.pow(error / this.tol, -0.25);
                this.stepSize *= Math.max(fac2, 0.1);
                continue;
            }
            if (!(error < this.tol / 10.0) || !((fac = 0.9 * Math.pow(error / this.tol, -0.2)) > 1.0)) continue;
            this.stepSize *= Math.min(fac, 10.0);
        } while (error > this.tol && iterations > 0);
        int i = 0;
        while (i < this.numEqn) {
            s = 0;
            while (s < 6) {
                int n = i;
                state[n] = state[n] + currentStep * b5[s] * this.k[s][i];
                ++s;
            }
            ++i;
        }
        if (iterations == 0) {
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("CashKarp45 ODE solver did not converge.");
            }
        }
        return currentStep;
    }

    public void enableRuntimeExpecptions(boolean enable) {
        this.enableExceptions = enable;
    }

    @Override
    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }

    @Override
    public void setTolerance(double _tol) {
        this.tol = Math.abs(_tol);
        if (this.tol < 1.0E-12) {
            String err_msg = "Error: CashKarp ODE solver tolerance cannot be smaller than 1.0e-12.";
            if (this.enableExceptions) {
                throw new ODESolverException(err_msg);
            }
            System.err.println(err_msg);
        }
    }

    @Override
    public double getTolerance() {
        return this.tol;
    }

    @Override
    public int getErrorCode() {
        return this.error_code;
    }
}

