/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.io.Serializable;
import org.opensourcephysics.numerics.Complex;
import org.opensourcephysics.numerics.ComplexMatrix;

public class ComplexEigenvalueDecomposition
implements Serializable {
    public static void eigen(Complex[][] A, Complex[] lambda, Complex[][] vec, boolean[] fail) {
        if (A == null || lambda == null || vec == null) {
            ComplexEigenvalueDecomposition.err("null or inconsistent array sizes.");
            return;
        }
        int n = A.length;
        if (A[0].length != n || vec.length != n || vec[0].length != n || lambda.length != n) {
            ComplexEigenvalueDecomposition.err("inconsistent array sizes.");
            return;
        }
        fail[0] = false;
        if (n < 1) {
            ComplexEigenvalueDecomposition.err("zero size matrix");
            return;
        }
        int[] rowcol = new int[n];
        Complex[][] B = new Complex[n][n];
        ComplexMatrix.copy(A, B);
        if (n == 1) {
            lambda[0] = B[0][0];
            vec[0][0] = new Complex(1.0, 0.0);
            return;
        }
        if (n == 2) {
            ComplexEigenvalueDecomposition.twobytwo(B, lambda, vec);
            return;
        }
        ComplexEigenvalueDecomposition.cxhess(B, rowcol);
        int i = 0;
        while (i < n) {
            lambda[i] = new Complex(-999.0, -999.0);
            ++i;
        }
        ComplexEigenvalueDecomposition.cxeig2c(B, lambda, vec, rowcol, fail);
    }

    private static void err(String msg) {
        System.out.println("ComplexEigenvalue: " + msg);
    }

    private static void twobytwo(Complex[][] A, Complex[] lambda, Complex[][] vec) {
        Complex[] Z = new Complex[2];
        Complex b = A[0][0].add(A[1][1]);
        Complex c = A[0][0].mul(A[1][1]);
        c = c.subtract(A[0][1].mul(A[1][0]));
        Complex rad = b.mul(b).subtract(c.mul(4.0));
        rad = rad.sqrt();
        Complex l1 = b.add(rad).div(2.0);
        Complex l2 = b.subtract(rad).div(2.0);
        lambda[0] = l1;
        lambda[1] = l2;
        Z[0] = A[0][1].neg();
        Z[1] = A[0][0].subtract(l1);
        double t = ComplexMatrix.norm2(Z);
        vec[0][0] = Z[0].div(t);
        vec[1][0] = Z[1].div(t);
        Z[0] = A[1][1].subtract(l2);
        Z[1] = A[1][0].neg();
        t = ComplexMatrix.norm2(Z);
        vec[0][1] = Z[0].div(t);
        vec[1][1] = Z[1].div(t);
    }

    private static double sumabs(Complex Z) {
        return Math.abs(Z.re()) + Math.abs(Z.im());
    }

    private static void cxhess(Complex[][] A, int[] rowcol) {
        int n = A.length;
        int j = 0;
        while (j < n) {
            rowcol[j] = j;
            ++j;
        }
        int k = 0;
        int m = k + 1;
        while (m < n - 1) {
            Complex y;
            int i = m;
            Complex x = new Complex(0.0, 0.0);
            int j2 = m;
            while (j2 < n) {
                if (ComplexEigenvalueDecomposition.sumabs(A[j2][m - 1]) > ComplexEigenvalueDecomposition.sumabs(x)) {
                    x = A[j2][m - 1];
                    i = j2;
                }
                ++j2;
            }
            if (i != m) {
                int t = rowcol[m];
                rowcol[m] = rowcol[i];
                rowcol[i] = t;
                j2 = m - 1;
                while (j2 < n) {
                    y = A[i][j2];
                    A[i][j2] = A[m][j2];
                    A[m][j2] = y;
                    ++j2;
                }
                j2 = 0;
                while (j2 < n) {
                    y = A[j2][i];
                    A[j2][i] = A[j2][m];
                    A[j2][m] = y;
                    ++j2;
                }
            }
            if (ComplexEigenvalueDecomposition.sumabs(x) != 0.0) {
                int ii = m + 1;
                while (ii < n) {
                    y = A[ii][m - 1];
                    if (ComplexEigenvalueDecomposition.sumabs(y) > 0.0) {
                        A[ii][m - 1] = y = y.div(x);
                        int j3 = m;
                        while (j3 < n) {
                            A[ii][j3] = A[ii][j3].subtract(y.mul(A[m][j3]));
                            ++j3;
                        }
                        j3 = 0;
                        while (j3 < n) {
                            A[j3][m] = A[j3][m].add(y.mul(A[j3][ii]));
                            ++j3;
                        }
                    }
                    A[ii][m - 1] = new Complex(0.0, 0.0);
                    ++ii;
                }
            }
            ++m;
        }
    }

    private static void cxeig2c(Complex[][] A, Complex[] lambda, Complex[][] vec, int[] rowcol, boolean[] fail) {
        int i;
        int jj;
        int jj2;
        int i2;
        Complex z;
        Complex y;
        Complex x;
        int k;
        int j;
        double anorm = 0.0;
        int n = A.length;
        int low = 0;
        double acc = Math.pow(2.0, -23.0);
        Complex T = new Complex(0.0, 0.0);
        int itn = 30 * n;
        ComplexMatrix.identity(vec);
        int ii = n - 2;
        while (ii > 0) {
            j = rowcol[ii];
            k = ii + 1;
            while (k < n) {
                vec[k][ii] = A[k][ii - 1];
                ++k;
            }
            if (ii != j) {
                k = ii;
                while (k < n) {
                    vec[ii][k] = vec[j][k];
                    vec[j][k] = new Complex(0.0, 0.0);
                    ++k;
                }
                vec[j][ii] = new Complex(1.0, 0.0);
            }
            --ii;
        }
        int ien = n - 1;
        while (low <= ien) {
            int its = 0;
            block4: while (true) {
                Complex S;
                k = low;
                int kk = ien;
                while (kk > low) {
                    double aahr;
                    double ahr = ComplexEigenvalueDecomposition.sumabs(A[kk][kk - 1]);
                    if (ahr <= (aahr = acc * (ComplexEigenvalueDecomposition.sumabs(A[kk - 1][kk - 1]) + ComplexEigenvalueDecomposition.sumabs(A[kk][kk])))) {
                        k = kk;
                        break;
                    }
                    --kk;
                }
                if (k == ien) break;
                if (itn <= 0) {
                    fail[0] = true;
                    return;
                }
                if (its == 10 || its == 20) {
                    S = new Complex(Math.abs(A[ien][ien - 1].re()) + Math.abs(A[ien - 1][ien - 2].re()), Math.abs(A[ien][ien - 1].im()) + Math.abs(A[ien - 1][ien - 2].im()));
                } else {
                    S = A[ien][ien];
                    x = A[ien - 1][ien].mul(A[ien][ien - 1]);
                    if (ComplexEigenvalueDecomposition.sumabs(x) > 0.0) {
                        y = A[ien - 1][ien - 1].subtract(S).div(new Complex(2.0, 0.0));
                        z = y.mul(y).add(x).sqrt();
                        if (y.re() * z.re() + y.im() * z.im() < 0.0) {
                            z = z.neg();
                        }
                        Complex yy = y.add(z);
                        S = S.subtract(x.div(yy));
                    }
                }
                i2 = low;
                while (i2 <= ien) {
                    A[i2][i2] = A[i2][i2].subtract(S);
                    ++i2;
                }
                T = T.add(S);
                ++its;
                --itn;
                j = k + 1;
                double xr = ComplexEigenvalueDecomposition.sumabs(A[ien - 1][ien - 1]);
                double yr = ComplexEigenvalueDecomposition.sumabs(A[ien][ien - 1]);
                double zr = ComplexEigenvalueDecomposition.sumabs(A[ien][ien]);
                int m = k;
                int mm = ien - 1;
                while (mm >= j) {
                    double yi = yr;
                    yr = ComplexEigenvalueDecomposition.sumabs(A[mm][mm - 1]);
                    double xi = zr;
                    zr = xr;
                    if (yr <= acc * zr / yi * (zr + (xr = ComplexEigenvalueDecomposition.sumabs(A[mm - 1][mm - 1])) + xi)) {
                        m = mm;
                        break;
                    }
                    --mm;
                }
                i2 = m + 1;
                while (i2 <= ien) {
                    x = A[i2 - 1][i2 - 1];
                    y = A[i2][i2 - 1];
                    if (ComplexEigenvalueDecomposition.sumabs(x) >= ComplexEigenvalueDecomposition.sumabs(y)) {
                        z = y.div(x);
                        lambda[i2] = new Complex(-1.0, 0.0);
                    } else {
                        jj2 = i2 - 1;
                        while (jj2 < n) {
                            z = A[i2 - 1][jj2];
                            A[i2 - 1][jj2] = A[i2][jj2];
                            A[i2][jj2] = z;
                            ++jj2;
                        }
                        z = x.div(y);
                        lambda[i2] = new Complex(1.0, 0.0);
                    }
                    A[i2][i2 - 1] = z;
                    jj2 = i2;
                    while (jj2 < n) {
                        A[i2][jj2] = A[i2][jj2].subtract(z.mul(A[i2 - 1][jj2]));
                        ++jj2;
                    }
                    ++i2;
                }
                jj = m + 1;
                while (true) {
                    if (jj > ien) continue block4;
                    x = A[jj][jj - 1];
                    A[jj][jj - 1] = new Complex(0.0, 0.0);
                    if (lambda[jj].re() > 0.0) {
                        i = low;
                        while (i <= jj) {
                            z = A[i][jj - 1];
                            A[i][jj - 1] = A[i][jj];
                            A[i][jj] = z;
                            ++i;
                        }
                        i = low;
                        while (i < n) {
                            z = vec[i][jj - 1];
                            vec[i][jj - 1] = vec[i][jj];
                            vec[i][jj] = z;
                            ++i;
                        }
                    }
                    i = low;
                    while (i <= jj) {
                        A[i][jj - 1] = A[i][jj - 1].add(x.mul(A[i][jj]));
                        ++i;
                    }
                    i = low;
                    while (i < n) {
                        vec[i][jj - 1] = vec[i][jj - 1].add(x.mul(vec[i][jj]));
                        ++i;
                    }
                    ++jj;
                }
                break;
            }
            lambda[ien] = A[ien][ien].add(T);
            --ien;
        }
        i2 = 0;
        while (i2 < n) {
            anorm += ComplexEigenvalueDecomposition.sumabs(lambda[i2]);
            jj2 = i2 + 1;
            while (jj2 < n) {
                anorm += ComplexEigenvalueDecomposition.sumabs(A[i2][jj2]);
                ++jj2;
            }
            ++i2;
        }
        Complex accnorm = new Complex(anorm * Math.pow(2.0, -23.0), 0.0);
        if (anorm == 0.0 || n < 2) {
            return;
        }
        ien = n - 1;
        while (ien > low) {
            x = lambda[ien];
            i2 = ien - 1;
            while (i2 >= low) {
                z = A[i2][ien];
                jj2 = i2 + 1;
                while (jj2 < ien) {
                    z = z.add(A[i2][jj2].mul(A[jj2][ien]));
                    ++jj2;
                }
                y = x.subtract(lambda[i2]);
                if (ComplexEigenvalueDecomposition.sumabs(y) == 0.0) {
                    y = accnorm;
                }
                A[i2][ien] = z.div(y);
                --i2;
            }
            --ien;
        }
        jj = n - 1;
        while (jj >= 0) {
            i = 0;
            while (i < n) {
                z = vec[i][jj];
                k = 0;
                while (k < jj) {
                    z = z.add(vec[i][k].mul(A[k][jj]));
                    ++k;
                }
                vec[i][jj] = z;
                ++i;
            }
            --jj;
        }
    }
}

