/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.opensourcephysics.numerics.Complex;

public strictfp class ComplexMatrix {
    private static String input_file_name;
    private static BufferedReader in;
    private static String output_file_name;
    private static BufferedWriter out;
    private static PrintWriter file_out;

    public static void solve(Complex[][] A, Complex[] Y, Complex[] X) {
        int j;
        int n = A.length;
        int m = n + 1;
        Complex[][] B = new Complex[n][m];
        int[] row = new int[n];
        if (A[0].length != n || Y.length != n || X.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.solve inconsistent array sizes.");
        }
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                B[i][j] = A[i][j];
                ++j;
            }
            B[i][n] = Y[i];
            ++i;
        }
        int k = 0;
        while (k < n) {
            row[k] = k;
            ++k;
        }
        k = 0;
        while (k < n) {
            Complex pivot = B[row[k]][k];
            double abs_pivot = pivot.abs();
            int I_pivot = k;
            int i2 = k + 1;
            while (i2 < n) {
                if (B[row[i2]][k].abs() > abs_pivot) {
                    I_pivot = i2;
                    pivot = B[row[i2]][k];
                    abs_pivot = pivot.abs();
                }
                ++i2;
            }
            int hold = row[k];
            row[k] = row[I_pivot];
            row[I_pivot] = hold;
            if (abs_pivot < 1.0E-10) {
                j = k + 1;
                while (j < n + 1) {
                    B[row[k]][j] = new Complex(0.0, 0.0);
                    ++j;
                }
                ComplexMatrix.err("redundant row (singular) " + row[k]);
            } else {
                j = k + 1;
                while (j < n + 1) {
                    B[row[k]][j] = B[row[k]][j].div(B[row[k]][k]);
                    ++j;
                }
                i2 = 0;
                while (i2 < n) {
                    if (i2 != k) {
                        int j2 = k + 1;
                        while (j2 < n + 1) {
                            B[row[i2]][j2] = B[row[i2]][j2].subtract(B[row[i2]][k].mul(B[row[k]][j2]));
                            ++j2;
                        }
                    }
                    ++i2;
                }
            }
            ++k;
        }
        i = 0;
        while (i < n) {
            X[i] = B[row[i]][n];
            ++i;
        }
    }

    public static final void invert(Complex[][] A) {
        int j;
        int i;
        int n = A.length;
        int[] row = new int[n];
        int[] col = new int[n];
        Complex[] temp = new Complex[n];
        if (A[0].length != n) {
            ComplexMatrix.err("Error in Complex.Matrix.invert, matrix not square.");
        }
        int k = 0;
        while (k < n) {
            row[k] = k;
            col[k] = k;
            ++k;
        }
        k = 0;
        while (k < n) {
            int j2;
            Complex pivot = A[row[k]][col[k]];
            int I_pivot = k;
            int J_pivot = k;
            i = k;
            while (i < n) {
                j2 = k;
                while (j2 < n) {
                    double abs_pivot = pivot.abs();
                    if (A[row[i]][col[j2]].abs() > abs_pivot) {
                        I_pivot = i;
                        J_pivot = j2;
                        pivot = A[row[i]][col[j2]];
                    }
                    ++j2;
                }
                ++i;
            }
            if (pivot.abs() < 1.0E-10) {
                ComplexMatrix.err("ComplexMatrix is singular !");
                return;
            }
            int hold = row[k];
            row[k] = row[I_pivot];
            row[I_pivot] = hold;
            hold = col[k];
            col[k] = col[J_pivot];
            col[J_pivot] = hold;
            A[row[k]][col[k]] = new Complex(1.0, 0.0).div(pivot);
            j = 0;
            while (j < n) {
                if (j != k) {
                    A[row[k]][col[j]] = A[row[k]][col[j]].mul(A[row[k]][col[k]]);
                }
                ++j;
            }
            i = 0;
            while (i < n) {
                if (k != i) {
                    j2 = 0;
                    while (j2 < n) {
                        if (k != j2) {
                            A[row[i]][col[j2]] = A[row[i]][col[j2]].subtract(A[row[i]][col[k]].mul(A[row[k]][col[j2]]));
                        }
                        ++j2;
                    }
                    A[row[i]][col[k]] = A[row[i]][col[k]].mul(A[row[k]][col[k]]).neg();
                }
                ++i;
            }
            ++k;
        }
        int j3 = 0;
        while (j3 < n) {
            i = 0;
            while (i < n) {
                temp[col[i]] = A[row[i]][j3];
                ++i;
            }
            i = 0;
            while (i < n) {
                A[i][j3] = temp[i];
                ++i;
            }
            ++j3;
        }
        int i2 = 0;
        while (i2 < n) {
            j = 0;
            while (j < n) {
                temp[row[j]] = A[i2][col[j]];
                ++j;
            }
            j = 0;
            while (j < n) {
                A[i2][j] = temp[j];
                ++j;
            }
            ++i2;
        }
    }

    public static final Complex determinant(Complex[][] A) {
        int j;
        int n = A.length;
        Complex D = new Complex(1.0, 0.0);
        Complex[][] B = new Complex[n][n];
        int[] row = new int[n];
        if (A[0].length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.determinant, inconsistent array sizes.");
        }
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                B[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < n) {
            row[k] = k;
            ++k;
        }
        k = 0;
        while (k < n - 1) {
            Complex pivot = B[row[k]][k];
            double abs_pivot = pivot.abs();
            int I_pivot = k;
            int i2 = k;
            while (i2 < n) {
                if (B[row[i2]][k].abs() > abs_pivot) {
                    I_pivot = i2;
                    pivot = B[row[i2]][k];
                    abs_pivot = pivot.abs();
                }
                ++i2;
            }
            if (I_pivot != k) {
                int hold = row[k];
                row[k] = row[I_pivot];
                row[I_pivot] = hold;
                D = D.neg();
            }
            if (abs_pivot < 1.0E-10) {
                return new Complex(0.0, 0.0);
            }
            D = D.mul(pivot);
            j = k + 1;
            while (j < n) {
                B[row[k]][j] = B[row[k]][j].div(B[row[k]][k]);
                ++j;
            }
            i2 = 0;
            while (i2 < n) {
                if (i2 != k) {
                    int j2 = k + 1;
                    while (j2 < n) {
                        B[row[i2]][j2] = B[row[i2]][j2].subtract(B[row[i2]][k].mul(B[row[k]][j2]));
                        ++j2;
                    }
                }
                ++i2;
            }
            ++k;
        }
        return D.mul(B[row[n - 1]][n - 1]);
    }

    public static final void eigenvalues(Complex[][] A, Complex[][] V, Complex[] Y) {
        int n = A.length;
        Complex[][] AA = new Complex[n][n];
        Complex c = new Complex(1.0, 0.0);
        Complex s = new Complex(0.0, 0.0);
        if (A[0].length != n || V.length != n || V[0].length != n || Y.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.eigenvalues, inconsistent array sizes.");
        }
        ComplexMatrix.identity(V);
        ComplexMatrix.copy(A, AA);
        int k = 0;
        while (k < n) {
            int i = 0;
            while (i < n - 1) {
                int j = i + 1;
                while (j < n) {
                    ComplexMatrix.schur2(AA, i, j, c, s);
                    ComplexMatrix.mat44(i, j, c, s, AA, V);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        int i = 0;
        while (i < n) {
            Y[i] = AA[i][i];
            ++i;
        }
    }

    public static final void eigenCheck(Complex[][] A, Complex[][] V, Complex[] Y) {
        int j;
        if (A == null || V == null || Y == null) {
            return;
        }
        int n = A.length;
        Complex[][] B = new Complex[n][n];
        Complex[][] C = new Complex[n][n];
        Complex[] X = new Complex[n];
        Complex[] Z = new Complex[n];
        Complex[] T = new Complex[n];
        double norm = 0.0;
        if (A[0].length != n || V.length != n || V[0].length != n || Y.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.eigenCheck, inconsistent array sizes.");
        }
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                X[j] = V[j][i];
                ++j;
            }
            ComplexMatrix.mul(A, X, T);
            j = 0;
            while (j < n) {
                Z[j] = T[j].subtract(Y[i].mul(X[j]));
                ++j;
            }
            ComplexMatrix.err("check for near zero norm of Z[" + i + "]=" + Z[i]);
            ++i;
        }
        norm = ComplexMatrix.norm2(Z);
        ComplexMatrix.err("norm =" + norm + " is eigen vector error indication 1.");
        ComplexMatrix.err("det V = " + ComplexMatrix.determinant(V));
        i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                Z[j] = V[j][i];
                ++j;
            }
            ComplexMatrix.err("check for 1.0 = " + ComplexMatrix.norm2(Z));
            ++i;
        }
        i = 0;
        while (i < n) {
            ComplexMatrix.identity(B);
            ComplexMatrix.mul(B, Y[i], C);
            ComplexMatrix.subtract(A, C, B);
            Z[i] = ComplexMatrix.determinant(B);
            ++i;
        }
        norm = ComplexMatrix.norm2(Z);
        ComplexMatrix.err("norm =" + norm + " is eigen value error indication.");
    }

    static void schur2(Complex[][] A, int p, int q, Complex c, Complex s) {
        if (A[0].length != A.length) {
            ComplexMatrix.err("Error in schur2 of Complex jacobi, inconsistent array sizes.");
        }
        if (A[p][q].abs() != 0.0) {
            Complex tau = A[q][q].subtract(A[p][p]).div(A[p][q].mul(2.0));
            Complex tau_tau_1 = tau.mul(tau).add(1.0).sqrt();
            Complex t = tau.abs() >= 0.0 ? tau.add(tau_tau_1).invert() : tau_tau_1.subtract(tau).invert().neg();
            c = t.mul(t).add(1.0).sqrt().invert();
            s = t.mul(c);
        } else {
            c = new Complex(1.0, 0.0);
            s = new Complex(0.0, 0.0);
        }
    }

    static void mat22(Complex c, Complex s, Complex[][] A, Complex[][] B) {
        if (A.length != 2 || A[0].length != 2 || B.length != 2 || B[0].length != 2) {
            ComplexMatrix.err("Error in mat22 of Jacobi, not both 2 by 2");
        }
        Complex[][] T = new Complex[2][2];
        T[0][0] = c.mul(A[0][0]).subtract(s.mul(A[0][1]));
        T[0][1] = s.mul(A[0][0]).add(c.mul(A[0][1]));
        T[1][0] = c.mul(A[1][0]).subtract(s.mul(A[1][1]));
        T[1][1] = s.mul(A[1][0]).add(c.mul(A[1][1]));
        B[0][0] = c.mul(T[0][0]).subtract(s.mul(T[1][0]));
        B[0][1] = c.mul(T[0][1]).subtract(s.mul(T[1][1]));
        B[1][0] = s.mul(T[0][0]).add(c.mul(T[1][0]));
        B[1][1] = s.mul(T[0][1]).add(c.mul(T[1][1]));
    }

    static void mat44(int p, int q, Complex c, Complex s, Complex[][] A, Complex[][] V) {
        int n = A.length;
        Complex[][] B = new Complex[n][n];
        Complex[][] J = new Complex[n][n];
        if (A[0].length != n || V.length != n || V[0].length != n) {
            ComplexMatrix.err("Error in mat44 of Complex Jacobi, A or V not same and square");
        }
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                J[i][j] = new Complex(0.0, 0.0);
                ++j;
            }
            J[i][i] = new Complex(1.0, 0.0);
            ++i;
        }
        J[p][p] = c;
        J[p][q] = s.neg();
        J[q][q] = c;
        J[q][p] = s;
        ComplexMatrix.mul(J, A, B);
        J[p][q] = s;
        J[q][p] = s.neg();
        ComplexMatrix.mul(B, J, A);
        ComplexMatrix.mul(V, J, B);
        ComplexMatrix.copy(B, V);
    }

    static double norm4(Complex[][] A) {
        int n = A.length;
        int nr = A[0].length;
        double nrm = 0.0;
        if (n != nr) {
            ComplexMatrix.err("Error in Complex norm4, non square A[" + n + "][" + nr + "]");
        }
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                nrm = nrm + A[i][j].abs() + A[j][i].abs();
                ++j;
            }
            ++i;
        }
        return nrm / (double)(n * n - n);
    }

    public static final void mul(Complex[][] A, Complex[][] B, Complex[][] C) {
        int ni = A.length;
        int nk = A[0].length;
        int nj = B[0].length;
        if (B.length != nk || C.length != ni || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.mul, incompatible sizes");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = new Complex(0.0, 0.0);
                int k = 0;
                while (k < nk) {
                    C[i][j] = C[i][j].add(A[i][k].mul(B[k][j]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void mul(Complex[][] A, Complex B, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (C.length != ni || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.mul, incompatible sizes");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = A[i][j].mul(B);
                ++j;
            }
            ++i;
        }
    }

    public static final void add(Complex[][] A, Complex[][] B, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (B.length != ni || C.length != ni || B[0].length != nj || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.add, incompatible sizes");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = A[i][j].add(B[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void add(Complex[][] A, Complex B, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (C.length != ni || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.add, incompatible sizes");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = A[i][j].add(B);
                ++j;
            }
            ++i;
        }
    }

    public static final void subtract(Complex[][] A, Complex[][] B, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (B.length != ni || C.length != ni || B[0].length != nj || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.subtract, incompatible sizes");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = A[i][j].subtract(B[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void subtract(Complex[][] A, Complex B, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (C.length != ni || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.subtract, incompatible sizes");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = A[i][j].subtract(B);
                ++j;
            }
            ++i;
        }
    }

    public static final double norm1(Complex[][] A) {
        double norm = 0.0;
        int ni = A.length;
        int nj = A[0].length;
        int j = 0;
        while (j < nj) {
            double colSum = 0.0;
            int i = 0;
            while (i < ni) {
                colSum += A[i][j].abs();
                ++i;
            }
            norm = Math.max(norm, colSum);
            ++j;
        }
        return norm;
    }

    public static final double normInf(Complex[][] A) {
        double norm = 0.0;
        int ni = A.length;
        int nj = A[0].length;
        int i = 0;
        while (i < ni) {
            double rowSum = 0.0;
            int j = 0;
            while (j < nj) {
                rowSum += A[i][j].abs();
                ++j;
            }
            norm = Math.max(norm, rowSum);
            ++i;
        }
        return norm;
    }

    public static final double normFro(Complex[][] A) {
        double norm = 0.0;
        int n = A.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                norm += A[i][j].abs() * A[i][j].abs();
                ++j;
            }
            ++i;
        }
        return Math.sqrt(norm);
    }

    public static final double norm2(Complex[][] A) {
        double r = 0.0;
        int n = A.length;
        Complex[][] B = new Complex[n][n];
        Complex[][] V = new Complex[n][n];
        Complex[] BI = new Complex[n];
        if (A[0].length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.norm2, matrix not square.");
        }
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                B[i][j] = new Complex(0.0, 0.0);
                int k = 0;
                while (k < n) {
                    B[i][j] = B[i][j].add(A[k][i].mul(A[k][j]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        ComplexMatrix.eigenvalues(B, V, BI);
        i = 0;
        while (i < n) {
            r = Math.max(r, BI[i].abs());
            ++i;
        }
        return Math.sqrt(r);
    }

    public static final void copy(Complex[][] A, Complex[][] B) {
        int ni = A.length;
        int nj = A[0].length;
        if (B.length != ni || B[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.copy, inconsistent sizes.");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                B[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static final boolean equals(Complex[][] A, Complex[][] B) {
        int ni = A.length;
        int nj = A[0].length;
        boolean same = true;
        if (B.length != ni || B[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.equals, inconsistent sizes.");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                same = same && A[i][j].equals(B[i][j]);
                ++j;
            }
            ++i;
        }
        return same;
    }

    public static final void fromDouble(double[][] A, double[][] B, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (C.length != ni || C[0].length != nj || B.length != ni || B[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.fromDouble, inconsistent sizes.");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = new Complex(A[i][j], B[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void fromDouble(double[][] A, Complex[][] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (C.length != ni || C[0].length != nj) {
            ComplexMatrix.err("Error in ComplexMatrix.fromDouble, inconsistent sizes.");
        }
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                C[i][j] = new Complex(A[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void identity(Complex[][] A) {
        int n = A.length;
        if (n != A[0].length) {
            ComplexMatrix.err("Error in ComplexMatrix.identity, inconsistent sizes.");
        }
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                A[i][j] = new Complex(0.0);
                ++j;
            }
            A[i][i] = new Complex(1.0);
            ++i;
        }
    }

    public static final void zero(Complex[][] A) {
        int ni = A.length;
        int nj = A[0].length;
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                A[i][j] = new Complex(0.0);
                ++j;
            }
            ++i;
        }
    }

    public static final void print(Complex[][] A) {
        int ni = A.length;
        int nj = A[0].length;
        int i = 0;
        while (i < ni) {
            int j = 0;
            while (j < nj) {
                ComplexMatrix.err("A[" + i + "][" + j + "]=" + A[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void mul(Complex[][] A, Complex[] B, Complex[] C) {
        int ni = A.length;
        int nj = A[0].length;
        if (B.length != nj || C.length != ni) {
            ComplexMatrix.err("Error in ComplexMatrix.mul, incompatible sizes.");
        }
        int i = 0;
        while (i < ni) {
            C[i] = new Complex(0.0, 0.0);
            int j = 0;
            while (j < nj) {
                C[i] = C[i].add(A[i][j].mul(B[j]));
                ++j;
            }
            ++i;
        }
    }

    public static final void add(Complex[] X, Complex[] Y, Complex[] Z) {
        int n = X.length;
        if (Y.length != n || Z.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.add, incompatible sizes.");
        }
        int i = 0;
        while (i < n) {
            Z[i] = X[i].add(Y[i]);
            ++i;
        }
    }

    public static final void subtract(Complex[] X, Complex[] Y, Complex[] Z) {
        int n = X.length;
        if (Y.length != n || Z.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.subtract, incompatible sizes.");
        }
        int i = 0;
        while (i < n) {
            Z[i] = X[i].subtract(Y[i]);
            ++i;
        }
    }

    public static final double norm1(Complex[] X) {
        double norm = 0.0;
        int n = X.length;
        int i = 0;
        while (i < n) {
            norm += X[i].abs();
            ++i;
        }
        return norm;
    }

    public static final double norm2(Complex[] X) {
        double norm = 0.0;
        int n = X.length;
        int i = 0;
        while (i < n) {
            norm += X[i].abs() * X[i].abs();
            ++i;
        }
        return StrictMath.sqrt(norm);
    }

    public static final double normInf(Complex[] X) {
        double norm = 0.0;
        int n = X.length;
        int i = 0;
        while (i < n) {
            norm = Math.max(norm, X[i].abs());
            ++i;
        }
        return norm;
    }

    public static final void copy(Complex[] X, Complex[] Y) {
        int n = X.length;
        if (Y.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.copy, incompatible sizes");
        }
        int i = 0;
        while (i < n) {
            Y[i] = X[i];
            ++i;
        }
    }

    public static final boolean equals(Complex[] X, Complex[] Y) {
        int n = X.length;
        boolean same = true;
        if (Y.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.equals, incompatible sizes");
        }
        int i = 0;
        while (i < n) {
            same = same && X[i].equals(Y[i]);
            ++i;
        }
        return same;
    }

    public static final void fromDouble(double[] X, Complex[] Z) {
        int n = X.length;
        if (Z.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.fromDouble, incompatible sizes");
        }
        int i = 0;
        while (i < n) {
            Z[i] = new Complex(X[i]);
            ++i;
        }
    }

    public static final void fromDouble(double[] X, double[] Y, Complex[] Z) {
        int n = X.length;
        if (Z.length != n || Y.length != n) {
            ComplexMatrix.err("Error in ComplexMatrix.fromDouble, incompatible sizes");
        }
        int i = 0;
        while (i < n) {
            Z[i] = new Complex(X[i], Y[i]);
            ++i;
        }
    }

    public static void fromRoots(Complex[] X, Complex[] Y) {
        int n = X.length;
        if (Y.length != n + 1) {
            ComplexMatrix.err("Error in ComplexMatrix.fromRoots, incompatible sizes");
        }
        Y[0] = X[0].neg();
        Y[1] = new Complex(1.0);
        if (n == 1) {
            return;
        }
        int i = 1;
        while (i < n) {
            Y[i + 1] = new Complex(0.0);
            int j = 0;
            while (j <= i) {
                Y[i + 1 - j] = Y[i - j].subtract(Y[i + 1 - j].mul(X[i]));
                ++j;
            }
            Y[0] = Y[0].mul(X[i]).neg();
            ++i;
        }
    }

    public static final void unitVector(Complex[] X, int j) {
        int n = X.length;
        int i = 0;
        while (i < n) {
            X[i] = new Complex(0.0);
            ++i;
        }
        X[j] = new Complex(1.0);
    }

    public static final void zero(Complex[] X) {
        int n = X.length;
        int i = 0;
        while (i < n) {
            X[i] = new Complex(0.0);
            ++i;
        }
    }

    public static final void print(Complex[] X) {
        int n = X.length;
        int i = 0;
        while (i < n) {
            ComplexMatrix.err("X[" + i + "]=" + X[i]);
            ++i;
        }
    }

    public static final void readSize(String file_name, int[] rowCol) {
        String input_line = new String("@");
        if (input_file_name == null || !file_name.equals(input_file_name)) {
            input_file_name = file_name;
            try {
                in = new BufferedReader(new FileReader(file_name));
            }
            catch (Exception e) {
                ComplexMatrix.err("ComplexMatrix.read unable to open file " + file_name);
                return;
            }
        }
        int ni = 0;
        int nj = 0;
        try {
            input_line = in.readLine();
            while (input_line != null) {
                int len = (input_line = input_line.trim()).length();
                if (len == 0) {
                    input_line = in.readLine();
                    continue;
                }
                if (input_line.charAt(0) == '(') {
                    ComplexMatrix.err("ComplexMatrix.readSize unable to get size " + file_name);
                } else {
                    int index = 0;
                    int last = input_line.indexOf(32);
                    if (last == -1) {
                        last = len;
                    }
                    String intStr = input_line.substring(index, last);
                    ni = Integer.parseInt(intStr);
                    input_line = input_line.substring(last, len);
                    len = (input_line = input_line.trim()).length();
                    if (len == 0) {
                        nj = ni;
                    } else {
                        index = 0;
                        last = input_line.indexOf(32);
                        if (last == -1) {
                            last = len;
                        }
                        intStr = input_line.substring(index, last);
                        nj = Integer.parseInt(intStr);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            ComplexMatrix.err("ComplexMatrix.readSize unable to get size " + file_name);
        }
        rowCol[0] = ni;
        rowCol[1] = nj;
    }

    public static final void read(String file_name, Complex[][] A) {
        String intStr;
        int last;
        int index;
        int len;
        String input_line = new String("@");
        boolean have_line = false;
        if (input_file_name == null || !file_name.equals(input_file_name)) {
            input_file_name = file_name;
            try {
                in = new BufferedReader(new FileReader(file_name));
            }
            catch (Exception e) {
                ComplexMatrix.err("ComplexMatrix.read unable to open file " + file_name);
                return;
            }
        }
        int ni = 0;
        int nj = 0;
        try {
            input_line = in.readLine();
            while (input_line != null) {
                len = (input_line = input_line.trim()).length();
                if (len == 0) {
                    input_line = in.readLine();
                    continue;
                }
                if (input_line.charAt(0) == '(') {
                    ni = A.length;
                    nj = A[0].length;
                    have_line = true;
                } else {
                    index = 0;
                    last = input_line.indexOf(32);
                    if (last == -1) {
                        last = len;
                    }
                    intStr = input_line.substring(index, last);
                    ni = Integer.parseInt(intStr);
                    input_line = input_line.substring(last, len);
                    len = (input_line = input_line.trim()).length();
                    if (len == 0) {
                        nj = ni;
                    } else {
                        index = 0;
                        last = input_line.indexOf(32);
                        if (last == -1) {
                            last = len;
                        }
                        intStr = input_line.substring(index, last);
                        nj = Integer.parseInt(intStr);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            ComplexMatrix.err("ComplexMatrix.read unable to get size " + file_name);
        }
        int i = 0;
        int j = 0;
        if (A.length != ni || A[0].length != nj) {
            ComplexMatrix.err("incompatible size in ComplexMatrix.read");
            return;
        }
        try {
            if (!have_line) {
                input_line = in.readLine();
            }
            have_line = false;
            while (input_line != null) {
                len = (input_line = input_line.trim()).length();
                if (len == 0) {
                    input_line = in.readLine();
                    continue;
                }
                index = 0;
                last = input_line.indexOf(41);
                if (last == -1) {
                    input_line = in.readLine();
                    continue;
                }
                intStr = input_line.substring(index, last + 1);
                A[i][j] = Complex.parseComplex(intStr);
                if (++j == nj) {
                    j = 0;
                    ++i;
                }
                if (i != ni) {
                    input_line = input_line.substring(last + 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ComplexMatrix.err("ComplexMatrix.read unable to read data " + file_name);
        }
    }

    public static final void closeInput() {
        try {
            in.close();
        }
        catch (Exception e) {
            ComplexMatrix.err("ComplexMatrix.closeInput not closed");
        }
        input_file_name = null;
    }

    public static final void write(String file_name, Complex[][] A) {
        int ni = A.length;
        int nj = A[0].length;
        if (output_file_name == null || !file_name.equals(output_file_name)) {
            output_file_name = file_name;
            try {
                out = new BufferedWriter(new FileWriter(file_name));
                file_out = new PrintWriter(out);
            }
            catch (Exception e) {
                ComplexMatrix.err("ComplexMatrix.write unable to open file " + file_name);
                return;
            }
        }
        if (ni == nj) {
            file_out.println(ni);
        } else {
            file_out.println(String.valueOf(ni) + " " + nj);
        }
        try {
            int i = 0;
            while (i < ni) {
                int j = 0;
                while (j < nj) {
                    file_out.println(A[i][j].toString());
                    ++j;
                }
                ++i;
            }
            file_out.println();
        }
        catch (Exception e) {
            ComplexMatrix.err("ComplexMatrix.write unable to write data " + file_name);
        }
    }

    private static void err(String msg) {
        System.out.println("ComplexMatrix: " + msg);
    }

    public static final void closeOutput() {
        file_out.close();
        output_file_name = null;
    }
}

