/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Interpolation;
import org.opensourcephysics.numerics.Util;

public class CubicSpline
implements Function {
    private double startDerivative = Double.NaN;
    private double endDerivative = Double.NaN;
    private int guessIndex = 1;
    double[] xd;
    double[] yd;
    double[] coefficients;
    int sign;

    public CubicSpline(double[] xdata, double[] ydata) {
        this.update(xdata, ydata);
    }

    public CubicSpline(double[] xdata, double[] ydata, double startDyDx, double endDyDx) {
        this.startDerivative = startDyDx;
        this.endDerivative = endDyDx;
        this.update(xdata, ydata);
    }

    public void update(double[] xdata, double[] ydata, double startDyDx, double endDyDx) {
        this.startDerivative = startDyDx;
        this.endDerivative = endDyDx;
        this.update(xdata, ydata);
    }

    public void update(double[] xdata, double[] ydata) {
        if (this.xd == null || this.xd.length != xdata.length) {
            this.xd = (double[])xdata.clone();
        } else {
            System.arraycopy(xdata, 0, this.xd, 0, this.xd.length);
        }
        if (this.yd == null || this.yd.length != ydata.length) {
            this.yd = (double[])ydata.clone();
        } else {
            System.arraycopy(ydata, 0, this.yd, 0, this.yd.length);
        }
        if (this.xd.length != this.yd.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        this.sign = Util.checkSorting(this.xd);
        if (this.sign == 0) {
            throw new IllegalArgumentException("X array must be sorted in either increasing or decreasing order.");
        }
        if (this.xd.length > 2) {
            this.computeSecondDerivatives();
        }
    }

    @Override
    public double evaluate(double x) {
        int n1 = 0;
        int n2 = this.xd.length - 1;
        if (n2 < 1) {
            return this.yd[0];
        }
        if (n2 == 1) {
            return Interpolation.linear(x, this.xd[0], this.xd[1], this.yd[0], this.yd[1]);
        }
        if ((double)this.sign * x < (double)this.sign * this.xd[1]) {
            n2 = 1;
        } else if ((double)this.sign * x > (double)this.sign * this.xd[n2 - 1]) {
            n1 = n2 - 1;
        } else {
            if (this.guessIndex > 0 && (double)this.sign * x > (double)this.sign * this.xd[this.guessIndex - 1]) {
                n1 = this.guessIndex - 1;
            }
            if (this.guessIndex < n2 && (double)this.sign * x < (double)this.sign * this.xd[this.guessIndex + 1]) {
                n2 = this.guessIndex + 1;
            }
        }
        while (n2 - n1 > 1) {
            int n = (n1 + n2) / 2;
            if ((double)this.sign * this.xd[n] > (double)this.sign * x) {
                n2 = n;
                continue;
            }
            n1 = n;
        }
        this.guessIndex = n1;
        double step = this.xd[n2] - this.xd[n1];
        double a = (this.xd[n2] - x) / step;
        double b = (x - this.xd[n1]) / step;
        return a * this.yd[n1] + b * this.yd[n2] + (a * (a * a - 1.0) * this.coefficients[n1] + b * (b * b - 1.0) * this.coefficients[n2]) * step * step / 6.0;
    }

    public Function firstDerivative() {
        return new splineFirstDerivate();
    }

    public Function secondDerivative() {
        return new splineSecondDerivate();
    }

    private void computeSecondDerivatives() {
        double w;
        double s;
        int n = this.xd.length;
        double[] u = new double[n - 1];
        this.coefficients = new double[n];
        if (Double.isNaN(this.startDerivative)) {
            u[0] = 0.0;
            this.coefficients[0] = 0.0;
        } else {
            this.coefficients[0] = -0.5;
            u[0] = 3.0 / (this.xd[1] - this.xd[0]) * ((this.yd[1] - this.yd[0]) / (this.xd[1] - this.xd[0]) - this.startDerivative);
        }
        int i = 1;
        while (i < n - 1) {
            double invStep2 = 1.0 / (this.xd[i + 1] - this.xd[i - 1]);
            s = (this.xd[i] - this.xd[i - 1]) * invStep2;
            w = 1.0 / (s * this.coefficients[i - 1] + 2.0);
            this.coefficients[i] = (s - 1.0) * w;
            u[i] = (6.0 * invStep2 * ((this.yd[i + 1] - this.yd[i]) / (this.xd[i + 1] - this.xd[i]) - (this.yd[i] - this.yd[i - 1]) / (this.xd[i] - this.xd[i - 1])) - s * u[i - 1]) * w;
            ++i;
        }
        if (Double.isNaN(this.endDerivative)) {
            s = 0.0;
            w = 0.0;
        } else {
            w = -0.5;
            s = 3.0 / (this.xd[n - 1] - this.xd[n - 2]) * (this.endDerivative - (this.yd[n - 1] - this.yd[n - 2]) / (this.xd[n - 1] - this.xd[n - 2]));
        }
        this.coefficients[n - 1] = (s - w * u[n - 2]) / (w * this.coefficients[n - 2] + 1.0);
        i = n - 2;
        while (i >= 0) {
            this.coefficients[i] = this.coefficients[i] * this.coefficients[i + 1] + u[i];
            --i;
        }
    }

    class splineFirstDerivate
    implements Function {
        splineFirstDerivate() {
        }

        @Override
        public double evaluate(double x) {
            int n1 = 0;
            int n2 = CubicSpline.this.xd.length - 1;
            if (n2 < 1) {
                return 0.0;
            }
            if (n2 == 1) {
                return CubicSpline.this.xd[1] - CubicSpline.this.xd[0] == 0.0 ? Double.POSITIVE_INFINITY : (CubicSpline.this.yd[1] - CubicSpline.this.yd[0]) / (CubicSpline.this.xd[1] - CubicSpline.this.xd[0]);
            }
            if ((double)CubicSpline.this.sign * x < (double)CubicSpline.this.sign * CubicSpline.this.xd[1]) {
                n2 = 1;
            } else if ((double)CubicSpline.this.sign * x > (double)CubicSpline.this.sign * CubicSpline.this.xd[n2 - 1]) {
                n1 = n2 - 1;
            } else {
                if (CubicSpline.this.guessIndex > 0 && (double)CubicSpline.this.sign * x > (double)CubicSpline.this.sign * CubicSpline.this.xd[CubicSpline.this.guessIndex - 1]) {
                    n1 = CubicSpline.this.guessIndex - 1;
                }
                if (CubicSpline.this.guessIndex < n2 && (double)CubicSpline.this.sign * x < (double)CubicSpline.this.sign * CubicSpline.this.xd[CubicSpline.this.guessIndex + 1]) {
                    n2 = CubicSpline.this.guessIndex + 1;
                }
            }
            while (n2 - n1 > 1) {
                int n = (n1 + n2) / 2;
                if ((double)CubicSpline.this.sign * CubicSpline.this.xd[n] > (double)CubicSpline.this.sign * x) {
                    n2 = n;
                    continue;
                }
                n1 = n;
            }
            CubicSpline.this.guessIndex = n1;
            double step = CubicSpline.this.xd[n2] - CubicSpline.this.xd[n1];
            double a = (CubicSpline.this.xd[n2] - x) / step;
            double b = (x - CubicSpline.this.xd[n1]) / step;
            return (CubicSpline.this.yd[n2] - CubicSpline.this.yd[n1]) / step + ((1.0 - 3.0 * a * a) * CubicSpline.this.coefficients[n1] + (3.0 * b * b - 1.0) * CubicSpline.this.coefficients[n2]) * step / 6.0;
        }
    }

    class splineSecondDerivate
    implements Function {
        splineSecondDerivate() {
        }

        @Override
        public double evaluate(double x) {
            int n1 = 0;
            int n2 = CubicSpline.this.xd.length - 1;
            if (n2 <= 1) {
                return 0.0;
            }
            if ((double)CubicSpline.this.sign * x < (double)CubicSpline.this.sign * CubicSpline.this.xd[1]) {
                n2 = 1;
            } else if ((double)CubicSpline.this.sign * x > (double)CubicSpline.this.sign * CubicSpline.this.xd[n2 - 1]) {
                n1 = n2 - 1;
            } else {
                if (CubicSpline.this.guessIndex > 0 && (double)CubicSpline.this.sign * x > (double)CubicSpline.this.sign * CubicSpline.this.xd[CubicSpline.this.guessIndex - 1]) {
                    n1 = CubicSpline.this.guessIndex - 1;
                }
                if (CubicSpline.this.guessIndex < n2 && (double)CubicSpline.this.sign * x < (double)CubicSpline.this.sign * CubicSpline.this.xd[CubicSpline.this.guessIndex + 1]) {
                    n2 = CubicSpline.this.guessIndex + 1;
                }
            }
            while (n2 - n1 > 1) {
                int n = (n1 + n2) / 2;
                if ((double)CubicSpline.this.sign * CubicSpline.this.xd[n] > (double)CubicSpline.this.sign * x) {
                    n2 = n;
                    continue;
                }
                n1 = n;
            }
            CubicSpline.this.guessIndex = n1;
            double step = CubicSpline.this.xd[n2] - CubicSpline.this.xd[n1];
            double a = (CubicSpline.this.xd[n2] - x) / step;
            double b = (x - CubicSpline.this.xd[n1]) / step;
            return a * CubicSpline.this.coefficients[n1] + b * CubicSpline.this.coefficients[n2];
        }
    }
}

