/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.NumericMethodException;
import org.opensourcephysics.numerics.Util;

public class Derivative {
    private Derivative() {
    }

    public static Function getFirst(final Function f, final double h) {
        return new Function(){

            @Override
            public double evaluate(double x) {
                return (f.evaluate(x + h) - f.evaluate(x - h)) / h / 2.0;
            }
        };
    }

    public static Function getSecond(final Function f, final double h) {
        return new Function(){

            @Override
            public double evaluate(double x) {
                return (f.evaluate(x + h) - 2.0 * f.evaluate(x) + f.evaluate(x - h)) / h / h;
            }
        };
    }

    public static double romberg(Function f, double x0, double h, double tol, double[] d6) {
        int n = 6;
        double[] d = d6 != null && d6.length >= 6 ? d6 : new double[6];
        d[0] = (f.evaluate(x0 + h) - f.evaluate(x0 - h)) / h / 2.0;
        int error_code = 1;
        int j = 1;
        while (j <= n - 1) {
            d[j] = 0.0;
            double d1 = d[0];
            double h2 = h;
            if ((h *= 0.5) < Util.defaultNumericalPrecision) {
                error_code = 2;
                break;
            }
            d[0] = (f.evaluate(x0 + h) - f.evaluate(x0 - h)) / h2;
            int m = 4;
            int i = 1;
            while (i <= j) {
                double d2 = d[i];
                d[i] = ((double)m * d[i - 1] - d1) / (double)(m - 1);
                d1 = d2;
                ++i;
                m *= 4;
            }
            if (Math.abs(d[j] - d[j - 1]) < tol) {
                return d[j];
            }
            ++j;
        }
        throw new NumericMethodException("Derivative did not converge.", error_code, d[0]);
    }

    public static double first(Function f, double x, double h) {
        return (f.evaluate(x + h) - f.evaluate(x - h)) / h / 2.0;
    }

    public static double centered(Function f, double x, double h) {
        return (f.evaluate(x + h) - f.evaluate(x - h)) / h / 2.0;
    }

    public static double backward(Function f, double x, double h) {
        return (f.evaluate(x - 2.0 * h) - 4.0 * f.evaluate(x - h) + 3.0 * f.evaluate(x)) / h / 2.0;
    }

    public static double forward(Function f, double x, double h) {
        return (-f.evaluate(x + 2.0 * h) + 4.0 * f.evaluate(x + h) - 3.0 * f.evaluate(x)) / h / 2.0;
    }

    public static double firstPartial(MultiVarFunction f, double[] x, int n, double h) {
        double n0 = x[n];
        x[n] = n0 + h;
        double d = f.evaluate(x);
        x[n] = n0 - h;
        d = (d - f.evaluate(x)) / 2.0 / h;
        x[n] = n0;
        return d;
    }

    public static double second(Function f, double x, double h) {
        return (f.evaluate(x + h) - 2.0 * f.evaluate(x) + f.evaluate(x - h)) / h / h;
    }
}

