/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class EulerRichardson
extends AbstractODESolver {
    private double[] rate;
    private double[] midstate;

    public EulerRichardson(ODE ode) {
        super(ode);
    }

    @Override
    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate = new double[this.numEqn];
        this.midstate = new double[this.numEqn];
    }

    @Override
    public double step() {
        double[] state = this.ode.getState();
        this.ode.getRate(state, this.rate);
        double dt2 = this.stepSize / 2.0;
        int i = 0;
        while (i < this.numEqn) {
            this.midstate[i] = state[i] + this.rate[i] * dt2;
            ++i;
        }
        this.ode.getRate(this.midstate, this.rate);
        i = 0;
        while (i < this.numEqn) {
            state[i] = state[i] + this.stepSize * this.rate[i];
            ++i;
        }
        return this.stepSize;
    }
}

