/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.opensourcephysics.numerics.InvertibleFunction;

public final class FunctionTransform
extends AffineTransform {
    double m00;
    double m10 = 1.0;
    double m01 = 1.0;
    double m11;
    double m02;
    double m12;
    double[] flatmatrix = new double[6];
    InvertibleFunction xFunction;
    InvertibleFunction yFunction;
    boolean applyXFunction = false;
    boolean applyYFunction = false;

    public FunctionTransform() {
    }

    public FunctionTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        super(m00, m10, m01, m11, m02, m12);
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
    }

    public void setXFunction(InvertibleFunction x) {
        if (x == null) {
            throw new NullPointerException("x function can not be null.");
        }
        this.xFunction = x;
    }

    public void setYFunction(InvertibleFunction y) {
        if (y == null) {
            throw new NullPointerException("y function can not be null.");
        }
        this.yFunction = y;
    }

    public void setApplyXFunction(boolean b) {
        this.applyXFunction = b;
    }

    public void setApplyYFunction(boolean b) {
        this.applyYFunction = b;
    }

    @Override
    public void translate(double tx, double ty) {
        super.translate(tx, ty);
        this.updateMatrix();
    }

    @Override
    public void rotate(double theta) {
        super.rotate(theta);
        this.updateMatrix();
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        this.updateMatrix();
    }

    @Override
    public void scale(double sx, double sy) {
        super.scale(sx, sy);
        this.updateMatrix();
    }

    @Override
    public void shear(double shx, double shy) {
        super.shear(shx, shy);
        this.updateMatrix();
    }

    @Override
    public void setToIdentity() {
        super.setToIdentity();
        this.updateMatrix();
    }

    @Override
    public void setToTranslation(double tx, double ty) {
        super.setToTranslation(tx, ty);
        this.updateMatrix();
    }

    @Override
    public void setToRotation(double theta) {
        super.setToRotation(theta);
        this.updateMatrix();
    }

    @Override
    public void setToRotation(double theta, double x, double y) {
        super.setToRotation(theta, x, y);
        this.updateMatrix();
    }

    @Override
    public void setToScale(double sx, double sy) {
        super.setToScale(sx, sy);
        this.updateMatrix();
    }

    @Override
    public void setToShear(double shx, double shy) {
        super.setToShear(shx, shy);
        this.updateMatrix();
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        super.setTransform(Tx);
        this.updateMatrix();
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        super.setTransform(m00, m10, m01, m11, m02, m12);
        this.updateMatrix();
    }

    @Override
    public void concatenate(AffineTransform Tx) {
        super.concatenate(Tx);
        this.updateMatrix();
    }

    @Override
    public void preConcatenate(AffineTransform Tx) {
        super.preConcatenate(Tx);
        this.updateMatrix();
    }

    @Override
    public AffineTransform createInverse() throws NoninvertibleTransformException {
        AffineTransform at = super.createInverse();
        FunctionTransform ft = new FunctionTransform();
        ft.setTransform(at);
        InvertibleFunction xFunction = new InvertibleFunction(){

            @Override
            public double evaluate(double x) {
                return FunctionTransform.this.xFunction.getInverse(x);
            }

            @Override
            public double getInverse(double y) {
                return FunctionTransform.this.xFunction.evaluate(y);
            }
        };
        InvertibleFunction yFunction = new InvertibleFunction(){

            @Override
            public double evaluate(double x) {
                return FunctionTransform.this.yFunction.getInverse(x);
            }

            @Override
            public double getInverse(double y) {
                return FunctionTransform.this.yFunction.evaluate(y);
            }
        };
        ft.setXFunction(xFunction);
        ft.setYFunction(yFunction);
        return ft;
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) {
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        if (this.applyXFunction) {
            x = this.xFunction.evaluate(x);
        }
        if (this.applyYFunction) {
            y = this.yFunction.evaluate(y);
        }
        ptDst.setLocation(x * this.m00 + y * this.m01 + this.m02, x * this.m10 + y * this.m11 + this.m12);
        return ptDst;
    }

    @Override
    public void transform(Point2D[] ptSrc, int srcOff, Point2D[] ptDst, int dstOff, int numPts) {
        while (--numPts >= 0) {
            Point2D dst;
            Point2D src = ptSrc[srcOff++];
            double x = src.getX();
            double y = src.getY();
            if (this.applyXFunction) {
                x = this.xFunction.evaluate(x);
            }
            if (this.applyYFunction) {
                y = this.yFunction.evaluate(y);
            }
            if ((dst = ptDst[dstOff++]) == null) {
                dst = src instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                ptDst[dstOff - 1] = dst;
            }
            dst.setLocation(x * this.m00 + y * this.m01 + this.m02, x * this.m10 + y * this.m11 + this.m12);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        double M00 = this.m00;
        double M01 = this.m01;
        double M02 = this.m02;
        double M10 = this.m10;
        double M11 = this.m11;
        double M12 = this.m12;
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (this.applyXFunction) {
                x = this.xFunction.evaluate(x);
            }
            if (this.applyYFunction) {
                y = this.yFunction.evaluate(y);
            }
            dstPts[dstOff++] = (float)(M00 * x + M01 * y + M02);
            dstPts[dstOff++] = (float)(M10 * x + M11 * y + M12);
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        double M00 = this.m00;
        double M01 = this.m01;
        double M02 = this.m02;
        double M10 = this.m10;
        double M11 = this.m11;
        double M12 = this.m12;
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (this.applyXFunction) {
                x = this.xFunction.evaluate(x);
            }
            if (this.applyYFunction) {
                y = this.yFunction.evaluate(y);
            }
            dstPts[dstOff++] = M00 * x + M01 * y + M02;
            dstPts[dstOff++] = M10 * x + M11 * y + M12;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double M00 = this.m00;
        double M01 = this.m01;
        double M02 = this.m02;
        double M10 = this.m10;
        double M11 = this.m11;
        double M12 = this.m12;
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (this.applyXFunction) {
                x = this.xFunction.evaluate(x);
            }
            if (this.applyYFunction) {
                y = this.yFunction.evaluate(y);
            }
            dstPts[dstOff++] = M00 * x + M01 * y + M02;
            dstPts[dstOff++] = M10 * x + M11 * y + M12;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        double M00 = this.m00;
        double M01 = this.m01;
        double M02 = this.m02;
        double M10 = this.m10;
        double M11 = this.m11;
        double M12 = this.m12;
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (this.applyXFunction) {
                x = this.xFunction.evaluate(x);
            }
            if (this.applyYFunction) {
                y = this.yFunction.evaluate(y);
            }
            dstPts[dstOff++] = (float)(M00 * x + M01 * y + M02);
            dstPts[dstOff++] = (float)(M10 * x + M11 * y + M12);
        }
    }

    @Override
    public Point2D inverseTransform(Point2D ptSrc, Point2D ptDst) throws NoninvertibleTransformException {
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        return ptDst;
    }

    @Override
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        double det;
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        if (Math.abs(det = this.m00 * this.m11 - this.m01 * this.m10) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformException("Determinant is " + det);
        }
    }

    @Override
    public Point2D deltaTransform(Point2D ptSrc, Point2D ptDst) {
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        if (this.applyXFunction) {
            x = this.xFunction.evaluate(x);
        }
        if (this.applyYFunction) {
            y = this.yFunction.evaluate(y);
        }
        ptDst.setLocation(x * this.m00 + y * this.m01, x * this.m10 + y * this.m11);
        return ptDst;
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        double M00 = this.m00;
        double M01 = this.m01;
        double M10 = this.m10;
        double M11 = this.m11;
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (this.applyXFunction) {
                x = this.xFunction.evaluate(x);
            }
            if (this.applyYFunction) {
                y = this.yFunction.evaluate(y);
            }
            dstPts[dstOff++] = x * M00 + y * M01;
            dstPts[dstOff++] = x * M10 + y * M11;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FunctionTransform) {
            FunctionTransform a = (FunctionTransform)obj;
            double[] matrix = new double[6];
            a.getMatrix(matrix);
            if (this.m00 == matrix[0] && this.m01 == matrix[1] && this.m02 == matrix[2] && this.m10 == matrix[3] && this.m11 == matrix[4] && this.m12 == matrix[5] && this.applyXFunction == a.applyXFunction && this.applyYFunction == a.applyYFunction) {
                return this.xFunction.getClass() == a.xFunction.getClass() && this.yFunction.getClass() == a.yFunction.getClass();
            }
        } else if (obj instanceof AffineTransform && !this.applyXFunction && !this.applyYFunction) {
            return super.equals(obj);
        }
        return false;
    }

    private void updateMatrix() {
        this.getMatrix(this.flatmatrix);
        this.m00 = this.flatmatrix[0];
        this.m10 = this.flatmatrix[1];
        this.m01 = this.flatmatrix[2];
        this.m11 = this.flatmatrix[3];
        this.m02 = this.flatmatrix[4];
        this.m12 = this.flatmatrix[5];
    }
}

