/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Heun3
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] rate3;
    private double[] estimated_state;

    public Heun3(ODE ode) {
        super(ode);
    }

    @Override
    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rate3 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    @Override
    public double step() {
        double[] state = this.ode.getState();
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(state, this.rate1);
        int i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + this.stepSize * this.rate1[i] / 3.0;
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        i = 0;
        while (i < this.numEqn) {
            this.estimated_state[i] = state[i] + 2.0 * this.stepSize * this.rate2[i] / 3.0;
            ++i;
        }
        this.ode.getRate(this.estimated_state, this.rate3);
        i = 0;
        while (i < this.numEqn) {
            state[i] = state[i] + this.stepSize * (this.rate1[i] + 3.0 * this.rate3[i]) / 4.0;
            ++i;
        }
        return this.stepSize;
    }
}

