/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;

public class LagrangeInterpolator
implements Function {
    protected double[] hornerCoef;
    double[] xd;
    double[] yd;

    public LagrangeInterpolator(double[] xdata, double[] ydata) {
        this.hornerCoef = new double[xdata.length];
        this.xd = xdata;
        this.yd = ydata;
        this.computeCoefficients(xdata, ydata);
    }

    private void computeCoefficients(double[] xd, double[] yd) {
        int n = xd.length;
        int i = 0;
        while (i < n) {
            this.hornerCoef[i] = yd[i];
            ++i;
        }
        --n;
        i = 0;
        while (i < n) {
            int k = n;
            while (k > i) {
                int k1 = k - 1;
                int kn = k - (i + 1);
                this.hornerCoef[k] = (this.hornerCoef[k] - this.hornerCoef[k1]) / (xd[k] - xd[kn]);
                --k;
            }
            ++i;
        }
    }

    @Override
    public double evaluate(double x) {
        int n = this.hornerCoef.length;
        double answer = this.hornerCoef[--n];
        while (--n >= 0) {
            answer = answer * (x - this.xd[n]) + this.hornerCoef[n];
        }
        return answer;
    }

    public double[] getCoefficients() {
        int n = this.xd.length;
        double[] temp = new double[n];
        double[] coef = new double[n];
        temp[n - 1] = -this.xd[0];
        int i = 1;
        while (i < n) {
            int j = n - i - 1;
            while (j < n - 1) {
                int n2 = j;
                temp[n2] = temp[n2] - this.xd[i] * temp[j + 1];
                ++j;
            }
            int n3 = n - 1;
            temp[n3] = temp[n3] - this.xd[i];
            ++i;
        }
        int j = 0;
        while (j < n) {
            double a = n;
            int k = n - 1;
            while (k >= 1) {
                a = (double)k * temp[k] + this.xd[j] * a;
                --k;
            }
            double b = this.yd[j] / a;
            double c = 1.0;
            int k2 = n - 1;
            while (k2 >= 0) {
                int n4 = k2;
                coef[n4] = coef[n4] + c * b;
                c = temp[k2] + this.xd[j] * c;
                --k2;
            }
            ++j;
        }
        return coef;
    }
}

