/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;

public class Legendre {
    static final ArrayList<Polynomial> legendreList = new ArrayList();

    static {
        Polynomial p = new Polynomial(new double[]{1.0});
        legendreList.add(p);
        p = new Polynomial(new double[]{0.0, 1.0});
        legendreList.add(p);
    }

    private Legendre() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < legendreList.size()) {
            return legendreList.get(n);
        }
        Polynomial part1 = new Polynomial(new double[]{0.0, 2 * (n - 1) + 1});
        Polynomial p1 = Legendre.getPolynomial(n - 1).multiply(part1);
        Polynomial p2 = Legendre.getPolynomial(n - 2).multiply(n - 1);
        Polynomial p = p1.subtract(p2).multiply(1.0 / (double)n);
        legendreList.add(p);
        return p;
    }
}

