/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MatrixTransformation;

public class Matrix2DTransformation
implements MatrixTransformation {
    private double[] origin = new double[]{0.0, 0.0};
    private AffineTransform originTransform = new AffineTransform();
    private AffineTransform internalTransform = new AffineTransform();
    private AffineTransform originInverseTransform = new AffineTransform();
    private AffineTransform totalTransform = new AffineTransform();

    public Matrix2DTransformation(double[][] matrix) {
        if (matrix != null) {
            this.internalTransform.setTransform(matrix[0][0], matrix[1][0], matrix[0][1], matrix[1][1], matrix[0][2], matrix[1][2]);
        }
        this.update();
    }

    public Matrix2DTransformation(AffineTransform transform) {
        this.internalTransform.setTransform(transform);
        this.update();
    }

    public static Matrix2DTransformation rotation(double theta) {
        return new Matrix2DTransformation(AffineTransform.getRotateInstance(theta));
    }

    public static Matrix2DTransformation rotation(double theta, double anchorx, double anchory) {
        return new Matrix2DTransformation(AffineTransform.getRotateInstance(theta, anchorx, anchory));
    }

    public AffineTransform getTotalTransform() {
        return this.totalTransform;
    }

    @Override
    public Object clone() {
        return new Matrix2DTransformation(this.internalTransform);
    }

    @Override
    public final double[] getFlatMatrix(double[] mat) {
        if (mat == null) {
            mat = new double[6];
        }
        this.internalTransform.getMatrix(mat);
        return mat;
    }

    public static Matrix2DTransformation createAlignmentTransformation(double[] v1, double[] v2) {
        return new Matrix2DTransformation(AffineTransform.getRotateInstance(Math.atan2(v2[1], v2[0]) - Math.atan2(v1[1], v1[0])));
    }

    private void update() {
        this.totalTransform.setTransform(this.originTransform);
        this.totalTransform.concatenate(this.internalTransform);
        this.totalTransform.concatenate(this.originInverseTransform);
    }

    public void setOrigin(double ox, double oy) {
        this.origin[0] = ox;
        this.origin[1] = oy;
        this.originTransform = AffineTransform.getTranslateInstance(ox, oy);
        this.originInverseTransform = AffineTransform.getTranslateInstance(-ox, -oy);
        this.update();
    }

    public double[] setOrigin(double[] origin) {
        this.setOrigin(origin[0], origin[1]);
        return origin;
    }

    public final void multiply(Matrix2DTransformation trans) {
        this.internalTransform.concatenate(trans.internalTransform);
        this.update();
    }

    public final void multiply(double[][] mat) {
        this.internalTransform.concatenate(new Matrix2DTransformation((double[][])mat).internalTransform);
        this.update();
    }

    @Override
    public double[] direct(double[] point) {
        this.totalTransform.transform(point, 0, point, 0, 1);
        return point;
    }

    @Override
    public double[] inverse(double[] point) throws UnsupportedOperationException {
        try {
            this.totalTransform.inverseTransform(point, 0, point, 0, 1);
            return point;
        }
        catch (NoninvertibleTransformException exc) {
            throw new UnsupportedOperationException("The inverse matrix does not exist.");
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Matrix2DTransformationLoader();
    }

    protected static class Matrix2DTransformationLoader
    extends XMLLoader {
        protected Matrix2DTransformationLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Matrix2DTransformation transf = (Matrix2DTransformation)obj;
            control.setValue("matrix", transf.getFlatMatrix(null));
            control.setValue("origin x", transf.origin);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Matrix2DTransformation(new AffineTransform());
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Matrix2DTransformation transf = (Matrix2DTransformation)obj;
            transf.internalTransform.setTransform(new AffineTransform((double[])control.getObject("matrix")));
            transf.setOrigin((double[])control.getObject("origin"));
            return obj;
        }
    }
}

