/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODEEventSolver;
import org.opensourcephysics.numerics.ODEInterpolationSolver;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.numerics.TriggerODE;

public class ODEBisectionEventSolver
implements ODEEventSolver,
ODEAdaptiveSolver {
    public static final int MAX = 50;
    protected int size;
    protected double[] statea;
    protected ODESolver solver;
    protected TriggerODE triggerOde;
    protected Vector<StateEvent> eventList = new Vector();
    protected Vector<StateEvent> happened = new Vector();
    protected int errorCode = 0;
    protected boolean eventHappened = false;

    public ODEBisectionEventSolver(ODE ode, Class<?> solverClass) {
        this.triggerOde = new TriggerODE(ode);
        try {
            Class[] c = new Class[]{ODE.class};
            Object[] o = new Object[]{this.triggerOde};
            Constructor<?> constructor = solverClass.getDeclaredConstructor(c);
            this.solver = (ODESolver)constructor.newInstance(o);
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            System.err.println("BisectionEventSolver: Solver class " + solverClass + " not found!");
            System.err.println("  I will use RK4 as default solver.");
            this.solver = new RK4(this.triggerOde);
        }
    }

    @Override
    public void addEvent(StateEvent event) {
        this.eventList.add(event);
    }

    @Override
    public void removeEvent(StateEvent event) {
        this.eventList.remove(event);
    }

    @Override
    public void initialize(double stepSize) {
        this.triggerOde.readRealState();
        this.size = this.triggerOde.getState().length;
        this.statea = new double[this.size];
        this.solver.initialize(stepSize);
    }

    @Override
    public void setStepSize(double stepSize) {
        this.solver.setStepSize(stepSize);
    }

    @Override
    public double getStepSize() {
        return this.solver.getStepSize();
    }

    @Override
    public void setTolerance(double tol) {
        if (this.solver instanceof ODEAdaptiveSolver) {
            ((ODEAdaptiveSolver)this.solver).setTolerance(tol);
        }
    }

    @Override
    public double getTolerance() {
        if (this.solver instanceof ODEAdaptiveSolver) {
            return ((ODEAdaptiveSolver)this.solver).getTolerance();
        }
        return 0.0;
    }

    public boolean getEventHappened() {
        return this.eventHappened;
    }

    @Override
    public double step() {
        this.errorCode = 0;
        this.eventHappened = false;
        double t = 0.0;
        double origDt = this.solver.getStepSize();
        do {
            this.triggerOde.readRealState();
            System.arraycopy(this.triggerOde.getState(), 0, this.statea, 0, this.size);
            double dt = this.solver.step();
            double[] state = this.triggerOde.getState();
            this.happened.clear();
            Enumeration<StateEvent> e = this.eventList.elements();
            while (e.hasMoreElements()) {
                StateEvent evt = e.nextElement();
                if (!(evt.evaluate(state) <= -evt.getTolerance())) continue;
                this.happened.add(evt);
            }
            if (this.happened.size() == 0) {
                this.triggerOde.updateRealState();
                this.solver.setStepSize(origDt);
                return dt;
            }
            this.eventHappened = true;
            this.triggerOde.setState(this.statea);
            StateEvent eventFound = null;
            Enumeration<StateEvent> e2 = this.happened.elements();
            while (e2.hasMoreElements()) {
                StateEvent evt = e2.nextElement();
                if (!(Math.abs(evt.evaluate(this.statea)) < evt.getTolerance())) continue;
                eventFound = evt;
                break;
            }
            if (eventFound == null) {
                if (this.solver instanceof ODEInterpolationSolver) {
                    this.solver.initialize(this.solver.getStepSize());
                }
                int i = 0;
                while (i < 50) {
                    StateEvent evt;
                    this.solver.setStepSize(dt *= 0.5);
                    double c = this.solver.step();
                    state = this.triggerOde.getState();
                    StateEvent previousFound = null;
                    Enumeration<StateEvent> e3 = this.happened.elements();
                    while (e3.hasMoreElements()) {
                        evt = e3.nextElement();
                        double f_i = evt.evaluate(state);
                        if (f_i <= -evt.getTolerance()) {
                            previousFound = evt;
                            break;
                        }
                        if (!(f_i < evt.getTolerance())) continue;
                        eventFound = evt;
                    }
                    if (previousFound != null) {
                        e3 = this.happened.elements();
                        while (e3.hasMoreElements()) {
                            evt = e3.nextElement();
                            if (evt == previousFound || !(evt.evaluate(state) > -evt.getTolerance())) continue;
                            this.happened.remove(evt);
                        }
                        this.triggerOde.setState(this.statea);
                        if (this.solver instanceof ODEInterpolationSolver) {
                            this.solver.initialize(this.solver.getStepSize());
                        }
                    } else {
                        t += c;
                        System.arraycopy(state, 0, this.statea, 0, this.size);
                        if (eventFound != null) break;
                    }
                    ++i;
                }
                if (eventFound == null) {
                    eventFound = this.happened.elementAt(0);
                    System.err.println("BisectionEventSolver Warning : Event not found after 50 subdivisions.");
                    System.err.println("  Event = " + eventFound);
                    System.err.println("  Please check your event algorithm or decrease the initial stepTime.");
                    this.errorCode = 2;
                }
            }
            this.triggerOde.updateRealState();
            if (eventFound.action()) {
                if (this.solver instanceof ODEInterpolationSolver) {
                    this.triggerOde.readRealState();
                    this.solver.initialize(origDt);
                } else {
                    this.solver.setStepSize(origDt);
                }
                return t;
            }
            if (this.solver instanceof ODEInterpolationSolver) {
                this.triggerOde.readRealState();
                this.solver.initialize(origDt - t);
                continue;
            }
            this.solver.setStepSize(origDt - t);
        } while (t < origDt);
        this.solver.setStepSize(origDt);
        return t;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }
}

