/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Adams4;
import org.opensourcephysics.numerics.Adams5;
import org.opensourcephysics.numerics.Adams6;
import org.opensourcephysics.numerics.Butcher5;
import org.opensourcephysics.numerics.CashKarp45;
import org.opensourcephysics.numerics.DormandPrince45;
import org.opensourcephysics.numerics.Euler;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.Fehlberg8;
import org.opensourcephysics.numerics.Heun3;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.Ralston2;
import org.opensourcephysics.numerics.Verlet;

public class ODESolverFactory {
    private ODESolverFactory() {
    }

    public static ODESolver createODESolver(ODE ode, String solverName) {
        if ((solverName = solverName.trim().toLowerCase()).equals("rk4")) {
            return new RK4(ode);
        }
        if (solverName.equals("multistep")) {
            return new ODEMultistepSolver(ode);
        }
        if (solverName.equals("adams4")) {
            return new Adams4(ode);
        }
        if (solverName.equals("adams5")) {
            return new Adams5(ode);
        }
        if (solverName.equals("adams6")) {
            return new Adams6(ode);
        }
        if (solverName.equals("butcher5")) {
            return new Butcher5(ode);
        }
        if (solverName.equals("cashkarp45")) {
            return new CashKarp45(ode);
        }
        if (solverName.equals("dormandprince45")) {
            return new DormandPrince45(ode);
        }
        if (solverName.equals("eulerrichardson")) {
            return new EulerRichardson(ode);
        }
        if (solverName.equals("euler")) {
            return new Euler(ode);
        }
        if (solverName.equals("fehlberg8")) {
            return new Fehlberg8(ode);
        }
        if (solverName.equals("heun3")) {
            return new Heun3(ode);
        }
        if (solverName.equals("ralston2")) {
            return new Ralston2(ode);
        }
        if (solverName.equals("verlet")) {
            return new Verlet(ode);
        }
        return null;
    }
}

