/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.numerics.SuryonoParser;

public final class ParsedMultiVarFunction
implements MultiVarFunction {
    private final String fStr;
    private final MultiVarFunction myFunction;
    private final String[] myFunctionNames;
    public boolean isNull;

    public ParsedMultiVarFunction(String _fStr, String[] var, boolean allowUnkownIdentifiers) throws ParserException {
        this.fStr = _fStr;
        this.isNull = this.fStr.equals("0") || this.fStr.equals("0.0");
        SuryonoParser parser = new SuryonoParser(this.fStr, var, allowUnkownIdentifiers);
        this.myFunction = parser;
        this.myFunctionNames = parser.getFunctionNames();
    }

    @Override
    public double evaluate(double[] x) {
        return this.isNull ? 0.0 : this.myFunction.evaluate(x);
    }

    public String toString() {
        return "f(x) = " + this.fStr;
    }

    public String[] getFunctionNames() {
        return this.myFunctionNames;
    }

    public boolean evaluatedToNaN() {
        return !this.isNull && this.myFunction instanceof SuryonoParser && ((SuryonoParser)this.myFunction).evaluatedToNaN();
    }
}

