/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.Polynomial;

public class PolynomialLeastSquareFit
extends Polynomial {
    double[][] systemMatrix;
    double[] systemConstants;

    public PolynomialLeastSquareFit(double[] xd, double[] yd, int degree) {
        super(new double[degree + 1]);
        int ncoef = degree + 1;
        this.systemMatrix = new double[ncoef][ncoef];
        this.systemConstants = new double[ncoef];
        this.fitData(xd, yd);
    }

    public PolynomialLeastSquareFit(double[] coeffs) {
        super(coeffs);
        int n = coeffs.length;
        this.systemMatrix = new double[n][n];
        this.systemConstants = new double[n];
    }

    public void fitData(double[] xd, double[] yd) {
        if (xd.length != yd.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        if (xd.length < this.degree() + 1) {
            return;
        }
        int i = 0;
        while (i < this.systemConstants.length) {
            this.systemConstants[i] = 0.0;
            int j = 0;
            while (j < this.systemConstants.length) {
                this.systemMatrix[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = xd.length;
        while (i < n) {
            double xp1 = 1.0;
            int j = 0;
            while (j < this.systemConstants.length) {
                int n2 = j;
                this.systemConstants[n2] = this.systemConstants[n2] + xp1 * yd[i];
                double xp2 = xp1;
                int k = 0;
                while (k <= j) {
                    double[] dArray = this.systemMatrix[j];
                    int n3 = k++;
                    dArray[n3] = dArray[n3] + xp2;
                    xp2 *= xd[i];
                }
                xp1 *= xd[i];
                ++j;
            }
            ++i;
        }
        this.computeCoefficients();
    }

    protected void computeCoefficients() {
        int i = 0;
        while (i < this.systemConstants.length) {
            int j = i + 1;
            while (j < this.systemConstants.length) {
                this.systemMatrix[i][j] = this.systemMatrix[j][i];
                ++j;
            }
            ++i;
        }
        LUPDecomposition lupSystem = new LUPDecomposition(this.systemMatrix);
        double[][] components = lupSystem.inverseMatrixComponents();
        if (components == null) {
            return;
        }
        LUPDecomposition.symmetrizeComponents(components);
        this.coefficients = lupSystem.solve(this.systemConstants);
    }
}

