/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MatrixTransformation;
import org.opensourcephysics.numerics.Vec3D;
import org.opensourcephysics.numerics.VectorMath;

public class Quaternion
implements MatrixTransformation {
    static final double SQRT2 = Math.sqrt(2.0);
    protected double q0;
    protected double q1;
    protected double q2;
    protected double q3;
    protected double ox = 0.0;
    protected double oy = 0.0;
    protected double oz = 0.0;

    public Quaternion(double q0, double q1, double q2, double q3) {
        this.q0 = q0;
        this.q1 = q1;
        this.q2 = q2;
        this.q3 = q3;
        this.normalize();
    }

    public Quaternion(double q0, Vec3D vector) {
        this(q0, vector.x, vector.y, vector.z);
    }

    public Quaternion(double[] q) {
        this.q0 = q[0];
        this.q1 = q[1];
        this.q2 = q[2];
        this.q3 = q[3];
        this.normalize();
    }

    public Quaternion(Quaternion q) {
        this.q0 = q.q0;
        this.q1 = q.q1;
        this.q2 = q.q2;
        this.q3 = q.q3;
        this.normalize();
    }

    public Quaternion() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public static Quaternion createAlignmentTransformation(double[] v1, double[] v2) {
        v1 = VectorMath.normalize((double[])v1.clone());
        v2 = VectorMath.normalize((double[])v2.clone());
        double[] r = VectorMath.cross3D(v1, v2);
        double s = Math.sqrt(2.0 * (1.0 + VectorMath.dot(v1, v2)));
        return new Quaternion(s / 2.0, r[0] / s, r[1] / s, r[2] / s);
    }

    public void setOrigin(double ox, double oy, double oz) {
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
    }

    public double[] setOrigin(double[] origin) {
        this.ox = origin[0];
        this.oy = origin[1];
        this.oz = origin[2];
        return origin;
    }

    public double[] getOrigin() {
        return new double[]{this.ox, this.oy, this.oz};
    }

    public final double[][] getRotationMatrix(double[][] mat) {
        double q0q0 = this.q0 * this.q0;
        double q0q1 = this.q0 * this.q1;
        double q0q2 = this.q0 * this.q2;
        double q0q3 = this.q0 * this.q3;
        double q1q1 = this.q1 * this.q1;
        double q1q2 = this.q1 * this.q2;
        double q1q3 = this.q1 * this.q3;
        double q2q2 = this.q2 * this.q2;
        double q2q3 = this.q2 * this.q3;
        double q3q3 = this.q3 * this.q3;
        if (mat == null) {
            mat = new double[3][3];
        }
        mat[0][0] = q0q0 + q1q1 - q2q2 - q3q3;
        mat[0][1] = 2.0 * (-q0q3 + q1q2);
        mat[0][2] = 2.0 * (q0q2 + q1q3);
        mat[1][0] = 2.0 * (q0q3 + q1q2);
        mat[1][1] = q0q0 - q1q1 + q2q2 - q3q3;
        mat[1][2] = 2.0 * (-q0q1 + q2q3);
        mat[2][0] = 2.0 * (-q0q2 + q1q3);
        mat[2][1] = 2.0 * (q0q1 + q2q3);
        mat[2][2] = q0q0 - q1q1 - q2q2 + q3q3;
        return mat;
    }

    @Override
    public final double[] getFlatMatrix(double[] mat) {
        double q0q0 = this.q0 * this.q0;
        double q0q1 = this.q0 * this.q1;
        double q0q2 = this.q0 * this.q2;
        double q0q3 = this.q0 * this.q3;
        double q1q1 = this.q1 * this.q1;
        double q1q2 = this.q1 * this.q2;
        double q1q3 = this.q1 * this.q3;
        double q2q2 = this.q2 * this.q2;
        double q2q3 = this.q2 * this.q3;
        double q3q3 = this.q3 * this.q3;
        if (mat == null) {
            mat = new double[16];
        }
        mat[0] = q0q0 + q1q1 - q2q2 - q3q3;
        mat[4] = 2.0 * (-q0q3 + q1q2);
        mat[8] = 2.0 * (q0q2 + q1q3);
        mat[1] = 2.0 * (q0q3 + q1q2);
        mat[5] = q0q0 - q1q1 + q2q2 - q3q3;
        mat[9] = 2.0 * (-q0q1 + q2q3);
        mat[2] = 2.0 * (-q0q2 + q1q3);
        mat[3] = 0.0;
        mat[6] = 2.0 * (q0q1 + q2q3);
        mat[7] = 0.0;
        mat[10] = q0q0 - q1q1 - q2q2 + q3q3;
        mat[11] = 0.0;
        mat[12] = this.ox - this.ox * mat[0] - this.oy * mat[4] - this.oz * mat[8];
        mat[13] = this.oy - this.ox * mat[1] - this.oy * mat[5] - this.oz * mat[9];
        mat[14] = this.oz - this.ox * mat[2] - this.oy * mat[6] - this.oz * mat[10];
        mat[15] = 1.0;
        return mat;
    }

    public double[] getCoordinates() {
        return new double[]{this.q0, this.q1, this.q2, this.q3};
    }

    public void setCoordinates(double q0, double q1, double q2, double q3) {
        this.q0 = q0;
        this.q1 = q1;
        this.q2 = q2;
        this.q3 = q3;
        this.normalize();
    }

    public double[] setCoordinates(double[] q) {
        this.q0 = q[0];
        this.q1 = q[1];
        this.q2 = q[2];
        this.q3 = q[3];
        this.normalize();
        return q;
    }

    public final void normalize() {
        double norm = this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (norm == 1.0) {
            return;
        }
        norm = 1.0 / Math.sqrt(norm);
        this.q0 *= norm;
        this.q1 *= norm;
        this.q2 *= norm;
        this.q3 *= norm;
    }

    public final void conjugate() {
        this.q1 = -this.q1;
        this.q2 = -this.q2;
        this.q3 = -this.q3;
    }

    public final void add(Quaternion q) {
        this.q0 += q.q0;
        this.q1 += q.q1;
        this.q2 += q.q2;
        this.q3 += q.q3;
    }

    public final void subtract(Quaternion q) {
        this.q0 -= q.q0;
        this.q1 -= q.q1;
        this.q2 -= q.q2;
        this.q3 -= q.q3;
    }

    public final void multiply(Quaternion q) {
        double w = this.q0 * q.q0 - this.q1 * q.q1 - this.q2 * q.q2 - this.q3 * q.q3;
        double x = this.q3 * q.q2 - this.q2 * q.q3 + this.q1 * q.q0 + this.q0 * q.q1;
        double y = this.q1 * q.q3 - this.q3 * q.q1 + this.q2 * q.q0 + this.q0 * q.q2;
        double z = this.q2 * q.q1 - this.q1 * q.q2 + this.q3 * q.q0 + this.q0 * q.q3;
        this.q0 = w;
        this.q1 = x;
        this.q2 = y;
        this.q3 = z;
        this.normalize();
    }

    public final double dot(Quaternion q) {
        return this.q0 * q.q0 + this.q1 * q.q1 + this.q2 * q.q2 + this.q3 * q.q3;
    }

    public final double magnitudeSquared() {
        return this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
    }

    public final double magnitude() {
        return Math.sqrt(this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
    }

    public final double angle(Quaternion q) {
        double norm1 = Math.sqrt(this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
        double norm2 = Math.sqrt(q.q1 * q.q1 + q.q2 * q.q2 + q.q3 * q.q3);
        double w = Math.sqrt(1.0 + (this.q1 * q.q1 + this.q2 * q.q2 + this.q3 * q.q3) / norm1 / norm2);
        return 2.0 * Math.acos(w / SQRT2);
    }

    @Override
    public Object clone() {
        Quaternion q = new Quaternion(this.q0, this.q1, this.q2, this.q3);
        q.setOrigin(this.ox, this.oy, this.oz);
        return q;
    }

    @Override
    public double[] direct(double[] p) {
        p[0] = p[0] - this.ox;
        p[1] = p[1] - this.oy;
        p[2] = p[2] - this.oz;
        double pMult = 2.0 * this.q0 * this.q0 - 1.0;
        double vMult = 2.0 * (this.q1 * p[0] + this.q2 * p[1] + this.q3 * p[2]);
        double crossMult = 2.0 * this.q0;
        double x = pMult * p[0] + vMult * this.q1 + crossMult * (this.q2 * p[2] - this.q3 * p[1]);
        double y = pMult * p[1] + vMult * this.q2 + crossMult * (this.q3 * p[0] - this.q1 * p[2]);
        p[2] = pMult * p[2] + vMult * this.q3 + crossMult * (this.q1 * p[1] - this.q2 * p[0]) + this.oz;
        p[0] = x + this.ox;
        p[1] = y + this.oy;
        return p;
    }

    @Override
    public double[] inverse(double[] p) throws UnsupportedOperationException {
        p[0] = p[0] - this.ox;
        p[1] = p[1] - this.oy;
        p[2] = p[2] - this.oz;
        double pMult = 2.0 * this.q0 * this.q0 - 1.0;
        double vMult = 2.0 * (this.q1 * p[0] + this.q2 * p[1] + this.q3 * p[2]);
        double crossMult = -2.0 * this.q0;
        double x = pMult * p[0] + vMult * this.q1 + crossMult * (this.q2 * p[2] - this.q3 * p[1]);
        double y = pMult * p[1] + vMult * this.q2 + crossMult * (this.q3 * p[0] - this.q1 * p[2]);
        p[2] = pMult * p[2] + vMult * this.q3 + crossMult * (this.q1 * p[1] - this.q2 * p[0]) + this.oz;
        p[0] = x + this.ox;
        p[1] = y + this.oy;
        return p;
    }

    public static XML.ObjectLoader getLoader() {
        return new QuaternionLoader();
    }

    protected static class QuaternionLoader
    extends XMLLoader {
        protected QuaternionLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Quaternion qr = (Quaternion)obj;
            control.setValue("q0", qr.q0);
            control.setValue("q1", qr.q1);
            control.setValue("q2", qr.q2);
            control.setValue("q3", qr.q3);
            control.setValue("ox", qr.ox);
            control.setValue("oy", qr.oy);
            control.setValue("oz", qr.oz);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Quaternion();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Quaternion qr = (Quaternion)obj;
            double q0 = control.getDouble("q0");
            double q1 = control.getDouble("q0");
            double q2 = control.getDouble("q0");
            double q3 = control.getDouble("q0");
            qr.setCoordinates(q0, q1, q2, q3);
            double ox = control.getDouble("ox");
            double oy = control.getDouble("oy");
            double oz = control.getDouble("oz");
            qr.setOrigin(ox, oy, oz);
            return obj;
        }
    }
}

