/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.RK45;

public class RK45MultiStep
extends RK45 {
    private static int maxMessages = 3;
    private double fixedStepSize = 0.1;
    protected int maxIterations = 200;

    public RK45MultiStep(ODE _ode) {
        super(_ode);
    }

    @Override
    public double step() {
        this.error_code = 0;
        if (this.fixedStepSize > 0.0) {
            return this.fixedStepSize - this.plus();
        }
        return this.fixedStepSize - this.minus();
    }

    public void setMaxIterations(int n) {
        this.maxIterations = Math.max(1, n);
    }

    private double plus() {
        double remainder = this.fixedStepSize;
        if (super.getStepSize() <= 0.0 || super.getStepSize() > this.fixedStepSize || this.fixedStepSize - super.getStepSize() == this.fixedStepSize) {
            super.setStepSize(this.fixedStepSize);
        }
        int counter = 0;
        while (remainder > this.tol * this.fixedStepSize) {
            ++counter;
            double oldRemainder = remainder;
            if (remainder < super.getStepSize()) {
                double tempStep = super.getStepSize();
                super.setStepSize(remainder);
                double delta = super.step();
                remainder -= delta;
                super.setStepSize(tempStep);
            } else {
                remainder -= super.step();
            }
            if (this.error_code == 0 && !(Math.abs(oldRemainder - remainder) <= (double)1.4E-45f) && !(this.tol * this.fixedStepSize / 10.0 > super.getStepSize()) && counter <= this.maxIterations) continue;
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("RK45 ODE solver did not converge.");
            }
            System.err.println("Warning: RK45MultiStep did not converge. Remainder=" + remainder);
            if (--maxMessages != 0) break;
            System.err.println("RK45 ODE solver did not converge. Further warnings suppressed.");
            break;
        }
        return remainder;
    }

    private double minus() {
        double remainder = this.fixedStepSize;
        if (super.getStepSize() >= 0.0 || super.getStepSize() < this.fixedStepSize || this.fixedStepSize - super.getStepSize() == this.fixedStepSize) {
            super.setStepSize(this.fixedStepSize);
        }
        int counter = 0;
        while (remainder < this.tol * this.fixedStepSize) {
            ++counter;
            double oldRemainder = remainder;
            if (remainder > super.getStepSize()) {
                double tempStep = super.getStepSize();
                super.setStepSize(remainder);
                double delta = super.step();
                remainder -= delta;
                super.setStepSize(tempStep);
            } else {
                remainder -= super.step();
            }
            if (this.error_code == 0 && !(Math.abs(oldRemainder - remainder) <= (double)1.4E-45f) && !(this.tol * this.fixedStepSize / 10.0 < super.getStepSize()) && counter <= this.maxIterations) continue;
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("RK45 ODE solver did not converge.");
            }
            if (maxMessages <= 0) break;
            System.err.println("Warning: RK45MultiStep did not converge. Remainder=" + remainder);
            if (--maxMessages != 0) break;
            System.err.println("Further warnings surppressed.");
            break;
        }
        return remainder;
    }

    public void setMaximumNumberOfErrorMessages(int n) {
        maxMessages = n;
    }

    @Override
    public void initialize(double stepSize) {
        this.fixedStepSize = stepSize;
        super.initialize(stepSize / 2.0);
    }

    @Override
    public void setStepSize(double stepSize) {
        maxMessages = 4;
        this.fixedStepSize = stepSize;
        if (stepSize < 0.0) {
            super.setStepSize(Math.max(-Math.abs(super.getStepSize()), stepSize));
        } else {
            super.setStepSize(Math.min(super.getStepSize(), stepSize));
        }
        super.setStepSize(stepSize);
    }

    @Override
    public double getStepSize() {
        return this.fixedStepSize;
    }

    @Override
    public int getErrorCode() {
        return this.error_code;
    }
}

