/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.EigenvalueDecomposition;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.NumericMethodException;
import org.opensourcephysics.numerics.NumericsLog;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.numerics.VectorFunction;

public class Root {
    static final int MAX_ITERATIONS = 15;

    private Root() {
    }

    public static double[] quadraticReal(double a, double b, double c) {
        double[] roots = new double[2];
        double q = -0.5 * (b + (b < 0.0 ? -1.0 : 1.0) * Math.sqrt(b * b - 4.0 * a * c));
        roots[0] = q / a;
        roots[1] = c / q;
        return roots;
    }

    public static double[][] quadratic(double a, double b, double c) {
        double[][] roots = new double[2][2];
        double disc = b * b - 4.0 * a * c;
        if (disc < 0.0) {
            double d = -b / 2.0 / a;
            roots[0][0] = d;
            roots[1][0] = d;
            double[] dArray = roots[1];
            double d2 = Math.sqrt(-disc) / 2.0 / a;
            roots[0][1] = d2;
            dArray[1] = dArray[1] - d2;
            return roots;
        }
        double q = -0.5 * (b + (b < 0.0 ? -1.0 : 1.0) * Math.sqrt(disc));
        roots[0][0] = q / a;
        roots[1][0] = c / q;
        return roots;
    }

    public static double[][] cubic(double a, double b, double c, double d) {
        double[][] roots = new double[3][2];
        double B = c / a;
        double A = b / a;
        double A2 = A * A;
        double Q = (3.0 * B - A2) / 9.0;
        double C = d / a;
        double R = (9.0 * A * B - 27.0 * C - 2.0 * A * A2) / 54.0;
        double D = Q * Q * Q + R * R;
        if (D == 0.0) {
            double S = R < 0.0 ? -Math.pow(-R, 0.3333333333333333) : Math.pow(R, 0.3333333333333333);
            roots[0][0] = -A / 3.0 + 2.0 * S;
            double d2 = -A / 3.0 - S;
            roots[1][0] = d2;
            roots[2][0] = d2;
        } else if (D > 0.0) {
            double S = R + (D = Math.sqrt(D)) < 0.0 ? -Math.pow(-R - D, 0.3333333333333333) : Math.pow(R + D, 0.3333333333333333);
            double T = R - D < 0.0 ? -Math.pow(-R + D, 0.3333333333333333) : Math.pow(R - D, 0.3333333333333333);
            roots[0][0] = -A / 3.0 + S + T;
            double d3 = -A / 3.0 - (S + T) / 2.0;
            roots[1][0] = d3;
            roots[2][0] = d3;
            double[] dArray = roots[2];
            double d4 = Math.sqrt(3.0) * (S - T) / 2.0;
            roots[1][1] = d4;
            dArray[1] = dArray[1] - d4;
        } else {
            Q = -Q;
            double theta = Math.acos(R / Math.sqrt(Q * Q * Q)) / 3.0;
            Q = 2.0 * Math.sqrt(Q);
            roots[0][0] = Q * Math.cos(theta) - (A /= 3.0);
            roots[1][0] = Q * Math.cos(theta + 2.0943951023931953) - A;
            roots[2][0] = Q * Math.cos(theta + 4.1887902047863905) - A;
        }
        return roots;
    }

    public static double[][] polynomial(double[] c) {
        int highest;
        int n = c.length;
        int i = highest = n - 1;
        while (i > 0) {
            if (c[highest] != 0.0) break;
            highest = i--;
        }
        double ch = c[highest];
        double[][] companion = new double[highest][highest];
        companion[0][highest - 1] = -c[0] / ch;
        int i2 = 0;
        while (i2 < highest - 1) {
            companion[0][i2] = -c[highest - i2 - 1] / ch;
            companion[i2 + 1][i2] = 1.0;
            ++i2;
        }
        EigenvalueDecomposition eigen = new EigenvalueDecomposition(companion);
        double[][] roots = new double[][]{eigen.getRealEigenvalues(), eigen.getImagEigenvalues()};
        return roots;
    }

    public static double newton(Function f, double x, double tol) {
        int count = 0;
        while (count < 15) {
            double xold = x;
            double df = 0.0;
            try {
                df = Root.fxprime(f, x, tol);
            }
            catch (NumericMethodException ex) {
                return Double.NaN;
            }
            x -= f.evaluate(x) / df;
            if (Util.relativePrecision(Math.abs(x - xold), x) < tol) {
                return x;
            }
            ++count;
        }
        NumericsLog.fine(String.valueOf(count) + " newton root trials made - no convergence achieved");
        return Double.NaN;
    }

    public static double newton(Function f, Function df, double x, double tol) {
        int count = 0;
        while (count < 15) {
            double xold = x;
            if (Util.relativePrecision(Math.abs((x -= f.evaluate(x) / df.evaluate(x)) - xold), x) < tol) {
                return x;
            }
            ++count;
        }
        NumericsLog.fine(String.valueOf(count) + " newton root trials made - no convergence achieved");
        return Double.NaN;
    }

    /*
     * Unable to fully structure code
     */
    public static double bisection(Function f, double x1, double x2, double tol) {
        count = 0;
        maxCount = (int)(Math.log(Math.abs(x2 - x1) / tol) / Math.log(2.0));
        maxCount = Math.max(15, maxCount) + 2;
        y1 = f.evaluate(x1);
        if (!(y1 * (y2 = f.evaluate(x2)) > 0.0)) ** GOTO lbl19
        NumericsLog.fine(String.valueOf(count) + " bisection root - interval endpoints must have opposite sign");
        return NaN;
lbl-1000:
        // 1 sources

        {
            x = (x1 + x2) / 2.0;
            y = f.evaluate(x);
            if (Util.relativePrecision(Math.abs(x1 - x2), x) < tol) {
                return x;
            }
            if (y * y1 > 0.0) {
                x1 = x;
                y1 = y;
            } else {
                x2 = x;
                y2 = y;
            }
            ++count;
lbl19:
            // 2 sources

            ** while (count < maxCount)
        }
lbl20:
        // 1 sources

        NumericsLog.fine(String.valueOf(count) + " bisection root trials made - no convergence achieved");
        return NaN;
    }

    public static double newtonBisection(Function f, double xleft, double xright, double tol, int icmax) {
        double fbest;
        double xbest;
        double fright;
        double rtest = 10.0 * tol;
        int icount = 0;
        int iflag = 0;
        double fleft = f.evaluate(xleft);
        if (fleft * (fright = f.evaluate(xright)) >= 0.0) {
            iflag = 1;
        }
        switch (iflag) {
            case 1: {
                System.out.println("Root: No solution possible");
            }
        }
        if (Math.abs(fleft) <= Math.abs(fright)) {
            xbest = xleft;
            fbest = fleft;
        } else {
            xbest = xright;
            fbest = fright;
        }
        double derfbest = Root.fxprime(f, xbest, tol);
        while (icount < icmax && rtest > tol) {
            double delta;
            ++icount;
            if ((derfbest * (xbest - xleft) - fbest) * (derfbest * (xbest - xright) - fbest) <= 0.0) {
                delta = -fbest / derfbest;
                xbest += delta;
            } else {
                delta = (xright - xleft) / 2.0;
                xbest = (xleft + xright) / 2.0;
            }
            rtest = Math.abs(delta / xbest);
            if (rtest <= tol) continue;
            fbest = f.evaluate(xbest);
            derfbest = Root.fxprime(f, xbest, tol);
            if (fleft * fbest <= 0.0) {
                xright = xbest;
                fright = fbest;
                continue;
            }
            xleft = xbest;
            fleft = fbest;
        }
        if (icount > icmax || rtest > tol) {
            NumericsLog.fine(String.valueOf(icmax) + " Newton and bisection trials made - no convergence achieved");
            return Double.NaN;
        }
        return xbest;
    }

    public static double newtonMultivar(VectorFunction feqs, double[] xx, int max, double tol) {
        int Ndim = xx.length;
        double[] xxn = new double[Ndim];
        double[] F = new double[Ndim];
        int Iterations = 0;
        double err = 9999.0;
        double relerr = 9999.0;
        while (err > tol * 1.0E-6 && relerr > tol * 1.0E-6 && Iterations < max) {
            ++Iterations;
            LUPDecomposition lu = new LUPDecomposition(Root.getJacobian(feqs, Ndim, xx, tol / 100.0));
            F = feqs.evaluate(xx, F);
            xxn = lu.solve(F);
            int i = 0;
            while (i < Ndim) {
                xxn[i] = xx[i] - xxn[i];
                ++i;
            }
            err = (xx[0] - xxn[0]) * (xx[0] - xxn[0]);
            relerr = xx[0] * xx[0];
            xx[0] = xxn[0];
            i = 1;
            while (i < Ndim) {
                err += (xx[i] - xxn[i]) * (xx[i] - xxn[i]);
                relerr += xx[i] * xx[i];
                xx[i] = xxn[i];
                ++i;
            }
            err = Math.sqrt(err);
            relerr = err / (relerr + tol);
        }
        return err;
    }

    public static double[][] getJacobian(VectorFunction feqs, int n, double[] xx, double tol) {
        int j;
        double[][] J = new double[n][n];
        double[][] xxp = new double[n][n];
        double[][] xxm = new double[n][n];
        double[][] fp = new double[n][n];
        double[][] fm = new double[n][n];
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                xxp[i][j] = xx[j];
                xxm[i][j] = xx[j];
                ++j;
            }
            xxp[i][i] = xxp[i][i] + tol;
            xxm[i][i] = xxm[i][i] - tol;
            ++i;
        }
        i = 0;
        while (i < n) {
            fp[i] = feqs.evaluate(xxp[i], fp[i]);
            fm[i] = feqs.evaluate(xxm[i], fm[i]);
            ++i;
        }
        i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                J[i][j] = (fp[j][i] - fm[j][i]) / tol / 2.0;
                ++j;
            }
            ++i;
        }
        return J;
    }

    static final double fxprime(Function f, double x, double tol) {
        double del = tol / 10.0;
        double der = (f.evaluate(x + del) - f.evaluate(x - del)) / del / 2.0;
        return der;
    }
}

