/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.opensourcephysics.numerics.MathExpParser;
import org.opensourcephysics.numerics.ParserException;

public final class SuryonoParser
extends MathExpParser {
    private Func f;
    private String function = "";
    private boolean valid = false;
    private int error;
    private boolean isBoolean = false;
    private boolean inRelation = false;
    private int position;
    private int start;
    private int num;
    private char ch;
    private static final int MAX_NUM = 200;
    private static final int NO_FUNCS = 26;
    private static final int NO_EXT_FUNCS = 4;
    private static final int STACK_SIZE = 50;
    private static final double DEGTORAD = Math.PI / 180;
    private static final double LOG10 = Math.log(10.0);
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int NO_FUNC_DEFINITION = 14;
    public static final int REF_NAME_EXPECTED = 15;
    private static final int OFFSET_MASK = 61440;
    private static final int FUNC_OFFSET = 4096;
    private static final int EXT_FUNC_OFFSET = 8192;
    private static final int VAR_OFFSET = 16384;
    private static final int REF_OFFSET = 32768;
    private static final int PI_CODE = 253;
    private static final int E_CODE = 254;
    private static final int NUMERIC = 255;
    private static final int JUMP_CODE = 1;
    private static final int LESS_THAN = 2;
    private static final int GREATER_THAN = 3;
    private static final int LESS_EQUAL = 4;
    private static final int GREATER_EQUAL = 5;
    private static final int NOT_EQUAL = 6;
    private static final int EQUAL = 7;
    private static final int IF_CODE = 8;
    private static final int ENDIF = 9;
    private static final int AND_CODE = 10;
    private static final int OR_CODE = 11;
    private static final int NOT_CODE = 12;
    private static final int ADD = 43;
    private static final int SUB = 45;
    private static final int MUL = 42;
    private static final int DIV = 47;
    private static final int NEGATE = 95;
    private static final int POWER = 94;
    private static final String[] funcname = new String[]{"sin", "cos", "tan", "ln", "log", "abs", "int", "frac", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ceil", "floor", "round", "exp", "sqr", "sqrt", "sign", "step", "random"};
    private static final String[] extfunc = new String[]{"min", "max", "mod", "atan2"};
    private boolean allowUnknown;
    private static String[] allFunctions;
    boolean appendVariables = false;
    public static final String NULL = "0";
    public static final String NULL_D = "0.0";

    public SuryonoParser(String f, String v) throws ParserException {
        this(1);
        this.defineVariable(1, v);
        this.define(f);
        this.parse();
        if (this.getErrorCode() != 0) {
            String msg = "Error in function string: " + f;
            msg = String.valueOf(msg) + '\n' + "Error: " + this.getErrorString();
            msg = String.valueOf(msg) + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(msg);
        }
    }

    public void setError(int err) {
        this.error = err;
    }

    public SuryonoParser(String f, String v1, String v2) throws ParserException {
        this(2);
        this.defineVariable(1, v1);
        this.defineVariable(2, v2);
        this.define(f);
        this.parse();
        if (this.getErrorCode() != 0) {
            String msg = "Error in function string: " + f;
            msg = String.valueOf(msg) + '\n' + "Error: " + this.getErrorString();
            msg = String.valueOf(msg) + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(msg);
        }
    }

    public SuryonoParser(String f, String[] v) throws ParserException {
        this(f, v, false);
    }

    public SuryonoParser(String funcStr, String[] vars, boolean allowUnkownIdentifiers) throws ParserException {
        this(vars.length);
        int i = 0;
        while (i < vars.length) {
            this.defineVariable(i + 1, vars[i]);
            ++i;
        }
        this.allowUnknown = allowUnkownIdentifiers;
        this.define(funcStr);
        this.parse();
        if (this.getErrorCode() != 0) {
            String msg = "Error in function string: " + funcStr;
            msg = String.valueOf(msg) + '\n' + "Error: " + this.getErrorString();
            msg = String.valueOf(msg) + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(msg);
        }
    }

    public SuryonoParser(int nVar) {
        this.f = new Func(nVar);
    }

    public void setToZero() {
        try {
            this.setFunction(NULL);
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public void useRadian() {
        this.f.radian = true;
    }

    public void useDegree() {
        this.f.radian = false;
    }

    private String removeEscapeCharacter(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        int n = str.length();
        while (i < n) {
            if (str.charAt(i) != '\\') {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public void defineVariable(int index, String name) {
        this.f.defineVariable(index, name);
    }

    public void setVariable(int index, double value) {
        this.f.setVariable(index, value);
    }

    public void setVariable(String name, double value) {
        this.f.setVariable(name, value);
    }

    public void define(String def) {
        this.function = def.equals(NULL) ? def : this.removeEscapeCharacter(def);
        this.valid = false;
    }

    public void parse(String function) throws ParserException {
        this.define(function);
        this.parse();
        if (this.getErrorCode() != 0) {
            String msg = "Error in function string: " + function;
            msg = String.valueOf(msg) + '\n' + "Error: " + this.getErrorString();
            msg = String.valueOf(msg) + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(msg);
        }
    }

    public String[] parseUnknown(String function) throws ParserException {
        this.f.var_name = new String[0];
        this.f.var_value = new double[0];
        this.f.var_count = 0;
        this.appendVariables = true;
        this.define(function);
        this.parse();
        if (this.getErrorCode() != 0) {
            String msg = "Error in function string: " + function;
            msg = String.valueOf(msg) + '\n' + "Error: " + this.getErrorString();
            msg = String.valueOf(msg) + '\n' + "Position: " + this.getErrorPosition();
            this.appendVariables = false;
            throw new ParserException(msg);
        }
        this.appendVariables = false;
        return this.f.var_name;
    }

    public String[] getVariableNames() {
        return this.f.var_name;
    }

    @Override
    public String[] getFunctionNames() {
        if (allFunctions != null) {
            return allFunctions;
        }
        int len = funcname.length;
        String[] names = new String[len + extfunc.length];
        System.arraycopy(funcname, 0, names, 0, len);
        System.arraycopy(extfunc, 0, names, len, extfunc.length);
        allFunctions = names;
        return names;
    }

    public void parse() {
        int index;
        if (this.valid) {
            return;
        }
        this.num = 0;
        this.error = 0;
        this.f.references.clear();
        this.f.refnames.clear();
        switch (this.function) {
            case "": {
                this.error = 4;
                this.valid = false;
                return;
            }
            case "0": 
            case "0.0": {
                this.addNum(0.0);
                this.valid = true;
                return;
            }
            case "1": 
            case "1.0": {
                this.addNum(1.0);
                this.valid = true;
                return;
            }
        }
        String allFunction = this.function;
        String orgFunction = this.function;
        while ((index = allFunction.lastIndexOf(";")) >= 0) {
            this.function = String.valueOf(allFunction.substring(++index)) + ')';
            allFunction = allFunction.substring(0, index);
            String refname = null;
            int separator = this.function.indexOf(":");
            if (separator == -1) {
                this.error = 14;
                this.position = 0;
                while (this.position < this.function.length()) {
                    if (this.function.charAt(this.position) != ' ') break;
                    ++this.position;
                }
                ++this.position;
            } else {
                refname = this.function.substring(0, separator);
                this.function = this.function.substring(separator + 1);
                if ((refname = refname.trim()).equals("")) {
                    this.error = 15;
                    this.position = 1;
                } else {
                    index += ++separator;
                    this.parseSubFunction();
                }
            }
            if (this.error != 0) {
                this.position += index;
                break;
            }
            this.f.references.put(refname, this.f.postfix_code);
            this.f.refnames.add(refname);
        }
        if (this.error == 0) {
            this.function = String.valueOf(allFunction) + ')';
            this.parseSubFunction();
        }
        this.function = orgFunction;
        this.valid = this.error == 0;
    }

    @Override
    public double evaluate(double x) {
        return this.evaluate(x, 0.0, 0.0, 1);
    }

    public double evaluate(double x, double y) {
        return this.evaluate(x, y, 0.0, 2);
    }

    public double evaluate(double x, double y, double z) {
        return this.evaluate(x, y, z, 3);
    }

    private double evaluate(double x, double y, double z, int n) {
        return this.checkEval() ? this.f.evaluate(x, y, z, n) : 0.0;
    }

    @Override
    public double evaluate(double[] v) {
        return this.checkEval() ? this.f.evaluate(v) : 0.0;
    }

    public double evaluate() {
        return this.checkEval() ? this.f.evaluate() : 0.0;
    }

    private boolean checkEval() {
        if (this.valid) {
            return true;
        }
        this.error = 3;
        return false;
    }

    public boolean evaluatedToNaN() {
        return this.f.isNaN;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorString() {
        return SuryonoParser.toErrorString(this.error);
    }

    public int getErrorPosition() {
        return this.position;
    }

    public static String toErrorString(int errorcode) {
        String s = "";
        switch (errorcode) {
            case 0: {
                s = "no error";
                break;
            }
            case 1: {
                s = "syntax error";
                break;
            }
            case 2: {
                s = "parenthesis expected";
                break;
            }
            case 3: {
                s = "uncompiled function";
                break;
            }
            case 4: {
                s = "expression expected";
                break;
            }
            case 5: {
                s = "unknown identifier";
                break;
            }
            case 6: {
                s = "operator expected";
                break;
            }
            case 7: {
                s = "parentheses not match";
                break;
            }
            case 8: {
                s = "internal code damaged";
                break;
            }
            case 9: {
                s = "execution stack overflow";
                break;
            }
            case 10: {
                s = "too many constants";
                break;
            }
            case 11: {
                s = "comma expected";
                break;
            }
            case 12: {
                s = "invalid operand type";
                break;
            }
            case 13: {
                s = "invalid operator";
                break;
            }
            case 14: {
                s = "bad reference definition (: expected)";
                break;
            }
            case 15: {
                s = "reference name expected";
            }
        }
        return s;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public void setFunction(String funcStr) throws ParserException {
        this.setFunction(funcStr, null);
    }

    @Override
    public void setFunction(String funcStr, String[] vars) throws ParserException {
        if (vars != null) {
            int n = vars.length;
            this.f.reset(n);
            int i = 0;
            while (i < n) {
                this.defineVariable(i + 1, vars[i]);
                ++i;
            }
        }
        this.function = funcStr;
        this.define(this.function);
        this.parse();
        if (this.error != 0) {
            String msg = "Error in function string: " + funcStr;
            msg = String.valueOf(msg) + '\n' + "Error: " + SuryonoParser.toErrorString(this.error);
            msg = String.valueOf(msg) + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(msg);
        }
    }

    private void skipSpaces() throws ParserException {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.ch = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParserException(7);
        }
    }

    private void getNextch() throws ParserException {
        try {
            this.ch = this.function.charAt(this.position++);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParserException(7);
        }
    }

    private void addCode(int code) {
        this.f.postfix_code[0] = this.f.postfix_code[0] + 1;
        this.f.postfix_code[this.f.postfix_code[0]] = code;
    }

    private static void addCode(int[] a, int code) {
        a[0] = a[0] + 1;
        a[a[0]] = code;
    }

    private static void addCodes(int[] a, int[] b) {
        int n = b[0];
        int pt = a[0];
        a[0] = a[0] + n;
        System.arraycopy(b, 1, a, pt + 1, n);
    }

    private void scanNumber() throws ParserException {
        double value;
        String numstr = "";
        if (this.num == 200) {
            throw new ParserException(10);
        }
        if (this.ch != '.') {
            do {
                numstr = String.valueOf(numstr) + this.ch;
                this.getNextch();
            } while (this.ch >= '0' && this.ch <= '9');
        } else {
            numstr = String.valueOf(numstr) + '0';
        }
        if (this.ch == '.') {
            do {
                numstr = String.valueOf(numstr) + this.ch;
                this.getNextch();
            } while (this.ch >= '0' && this.ch <= '9');
        }
        if (this.ch == 'e' || this.ch == 'E') {
            numstr = String.valueOf(numstr) + this.ch;
            this.getNextch();
            if (this.ch == '+' || this.ch == '-') {
                numstr = String.valueOf(numstr) + this.ch;
                this.getNextch();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                numstr = String.valueOf(numstr) + this.ch;
                this.getNextch();
            }
        }
        if (Double.isNaN(value = SuryonoParser.getNumber(numstr))) {
            this.position = this.start;
            throw new ParserException(1);
        }
        this.addNum(value);
    }

    private void addNum(double value) {
        this.f.number[this.num++] = value;
        this.addCode(255);
    }

    public static double getNumber(String name) {
        if (SuryonoParser.couldBeNumber(name)) {
            try {
                return Double.parseDouble(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public static boolean couldBeNumber(String n) {
        return n.length() > 0 && "+-.I0123456789".indexOf(n.charAt(0)) >= 0;
    }

    private void scanNonNumeric() throws ParserException {
        String stream = "";
        if (this.ch == '*' || this.ch == '/' || this.ch == '^' || this.ch == ')' || this.ch == ',' || this.ch == '<' || this.ch == '>' || this.ch == '=' || this.ch == '&' || this.ch == '|') {
            throw new ParserException(1);
        }
        do {
            stream = String.valueOf(stream) + this.ch;
            this.getNextch();
        } while (this.ch != ' ' && this.ch != '+' && this.ch != '-' && this.ch != '*' && this.ch != '/' && this.ch != '^' && this.ch != '(' && this.ch != ')' && this.ch != ',' && this.ch != '<' && this.ch != '>' && this.ch != '=' && this.ch != '&' && this.ch != '|');
        if (stream.equals("pi")) {
            this.addCode(253);
            return;
        }
        if (stream.equals("e")) {
            this.addCode(254);
            return;
        }
        if (stream.equals("if")) {
            this.skipSpaces();
            if (this.ch != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.ch != ',') {
                throw new ParserException(11);
            }
            this.addCode(8);
            int[] savecode = Arrays.copyOf(this.f.postfix_code, this.f.postfix_code.length);
            this.f.postfix_code[0] = 0;
            this.scanAndParse();
            if (this.ch != ',') {
                throw new ParserException(11);
            }
            this.addCode(1);
            SuryonoParser.addCode(savecode, this.f.postfix_code[0] + 2);
            SuryonoParser.addCodes(savecode, this.f.postfix_code);
            this.f.postfix_code[0] = 0;
            this.scanAndParse();
            if (this.ch != ')') {
                throw new ParserException(2);
            }
            SuryonoParser.addCode(savecode, this.f.postfix_code[0] + 1);
            SuryonoParser.addCodes(savecode, this.f.postfix_code);
            this.f.postfix_code = Arrays.copyOf(savecode, savecode.length);
            this.getNextch();
            return;
        }
        int i = 0;
        while (i < 26) {
            if (stream.equals(funcname[i])) {
                this.skipSpaces();
                if (this.ch != '(') {
                    throw new ParserException(2);
                }
                this.scanAndParse();
                if (this.ch != ')') {
                    throw new ParserException(2);
                }
                this.getNextch();
                this.addCode(i | 0x1000);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (stream.equals(extfunc[i])) {
                this.skipSpaces();
                if (this.ch != '(') {
                    throw new ParserException(2);
                }
                this.scanAndParse();
                if (this.ch != ',') {
                    throw new ParserException(11);
                }
                int[] savecode = Arrays.copyOf(this.f.postfix_code, this.f.postfix_code.length);
                this.f.postfix_code[0] = 0;
                this.scanAndParse();
                if (this.ch != ')') {
                    throw new ParserException(2);
                }
                this.getNextch();
                SuryonoParser.addCodes(savecode, this.f.postfix_code);
                this.f.postfix_code = Arrays.copyOf(savecode, savecode.length);
                this.addCode(i | 0x2000);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.f.var_count) {
            if (stream.equals(this.f.var_name[i])) {
                this.addCode(i | 0x4000);
                return;
            }
            ++i;
        }
        int index = this.f.refnames.indexOf(stream);
        if (index != -1) {
            this.addCode(index | 0x8000);
            return;
        }
        if ((this.allowUnknown || this.appendVariables) && this.append(stream)) {
            return;
        }
        this.position = this.start;
        throw new ParserException(5);
    }

    private boolean append(String stream) {
        String[] var_name2 = new String[this.f.var_count + 1];
        double[] var_value2 = new double[this.f.var_count + 1];
        System.arraycopy(this.f.var_name, 0, var_name2, 0, this.f.var_count);
        System.arraycopy(this.f.var_value, 0, var_value2, 0, this.f.var_count);
        var_name2[this.f.var_count] = stream;
        this.f.var_name = var_name2;
        this.f.var_value = var_value2;
        ++this.f.var_count;
        int i = 0;
        while (i < this.f.var_count) {
            if (stream.equals(this.f.var_name[i])) {
                this.addCode(i | 0x4000);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean getIdentifier() throws ParserException {
        boolean negate = false;
        this.getNextch();
        this.skipSpaces();
        if (this.ch == '!') {
            this.getNextch();
            this.skipSpaces();
            if (this.ch != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.ch != ')') {
                throw new ParserException(2);
            }
            if (!this.isBoolean) {
                throw new ParserException(12);
            }
            this.addCode(12);
            this.getNextch();
            return false;
        }
        this.isBoolean = false;
        while (this.ch == '+' || this.ch == '-') {
            if (this.ch == '-') {
                negate = !negate;
            }
            this.getNextch();
            this.skipSpaces();
        }
        this.start = this.position;
        if (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
            this.scanNumber();
        } else if (this.ch == '(') {
            this.scanAndParse();
            this.getNextch();
        } else {
            this.scanNonNumeric();
        }
        this.skipSpaces();
        return negate;
    }

    private void arithmeticLevel3() throws ParserException {
        if (this.isBoolean) {
            throw new ParserException(12);
        }
        boolean negate = this.getIdentifier();
        if (this.isBoolean) {
            throw new ParserException(12);
        }
        if (this.ch == '^') {
            this.arithmeticLevel3();
        }
        this.addCode(94);
        if (negate) {
            this.addCode(95);
        }
    }

    private void arithmeticLevel2() throws ParserException {
        if (this.isBoolean) {
            throw new ParserException(12);
        }
        do {
            char operator = this.ch;
            boolean negate = this.getIdentifier();
            if (this.isBoolean) {
                throw new ParserException(12);
            }
            if (this.ch == '^') {
                this.arithmeticLevel3();
            }
            if (negate) {
                this.addCode(95);
            }
            this.addCode(operator);
        } while (this.ch == '*' || this.ch == '/');
    }

    private void arithmeticLevel1() throws ParserException {
        if (this.isBoolean) {
            throw new ParserException(12);
        }
        do {
            char operator = this.ch;
            boolean negate = this.getIdentifier();
            if (this.isBoolean) {
                throw new ParserException(12);
            }
            switch (this.ch) {
                case '^': {
                    this.arithmeticLevel3();
                    if (!negate) break;
                    this.addCode(95);
                    break;
                }
                case '*': 
                case '/': {
                    if (negate) {
                        this.addCode(95);
                    }
                    this.arithmeticLevel2();
                }
            }
            this.addCode(operator);
        } while (this.ch == '+' || this.ch == '-');
    }

    private void relationLevel() throws ParserException {
        int code = 0;
        if (this.inRelation) {
            throw new ParserException(13);
        }
        this.inRelation = true;
        if (this.isBoolean) {
            throw new ParserException(12);
        }
        switch (this.ch) {
            case '=': {
                code = 7;
                break;
            }
            case '<': {
                code = 2;
                this.getNextch();
                if (this.ch == '>') {
                    code = 6;
                    break;
                }
                if (this.ch == '=') {
                    code = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                code = 3;
                this.getNextch();
                if (this.ch == '=') {
                    code = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scanAndParse();
        this.inRelation = false;
        if (this.isBoolean) {
            throw new ParserException(12);
        }
        this.addCode(code);
        this.isBoolean = true;
    }

    private void booleanLevel() throws ParserException {
        if (!this.isBoolean) {
            throw new ParserException(12);
        }
        char c = this.ch;
        this.scanAndParse();
        if (!this.isBoolean) {
            throw new ParserException(12);
        }
        switch (c) {
            case '&': {
                this.addCode(10);
                break;
            }
            case '|': {
                this.addCode(11);
            }
        }
    }

    private void scanAndParse() throws ParserException {
        boolean negate = this.getIdentifier();
        if (this.ch != '^' && negate) {
            this.addCode(95);
        }
        block8: while (true) {
            switch (this.ch) {
                case '+': 
                case '-': {
                    this.arithmeticLevel1();
                    continue block8;
                }
                case '*': 
                case '/': {
                    this.arithmeticLevel2();
                    continue block8;
                }
                case '^': {
                    this.arithmeticLevel3();
                    if (!negate) continue block8;
                    this.addCode(95);
                    continue block8;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '<': 
                case '=': 
                case '>': {
                    this.relationLevel();
                    continue block8;
                }
                case '&': 
                case '|': {
                    this.booleanLevel();
                    continue block8;
                }
            }
            break;
        }
        throw new ParserException(6);
    }

    private void parseSubFunction() {
        block3: {
            this.position = 0;
            this.f.postfix_code[0] = 0;
            this.inRelation = false;
            this.isBoolean = false;
            try {
                this.scanAndParse();
            }
            catch (ParserException e) {
                this.error = e.getErrorCode();
                if (this.error != 1 || this.f.postfix_code[0] != 0) break block3;
                this.error = 4;
            }
        }
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
    }

    public String toString() {
        return this.function;
    }

    private class Func {
        protected int var_count = -1;
        protected String[] var_name;
        protected double[] var_value;
        protected double[] number = new double[200];
        protected Map<String, int[]> references = new Hashtable<String, int[]>();
        protected List<String> refnames = new ArrayList<String>();
        protected int[] postfix_code = new int[100];
        protected boolean radian = true;
        protected int err = 0;
        protected boolean isNaN;
        private double[] refvalue = null;
        private double[] stack = new double[50];
        private int numberindex;

        public String toString() {
            if (this.var_count < 0) {
                return super.toString();
            }
            String s = SuryonoParser.this.function + ":\n";
            int i = 0;
            while (i < this.var_count) {
                s = String.valueOf(s) + this.var_name[i] + "=" + this.var_value[i] + ";";
                ++i;
            }
            return s;
        }

        protected Func(int nVar) {
            this.reset(nVar);
        }

        protected void reset(int nVar) {
            if (nVar != this.var_count) {
                this.var_count = nVar;
                this.var_name = new String[nVar];
                this.var_value = new double[nVar];
                this.references.clear();
                this.refnames.clear();
            }
        }

        public void defineVariable(int index, String name) {
            if (index > this.var_count) {
                return;
            }
            this.var_name[index - 1] = name;
        }

        public void setVariable(int index, double value) {
            if (index > this.var_count) {
                return;
            }
            this.var_value[index - 1] = value;
        }

        public void setVariable(String name, double value) {
            int i = 0;
            while (i < this.var_count) {
                if (this.var_name[i].equals(name)) {
                    this.var_value[i] = value;
                    break;
                }
                ++i;
            }
        }

        protected double evaluate(double x, double y, double z, int n) {
            if (this.var_count != n) {
                return 0.0;
            }
            switch (n) {
                case 3: {
                    this.var_value[2] = z;
                }
                case 2: {
                    this.var_value[1] = y;
                }
                case 1: {
                    this.var_value[0] = x;
                }
            }
            return this.evaluate();
        }

        protected double evaluate(double[] v) {
            if (this.var_value.length != v.length) {
                System.out.println("SuryonoParser.Func Error: incorrect number of variables.");
                return 0.0;
            }
            System.arraycopy(v, 0, this.var_value, 0, v.length);
            return this.evaluate();
        }

        protected double evaluate() {
            double result = 0.0;
            this.err = 0;
            this.numberindex = 0;
            int size = this.refnames.size();
            if (size == 0) {
                if (this.refvalue == null || this.refvalue.length < size) {
                    this.refvalue = new double[size];
                }
                int i = 0;
                while (i < size) {
                    this.refvalue[i] = this.evaluateSubFunction(this.references.get(this.refnames.get(i)), this.stack);
                    result = this.refvalue[i];
                    if (Double.isNaN(result)) break;
                    ++i;
                }
            }
            if (!Double.isNaN(result)) {
                result = this.evaluateSubFunction(this.postfix_code, this.stack);
            }
            this.isNaN = Double.isNaN(result);
            if (this.isNaN) {
                result = 0.0;
            }
            SuryonoParser.this.setError(this.err);
            return result;
        }

        /*
         * Exception decompiling
         */
        private double evaluateSubFunction(int[] codes, double[] stack) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [34[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private double builtInFunction(int index, double p) {
            switch (index) {
                case 0: {
                    return Math.sin(this.radian ? p : p * (Math.PI / 180));
                }
                case 1: {
                    return Math.cos(this.radian ? p : p * (Math.PI / 180));
                }
                case 2: {
                    return Math.tan(this.radian ? p : p * (Math.PI / 180));
                }
                case 3: {
                    return Math.log(p);
                }
                case 4: {
                    return Math.log(p) / LOG10;
                }
                case 5: {
                    return Math.abs(p);
                }
                case 6: {
                    return Math.rint(p);
                }
                case 7: {
                    return p - Math.rint(p);
                }
                case 8: {
                    return Math.asin(p) / (this.radian ? 1.0 : Math.PI / 180);
                }
                case 9: {
                    return Math.acos(p) / (this.radian ? 1.0 : Math.PI / 180);
                }
                case 10: {
                    return Math.atan(p) / (this.radian ? 1.0 : Math.PI / 180);
                }
                case 11: {
                    return Math.sinh(p);
                }
                case 12: {
                    return Math.cosh(p);
                }
                case 13: {
                    return Math.tanh(p);
                }
                case 14: {
                    return Math.log(p + Math.sqrt(p * p + 1.0));
                }
                case 15: {
                    return Math.log(p + Math.sqrt(p * p - 1.0));
                }
                case 16: {
                    return Math.log((1.0 + p) / (1.0 - p)) / 2.0;
                }
                case 17: {
                    return Math.ceil(p);
                }
                case 18: {
                    return Math.floor(p);
                }
                case 19: {
                    return Math.round(p);
                }
                case 20: {
                    return Math.exp(p);
                }
                case 21: {
                    return p * p;
                }
                case 22: {
                    return Math.sqrt(p);
                }
                case 23: {
                    return Math.signum(p);
                }
                case 24: {
                    return !(p < 0.0) ? 1 : 0;
                }
                case 25: {
                    return p * Math.random();
                }
            }
            this.err = 8;
            return Double.NaN;
        }

        private double builtInExtFunction(int index, double p1, double p2) {
            switch (index) {
                case 0: {
                    return Math.min(p1, p2);
                }
                case 1: {
                    return Math.max(p1, p2);
                }
                case 2: {
                    return Math.IEEEremainder(p1, p2);
                }
                case 3: {
                    return Math.atan2(p1, p2);
                }
            }
            this.err = 8;
            return Double.NaN;
        }
    }
}

