/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;

class TriggerODE
implements ODE {
    protected ODE ode;
    private int size;
    private double[] odestate;
    private double[] state;

    public TriggerODE(ODE _ode) {
        this.ode = _ode;
        this.odestate = this.ode.getState();
        this.size = this.odestate.length;
        this.state = new double[this.size];
        System.arraycopy(this.odestate, 0, this.state, 0, this.size);
    }

    public void setState(double[] newstate) {
        System.arraycopy(newstate, 0, this.state, 0, this.size);
    }

    public void readRealState() {
        this.odestate = this.ode.getState();
        System.arraycopy(this.odestate, 0, this.state, 0, this.size);
    }

    public void updateRealState() {
        System.arraycopy(this.state, 0, this.odestate, 0, this.size);
    }

    @Override
    public double[] getState() {
        return this.state;
    }

    @Override
    public void getRate(double[] _state, double[] _rate) {
        this.ode.getRate(_state, _rate);
    }
}

