/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Util;

public class Vec3D {
    public double x;
    public double y;
    public double z;

    public Vec3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3D(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    public Vec3D(Vec3D v1) {
        this.x = v1.x;
        this.y = v1.y;
        this.z = v1.z;
    }

    public Vec3D() {
        this(0.0, 0.0, 0.0);
    }

    public final void subtract(Vec3D v1, Vec3D v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
    }

    public final void add(Vec3D v1, Vec3D v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
    }

    public void cross(Vec3D v1, Vec3D v2) {
        double x = v1.y * v2.z - v1.z * v2.y;
        double y = v2.x * v1.z - v2.z * v1.x;
        this.z = v1.x * v2.y - v1.y * v2.x;
        this.x = x;
        this.y = y;
    }

    public void multiply(Vec3D v1, double number) {
        this.x = v1.x * number;
        this.y = v1.y * number;
        this.z = v1.z * number;
    }

    public final void normalize() {
        double norm = this.x * this.x + this.y * this.y + this.z * this.z;
        if (norm < Util.defaultNumericalPrecision) {
            return;
        }
        if (norm == 1.0) {
            return;
        }
        norm = 1.0 / Math.sqrt(norm);
        this.x *= norm;
        this.y *= norm;
        this.z *= norm;
    }

    public final double dot(Vec3D v1) {
        return this.x * v1.x + this.y * v1.y + this.z * v1.z;
    }

    public final double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double angle(Vec3D v1) {
        double vDot = this.dot(v1) / (this.magnitude() * v1.magnitude());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }
}

