/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public final class VectorMath {
    private VectorMath() {
    }

    public static double[] plus(double[] a, double[] b, double c) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal length to add.");
        }
        int i = 0;
        while (i < aLength) {
            int n = i;
            a[n] = a[n] + c * b[i];
            ++i;
        }
        return a;
    }

    public static double[] plus(double[] a, double[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal length to add.");
        }
        int i = 0;
        while (i < aLength) {
            int n = i;
            a[n] = a[n] + b[i];
            ++i;
        }
        return a;
    }

    public static double[] normalize(double[] a) {
        double mag = VectorMath.magnitude(a);
        if (mag == 0.0) {
            a[0] = 1.0;
            return a;
        }
        a[0] = a[0] / mag;
        a[1] = a[1] / mag;
        a[2] = a[2] / mag;
        return a;
    }

    public static double dot(double[] a, double[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension in dot product.");
        }
        double sum = 0.0;
        int i = 0;
        while (i < aLength) {
            sum += a[i] * b[i];
            ++i;
        }
        return sum;
    }

    public static double[] project(double[] a, double[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension to compute projection.");
        }
        double[] result = (double[])b.clone();
        double asquared = 0.0;
        double dot = 0.0;
        int i = 0;
        while (i < aLength) {
            dot += a[i] * b[i];
            asquared += a[i] * a[i];
            ++i;
        }
        dot /= asquared;
        i = 0;
        while (i < aLength) {
            int n = i++;
            result[n] = result[n] / dot;
        }
        return result;
    }

    public static double[] perp(double[] a, double[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension to find the perpendicular component.");
        }
        double[] result = (double[])b.clone();
        double asquared = 0.0;
        double dot = 0.0;
        int i = 0;
        while (i < aLength) {
            dot += a[i] * b[i];
            asquared += a[i] * a[i];
            ++i;
        }
        dot /= asquared;
        i = 0;
        while (i < aLength) {
            result[i] = a[i] - b[i] / dot;
            ++i;
        }
        return result;
    }

    public static double magnitudeSquared(double[] a) {
        int aLength = a.length;
        double sum = 0.0;
        int i = 0;
        while (i < aLength) {
            sum += a[i] * a[i];
            ++i;
        }
        return sum;
    }

    public static double magnitude(double[] a) {
        double sum = 0.0;
        int i = 0;
        int n = a.length;
        while (i < n) {
            sum += a[i] * a[i];
            ++i;
        }
        return Math.sqrt(sum);
    }

    public static final double[] cross3D(double[] v1, double[] v2) {
        double[] v = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v2[0] * v1[2] - v2[2] * v1[0], v1[0] * v2[1] - v1[1] * v2[0]};
        return v;
    }

    public static double[] cross2D(double[] v, double b) {
        if (v.length != 2) {
            throw new UnsupportedOperationException("ERROR: Cross2D product requires 2 component array.");
        }
        double temp = v[0];
        v[0] = v[1] * b;
        v[1] = -temp * b;
        return v;
    }

    public static double cross2D(double[] a, double[] b) {
        if (a.length != 2 || b.length != 2) {
            throw new UnsupportedOperationException("ERROR: Cross2D product requires 2 component arrays.");
        }
        return a[0] * b[1] - a[1] * b[0];
    }
}

