/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Function;

public class Airy {
    static Function airyFunction = null;
    static Function airyDerivative = null;
    static final double airyZeroTolerance = 1.0E-9;
    static final Map<Integer, Double> zeroMap = new HashMap<Integer, Double>();

    static {
        zeroMap.put(1, -2.338107410459767);
        zeroMap.put(2, -4.087949444130971);
        zeroMap.put(3, -5.520559828095551);
        zeroMap.put(4, -6.786708090071759);
        zeroMap.put(5, -7.944133587120853);
        zeroMap.put(6, -9.02265085334098);
        zeroMap.put(7, -10.04017434155809);
        zeroMap.put(8, -11.00852430373326);
        zeroMap.put(9, -11.93601556323626);
        zeroMap.put(10, -12.82877675286576);
        zeroMap.put(11, -13.69148903521072);
        zeroMap.put(12, -14.52782995177533);
        zeroMap.put(13, -15.340755135978);
        zeroMap.put(14, -16.13268515694577);
        zeroMap.put(15, -16.90563399742994);
        zeroMap.put(16, -17.66130010569706);
    }

    public static double airy(double x) {
        double ai;
        double[] xtmp = new double[26];
        xtmp[1] = 14.083081072180963;
        xtmp[2] = 10.214885479197331;
        xtmp[3] = 7.441601845045093;
        xtmp[4] = 5.307094306178192;
        xtmp[5] = 3.634013502913246;
        xtmp[6] = 2.331065230305245;
        xtmp[7] = 1.3447970842609267;
        xtmp[8] = 0.6418885836956729;
        xtmp[9] = 0.20100345998121047;
        xtmp[10] = 0.008059435917205284;
        xtmp[11] = 3.1542515762964784E-14;
        xtmp[12] = 6.639421081958493E-11;
        xtmp[13] = 1.7583889061345668E-8;
        xtmp[14] = 1.3712392370435816E-6;
        xtmp[15] = 4.435096663928435E-5;
        xtmp[16] = 7.155501091771825E-4;
        xtmp[17] = 0.006488956610333538;
        xtmp[18] = 0.036440415875773284;
        xtmp[19] = 0.14399792418590998;
        xtmp[20] = 0.8123114133626148;
        xtmp[21] = 0.355028053887817;
        xtmp[22] = 0.258819403792807;
        xtmp[23] = 1.7320508075688772;
        xtmp[24] = 0.7853981633974483;
        xtmp[25] = 0.5641895835477563;
        if (x >= -5.0 && x <= 8.0) {
            double vc = 1.0;
            double uc = 1.0;
            double t = 1.0;
            double v = 1.0;
            double u = 1.0;
            double s = 0.5;
            int n = 3;
            double zzz = x * x * x;
            while (Math.abs(u) + Math.abs(v) + Math.abs(s) + Math.abs(t) > 1.0E-18) {
                u = u * zzz / (double)(n * (n - 1));
                v = v * zzz / (double)(n * (n + 1));
                s = s * zzz / (double)(n * (n + 2));
                t = t * zzz / (double)(n * (n - 2));
                uc += u;
                vc += v;
                n += 3;
            }
            if (x < 2.5) {
                double ai2 = xtmp[21] * uc - xtmp[22] * x * vc;
                return ai2;
            }
        }
        double k2 = 0.0;
        double k1 = 0.0;
        double sqrtx = Math.sqrt(Math.abs(x));
        double xt = 0.666666666666667 * Math.abs(x) * sqrtx;
        double c = xtmp[25] / Math.sqrt(sqrtx);
        if (x < 0.0) {
            x = -x;
            double co = Math.cos(xt - xtmp[24]);
            double si = Math.sin(xt - xtmp[24]);
            int l = 1;
            while (l <= 10) {
                double wwl = xtmp[l + 10];
                double pl = xtmp[l] / xt;
                double pl2 = pl * pl;
                double pl1 = 1.0 + pl2;
                k1 += wwl / pl1;
                k2 += wwl * pl / pl1;
                ++l;
            }
            ai = c * (co * k1 + si * k2);
        } else {
            double expxt = x < 9.0 ? Math.exp(xt) : 1.0;
            int l = 1;
            while (l <= 10) {
                double wwl = xtmp[l + 10];
                double pl = xtmp[l] / xt;
                double pl1 = 1.0 + pl;
                double pl2 = 1.0 - pl;
                k1 += wwl / pl1;
                k2 += wwl * pl / (xt * pl1 * pl1);
                ++l;
            }
            ai = 0.5 * c * k1 / expxt;
            if (x >= 9.0) {
                expxt = Math.pow(x, 1.5);
                ai = 0.5 * Math.exp(-2.0 * expxt / 3.0) / Math.sqrt(Math.PI) / Math.pow(x, 0.25);
            }
        }
        return ai;
    }

    public static double airyDerivative(double x) {
        double aid;
        double[] xtmp = new double[26];
        xtmp[1] = 14.083081072180963;
        xtmp[2] = 10.214885479197331;
        xtmp[3] = 7.441601845045093;
        xtmp[4] = 5.307094306178192;
        xtmp[5] = 3.634013502913246;
        xtmp[6] = 2.331065230305245;
        xtmp[7] = 1.3447970842609267;
        xtmp[8] = 0.6418885836956729;
        xtmp[9] = 0.20100345998121047;
        xtmp[10] = 0.008059435917205284;
        xtmp[11] = 3.1542515762964784E-14;
        xtmp[12] = 6.639421081958493E-11;
        xtmp[13] = 1.7583889061345668E-8;
        xtmp[14] = 1.3712392370435816E-6;
        xtmp[15] = 4.435096663928435E-5;
        xtmp[16] = 7.155501091771825E-4;
        xtmp[17] = 0.006488956610333538;
        xtmp[18] = 0.036440415875773284;
        xtmp[19] = 0.14399792418590998;
        xtmp[20] = 0.8123114133626148;
        xtmp[21] = 0.355028053887817;
        xtmp[22] = 0.258819403792807;
        xtmp[23] = 1.7320508075688772;
        xtmp[24] = 0.7853981633974483;
        xtmp[25] = 0.5641895835477563;
        if (x >= -5.0 && x <= 8.0) {
            double tc = 1.0;
            double vc = 1.0;
            double uc = 1.0;
            double t = 1.0;
            double v = 1.0;
            double u = 1.0;
            double sc = 0.5;
            double s = 0.5;
            int n = 3;
            double zzz = x * x * x;
            while (Math.abs(u) + Math.abs(v) + Math.abs(s) + Math.abs(t) > 1.0E-18) {
                u = u * zzz / (double)(n * (n - 1));
                v = v * zzz / (double)(n * (n + 1));
                s = s * zzz / (double)(n * (n + 2));
                t = t * zzz / (double)(n * (n - 2));
                uc += u;
                vc += v;
                sc += s;
                tc += t;
                n += 3;
            }
            if (x < 2.5) {
                double ai = xtmp[21] * uc - xtmp[22] * x * vc;
                double aid2 = xtmp[21] * sc * x * x - xtmp[22] * tc;
                return aid2;
            }
        }
        double k4 = 0.0;
        double k3 = 0.0;
        double k2 = 0.0;
        double k1 = 0.0;
        double sqrtx = Math.sqrt(Math.abs(x));
        double xt = 0.666666666666667 * Math.abs(x) * sqrtx;
        double c = xtmp[25] / Math.sqrt(sqrtx);
        if (x < 0.0) {
            x = -x;
            double co = Math.cos(xt - xtmp[24]);
            double si = Math.sin(xt - xtmp[24]);
            int l = 1;
            while (l <= 10) {
                double wwl = xtmp[l + 10];
                double pl = xtmp[l] / xt;
                double pl2 = pl * pl;
                double pl1 = 1.0 + pl2;
                double pl3 = pl1 * pl1;
                k1 += wwl / pl1;
                k2 += wwl * pl / pl1;
                k3 += wwl * pl * (1.0 + pl * (2.0 / xt + pl)) / pl3;
                k4 += wwl * (-1.0 - pl * (1.0 + pl * (xt - pl)) / xt) / pl3;
                ++l;
            }
            double ai = c * (co * k1 + si * k2);
            aid = 0.25 * ai / x - c * sqrtx * (co * k3 + si * k4);
        } else {
            double expxt = x < 9.0 ? Math.exp(xt) : 1.0;
            int l = 1;
            while (l <= 10) {
                double wwl = xtmp[l + 10];
                double pl = xtmp[l] / xt;
                double pl1 = 1.0 + pl;
                double pl2 = 1.0 - pl;
                k1 += wwl / pl1;
                k2 += wwl * pl / (xt * pl1 * pl1);
                k3 += wwl / pl2;
                k4 += wwl * pl / (xt * pl2 * pl2);
                ++l;
            }
            double ai = 0.5 * c * k1 / expxt;
            aid = ai * (-0.25 / x - sqrtx) + 0.5 * c * sqrtx * k2 / expxt;
            if (x >= 9.0) {
                expxt = Math.pow(x, 1.5);
                ai = 0.5 * Math.exp(-2.0 * expxt / 3.0) / Math.sqrt(Math.PI) / Math.pow(x, 0.25);
                aid = -ai * Math.pow(x, 0.5) - ai / x / 4.0;
            }
        }
        return aid;
    }

    public static double airyZero(int n) {
        if (zeroMap.containsKey(n)) {
            return zeroMap.get(n);
        }
        double x = -Math.pow(Math.PI * ((double)n - 0.25) * 3.0 / 2.0, 0.6666666666666666);
        int maxIterations = 10;
        while (maxIterations > 0) {
            double dax;
            double ax;
            double x0 = x;
            if (!(Math.abs((x -= (ax = Airy.airy(x)) / (dax = Airy.airyDerivative(x))) - x0) > 1.0E-9)) break;
            --maxIterations;
        }
        if (maxIterations == 0) {
            x = -Math.pow(Math.PI * ((double)n - 0.25) * 3.0 / 2.0, 0.6666666666666666);
        }
        zeroMap.put(n, x);
        return x;
    }

    public static double[] airynZeros(int nt) {
        double[] zeros = new double[nt];
        int i = 0;
        while (i < nt) {
            zeros[i] = Airy.airyZero(i + 1);
            ++i;
        }
        return zeros;
    }

    public static synchronized Function getFunction() {
        if (airyFunction == null) {
            airyFunction = new AiryFunction();
        }
        return airyFunction;
    }

    public static synchronized Function getDerivative() {
        if (airyDerivative == null) {
            airyDerivative = new AiryDerivative();
        }
        return airyDerivative;
    }

    static class AiryDerivative
    implements Function {
        AiryDerivative() {
        }

        @Override
        public double evaluate(double x) {
            return Airy.airyDerivative(x);
        }
    }

    static class AiryFunction
    implements Function {
        AiryFunction() {
        }

        @Override
        public double evaluate(double x) {
            return Airy.airy(x);
        }
    }
}

