/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.specialfunctions.Messages;

public class Bessel {
    static final Map<Integer, Function> functionMap = new HashMap<Integer, Function>();
    static final Map<Integer, Function> derivativeMap = new HashMap<Integer, Function>();

    public static synchronized Function getFunction(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Bessel.0.neg_order"));
        }
        Function f = functionMap.get(n);
        if (f != null) {
            return f;
        }
        f = new BesselFunction(n);
        functionMap.put(n, f);
        return f;
    }

    public static synchronized Function getDerivative(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Bessel.1.neg_order"));
        }
        Function f = derivativeMap.get(n);
        if (f != null) {
            return f;
        }
        f = new BesselDerivative(n);
        derivativeMap.put(n, f);
        return f;
    }

    public static double besseln(int n, double x) {
        double pk;
        int sg = n < 0 ? ((n = -n) % 2 == 0 ? 1 : -1) : 1;
        if (x < 0.0) {
            if (n % 2 != 0) {
                sg = -sg;
            }
            x = -x;
        }
        if (n == 0) {
            double y = (double)sg * Bessel.bessel0(x);
            return y;
        }
        if (n == 1) {
            double y = (double)sg * Bessel.bessel1(x);
            return y;
        }
        if (n == 2) {
            double y = x == 0.0 ? 0.0 : (double)sg * (2.0 * Bessel.bessel1(x) / x - Bessel.bessel0(x));
            return y;
        }
        if (x < 1.0E-12) {
            double y = 0.0;
            return y;
        }
        int k = 53;
        double tmp = pk = (double)(2 * (n + k));
        double xk = x * x;
        while (k != 0) {
            tmp = (pk -= 2.0) - xk / tmp;
            --k;
        }
        tmp = x / tmp;
        pk = 1.0;
        double pkm1 = 1.0 / tmp;
        k = n - 1;
        double r = 2 * k;
        while (k != 0) {
            double pkm2 = (pkm1 * r - pk * x) / x;
            pk = pkm1;
            pkm1 = pkm2;
            r -= 2.0;
            --k;
        }
        tmp = Math.abs(pk) > Math.abs(pkm1) ? Bessel.bessel1(x) / pk : Bessel.bessel0(x) / pkm1;
        return (double)sg * tmp;
    }

    public static double besselnDerivative(int n, double x) {
        int m = n;
        if (n == 0) {
            double bjn = Bessel.besseln(1, x);
            return -bjn;
        }
        int qm = 1;
        int qp = 1;
        int nm = m - 1;
        int np = m + 1;
        if (m < 0) {
            if (nm < 0) {
                nm = -nm;
                qm = -1;
            }
            if (np < 0) {
                np = -np;
                qp = -1;
            }
        }
        double bjnm = Bessel.besseln(nm, x);
        double bjnp = Bessel.besseln(np, x);
        bjnm = Math.pow(qm, nm) * bjnm;
        bjnp = Math.pow(qp, np) * bjnp;
        return (bjnm - bjnp) / 2.0;
    }

    public static double[] besselnZeros(int n, int nt) {
        double[] rj0 = new double[nt];
        if (n < 0) {
            n = -n;
        }
        double x = n <= 20 ? 2.82141 + 1.15859 * (double)n : (double)n + 1.85576 * Math.pow(n, 0.33333) + 1.03315 / Math.pow(n, 0.33333);
        int l = 0;
        while (true) {
            double djn;
            double bjn;
            double x0 = x;
            if (Math.abs((x -= (bjn = Bessel.besseln(n, x)) / (djn = Bessel.besselnDerivative(n, x))) - x0) > 1.0E-6) continue;
            rj0[l] = x;
            x = x + Math.PI + (0.0972 + 0.0679 * (double)n - 3.54E-4 * Math.pow(n, 2.0)) / (double)(++l);
            if (l >= nt) break;
        }
        return rj0;
    }

    public static double bessel0(double x) {
        double[] zz = new double[2];
        double[] p = new double[]{26857.86856980015, -4.050412371833133E7, 2.507158285536882E10, -8.085222034853794E12, 1.434354939140344E15, -1.3676203530881714E17, 6.382059341072356E18, -1.1791576291076106E20, 4.9337872517941336E20};
        double[] q = new double[]{1.0, 1363.0636523289706, 1114636.0984629854, 6.69998767298224E8, 3.1230431149412134E11, 1.1277567396797984E14, 3.0246356167094628E16, 5.428918384092285E18, 4.9337872517941336E20};
        if (x < 0.0) {
            x = -x;
        }
        if (x > 8.0) {
            zz = Bessel.besselasympt0(x);
            double pzero = zz[0];
            double qzero = zz[1];
            double nn = x - 0.7853981633974483;
            double y = Math.sqrt(0.6366197723675814 / x) * (pzero * Math.cos(nn) - qzero * Math.sin(nn));
            return y;
        }
        double xsq = x * x;
        double p1 = p[0];
        int i = 1;
        while (i < 9) {
            p1 = p[i] + p1 * xsq;
            ++i;
        }
        double q1 = q[0];
        i = 1;
        while (i < 9) {
            q1 = q[i] + q1 * xsq;
            ++i;
        }
        return p1 / q1;
    }

    public static double bessel1(double x) {
        double[] zz = new double[2];
        double[] p = new double[]{2701.1227108923235, -4695753.530642996, 3.4132341823017006E9, -1.3229834803321265E12, 2.9087952638347756E14, -3.588817569910106E16, 2.3164335806340024E18, -6.672106568924916E19, 5.811993540016061E20};
        double[] q = new double[]{1.0, 1606.9315734814877, 1501793.5949985855, 1.013863514358674E9, 5.2437102621676495E11, 2.0816612213076075E14, 6.092061398917522E16, 1.185770712190321E19, 1.1623987080032122E21};
        double s = Math.signum(x);
        if (x < 0.0) {
            x = -x;
        }
        if (x > 8.0) {
            zz = Bessel.besselasympt1(x);
            double pzero = zz[0];
            double qzero = zz[1];
            double nn = x - 2.356194490192345;
            double y = Math.sqrt(0.6366197723675814 / x) * (pzero * Math.cos(nn) - qzero * Math.sin(nn));
            if (s < 0.0) {
                y = -y;
            }
            return y;
        }
        double xsq = x * x;
        double p1 = p[0];
        int i = 1;
        while (i < 9) {
            p1 = p[i] + p1 * xsq;
            ++i;
        }
        double q1 = q[0];
        i = 1;
        while (i < 9) {
            q1 = q[i] + q1 * xsq;
            ++i;
        }
        return s * x * p1 / q1;
    }

    private static double[] besselasympt0(double x) {
        double[] zz = new double[2];
        double[] p = new double[]{0.0, 2485.271928957404, 153982.65326239113, 2016135.2830499837, 8413041.45655044, 1.233238476817638E7, 5393485.083869439};
        double[] q = new double[]{1.0, 2615.7007369208395, 156001.7276940031, 2025066.801570134, 8426449.050629796, 1.233831022786325E7, 5393485.083869439};
        double[] pp = new double[]{0.0, -4.887199395841262, -226.2630641933704, -2365.956170779108, -8239.066313485606, -10381.416987484641, -3984.6173575952225};
        double[] qq = new double[]{1.0, 408.7714673983499, 15704.891915153956, 156021.32066792916, 533291.3634216897, 666745.4239319827, 255015.51088609424};
        double xsq = 64.0 / x / x;
        double p2 = p[0];
        int i = 1;
        while (i < 7) {
            p2 = p[i] + p2 * xsq;
            ++i;
        }
        double q2 = q[0];
        i = 1;
        while (i < 7) {
            q2 = q[i] + q2 * xsq;
            ++i;
        }
        double p3 = pp[0];
        i = 1;
        while (i < 7) {
            p3 = pp[i] + p3 * xsq;
            ++i;
        }
        double q3 = qq[0];
        i = 1;
        while (i < 7) {
            q3 = qq[i] + q3 * xsq;
            ++i;
        }
        double pzero = p2 / q2;
        double qzero = 8.0 * p3 / q3 / x;
        zz[0] = pzero;
        zz[1] = qzero;
        return zz;
    }

    private static double[] besselasympt1(double x) {
        double[] zz = new double[2];
        double[] p = new double[]{-1611.6166443246102, -109824.05543459347, -1523529.3511811374, -6603373.248364939, -9942246.505077641, -4435757.816794128};
        double[] q = new double[]{1.0, -1455.0094401904962, -107263.8599110382, -1511809.5066341609, -6585339.4797230875, -9934124.389934586, -4435757.816794128};
        double[] pp = new double[]{35.26513384663603, 1706.375429020768, 18494.262873223866, 66178.83658127084, 85145.1606753357, 33220.913409857225};
        double[] qq = new double[]{1.0, 863.8367769604992, 37890.2297457722, 400294.43582266977, 1419460.669603721, 1819458.0422439973, 708712.8194102874};
        double xsq = 64.0 / x / x;
        double p2 = p[0];
        int i = 1;
        while (i < 6) {
            p2 = p[i] + p2 * xsq;
            ++i;
        }
        double q2 = q[0];
        i = 1;
        while (i < 7) {
            q2 = q[i] + q2 * xsq;
            ++i;
        }
        double p3 = pp[0];
        i = 1;
        while (i < 6) {
            p3 = pp[i] + p3 * xsq;
            ++i;
        }
        double q3 = qq[0];
        i = 1;
        while (i < 7) {
            q3 = qq[i] + q3 * xsq;
            ++i;
        }
        double pzero = p2 / q2;
        double qzero = 8.0 * p3 / q3 / x;
        zz[0] = pzero;
        zz[1] = qzero;
        return zz;
    }

    static class BesselDerivative
    implements Function {
        int n;

        BesselDerivative(int n) {
            this.n = n;
        }

        @Override
        public double evaluate(double x) {
            return Bessel.besselnDerivative(this.n, x);
        }
    }

    static class BesselFunction
    implements Function {
        int n;

        BesselFunction(int n) {
            this.n = n;
        }

        @Override
        public double evaluate(double x) {
            if (this.n == 0) {
                return Bessel.bessel0(x);
            }
            if (this.n == 1) {
                return Bessel.bessel1(x);
            }
            return Bessel.besseln(this.n, x);
        }
    }
}

