/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import org.opensourcephysics.numerics.specialfunctions.Messages;

public class Factorials {
    static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    static final int CACHE_MAX_N = 100;
    static final double[] fac = new double[100];

    static {
        Factorials.fac[0] = 1.0;
        long l = 1L;
        int i = 1;
        while (i < 21) {
            Factorials.fac[i] = l *= (long)i;
            ++i;
        }
    }

    private Factorials() {
    }

    public static double gammaln(double x) {
        double y = x;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double sum = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            sum += cof[j] / (y += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.5066282746310007 * sum / x);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Factorials.neg_val"));
        }
        return n >= 100 ? Math.exp(Factorials.gammaln((double)n + 1.0)) : (fac[n] == 0.0 ? Math.exp(Factorials.gammaln((double)n + 1.0)) : fac[n]);
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Factorials.log_neg_val"));
        }
        return Factorials.gammaln((double)n + 1.0);
    }

    public static double poisson(double nu, int n) {
        return Math.exp((double)n * Math.log(nu) - nu - Factorials.logFactorial(n));
    }

    public static double logChoose(int n, int k) {
        return Factorials.logFactorial(n) - Factorials.logFactorial(k) - Factorials.logFactorial(n - k);
    }

    public static void main(String[] args) {
        int i = 10;
        while (i < 25) {
            System.out.println("i= " + i + "  fact(i)= " + Factorials.factorial(i));
            ++i;
        }
    }
}

