/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import org.opensourcephysics.numerics.Function;

public class Gamma
implements Function {
    @Override
    public double evaluate(double x) {
        return Gamma.gamma(x);
    }

    public static double gamma(double x) {
        double[] pp = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] qq = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double sgngam = 1.0;
        double q = Math.abs(x);
        if (q > 33.0) {
            double z;
            if (x < 0.0) {
                int p = (int)Math.floor(q);
                int ip = Math.round(p);
                if (ip % 2 == 0) {
                    sgngam = -1.0;
                }
                if ((z = q - (double)p) > 0.5) {
                    z = q - (double)(++p);
                }
                z = q * Math.sin(Math.PI * z);
                z = Math.abs(z);
                z = Math.PI / (z * Gamma.gammastirf(q));
            } else {
                z = Gamma.gammastirf(x);
            }
            double y = sgngam * z;
            return y;
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x > -1.0E-9) {
                double y = z / ((1.0 + 0.5772156649015329 * x) * x);
                return y;
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x < 1.0E-9) {
                double y = z / ((1.0 + 0.5772156649015329 * x) * x);
                return y;
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0) {
            double y = z;
            return y;
        }
        x -= 2.0;
        double p1 = pp[0];
        int i = 1;
        while (i < 7) {
            p1 = pp[i] + p1 * x;
            ++i;
        }
        double q1 = qq[0];
        i = 1;
        while (i < 8) {
            q1 = qq[i] + q1 * x;
            ++i;
        }
        return z * p1 / q1;
    }

    private static double gammastirf(double x) {
        double w = 1.0 / x;
        double[] pp = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double p1 = pp[0];
        int i = 1;
        while (i < 5) {
            p1 = pp[i] + p1 * x;
            ++i;
        }
        w = 1.0 + w * p1;
        double y = Math.exp(x);
        if (x > 143.01608) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        return 2.5066282746310007 * y * w;
    }
}

