/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.specialfunctions.Messages;

public class Hermite {
    static final ArrayList<Polynomial> hermiteList;
    static final Polynomial twoX;

    static {
        twoX = new Polynomial(new double[]{0.0, 2.0});
        hermiteList = new ArrayList();
        Polynomial p = new Polynomial(new double[]{1.0});
        hermiteList.add(p);
        p = new Polynomial(new double[]{0.0, 2.0});
        hermiteList.add(p);
    }

    private Hermite() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Hermite.neg_degree"));
        }
        if (n < hermiteList.size()) {
            return hermiteList.get(n);
        }
        Polynomial p1 = Hermite.getPolynomial(n - 1).multiply(twoX);
        Polynomial p2 = Hermite.getPolynomial(n - 2).multiply(2 * (n - 1));
        Polynomial p = p1.subtract(p2);
        hermiteList.add(p);
        return p;
    }

    public static double evaluate(int n, double x) {
        return Hermite.getPolynomial(n).evaluate(x);
    }
}

