/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.specialfunctions.Messages;
import org.opensourcephysics.numerics.specialfunctions.QNKey;

public class Laguerre {
    static final ArrayList<Polynomial> laguerreList;
    static final Map<QNKey, Polynomial> associatedLaguerreMap;

    static {
        associatedLaguerreMap = new HashMap<QNKey, Polynomial>();
        laguerreList = new ArrayList();
        Polynomial p0 = new Polynomial(new double[]{1.0});
        laguerreList.add(p0);
        Polynomial p1 = new Polynomial(new double[]{1.0, -1.0});
        laguerreList.add(p1);
    }

    private Laguerre() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Laguerre.neg_degree"));
        }
        if (n < laguerreList.size()) {
            return laguerreList.get(n);
        }
        Polynomial pk = new Polynomial(new double[]{(2.0 * (double)n - 1.0) / (double)n, -1.0 / (double)n});
        Polynomial p1 = Laguerre.getPolynomial(n - 1).multiply(pk);
        Polynomial p2 = Laguerre.getPolynomial(n - 2).multiply((1.0 - (double)n) / (double)n);
        Polynomial p = p1.add(p2);
        laguerreList.add(p);
        return p;
    }

    public static synchronized Polynomial getPolynomial(int n, int k) {
        if (k < 0) {
            throw new IllegalArgumentException(Messages.getString("Laguerre.neg_k"));
        }
        QNKey key = new QNKey(n, k);
        Polynomial p = associatedLaguerreMap.get(key);
        if (p != null) {
            return p;
        }
        p = Laguerre.getPolynomial(n + k);
        int sign = 1;
        int i = 0;
        while (i < k) {
            sign *= -1;
            p = p.derivative();
            ++i;
        }
        if (sign == -1) {
            p = p.multiply(sign);
        }
        associatedLaguerreMap.put(key, p);
        return p;
    }

    public static double evaluate(int n, double x) {
        return Laguerre.getPolynomial(n).evaluate(x);
    }
}

