/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.specialfunctions.Factorials;
import org.opensourcephysics.numerics.specialfunctions.Messages;
import org.opensourcephysics.numerics.specialfunctions.QNKey;

public class Legendre {
    static final ArrayList<Polynomial> legendreList;
    static final Map<QNKey, AssociatedLegendreFunction> associatedMap;

    static {
        associatedMap = new HashMap<QNKey, AssociatedLegendreFunction>();
        legendreList = new ArrayList();
        Polynomial p0 = new Polynomial(new double[]{1.0});
        legendreList.add(p0);
        Polynomial p1 = new Polynomial(new double[]{0.0, 1.0});
        legendreList.add(p1);
    }

    private Legendre() {
    }

    public static synchronized Polynomial getPolynomial(int el) {
        if (el < 0) {
            throw new IllegalArgumentException(Messages.getString("Legendre.neg_degree"));
        }
        if (el < legendreList.size()) {
            return legendreList.get(el);
        }
        Polynomial pk = new Polynomial(new double[]{0.0, (2.0 * (double)el - 1.0) / (double)el});
        Polynomial p1 = Legendre.getPolynomial(el - 1).multiply(pk);
        Polynomial p2 = Legendre.getPolynomial(el - 2).multiply((1.0 - (double)el) / (double)el);
        Polynomial p = p1.add(p2);
        legendreList.add(p);
        return p;
    }

    public static synchronized Function getAssociatedFunction(int el, int m) {
        if (m * m > el * el) {
            throw new IllegalArgumentException(Messages.getString("Legendre.out_of_range_m"));
        }
        QNKey key = new QNKey(el, m);
        AssociatedLegendreFunction f = associatedMap.get(key);
        if (f != null) {
            return f;
        }
        f = new AssociatedLegendreFunction(el, m);
        associatedMap.put(key, f);
        return f;
    }

    public static double evaluate(int el, double x) {
        return Legendre.getPolynomial(el).evaluate(x);
    }

    static class AssociatedLegendreFunction
    implements Function {
        Polynomial p;
        int n;
        int m;
        boolean oddPower;
        boolean positiveM;

        AssociatedLegendreFunction(int el, int m) {
            this.n = el;
            this.positiveM = m > 0;
            this.m = m = Math.abs(m);
            this.oddPower = m % 2 == 1;
            this.p = Legendre.getPolynomial(this.n);
            int i = 0;
            while (i < m) {
                this.p = this.p.derivative();
                ++i;
            }
            if (this.positiveM && this.oddPower) {
                this.p = this.p.multiply(-1.0);
            }
            if (!this.positiveM) {
                this.p = this.p.multiply(Factorials.factorial(this.n - m) / Factorials.factorial(this.n + m));
            }
        }

        @Override
        public double evaluate(double x) {
            double val = Math.pow(1.0 - x * x, this.m / 2) * this.p.evaluate(x);
            return this.oddPower ? val * Math.sqrt(1.0 - x * x) : val;
        }
    }
}

