/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

public abstract class AbstractAutoloadManager
extends JDialog {
    SearchPathDialog searchPathDialog;
    String searchPathChooserDir = OSPRuntime.getUserHome();
    Collection<String> searchPaths = new TreeSet<String>();
    JPanel functionPanel;
    JPanel instructionPanel;
    Box functionBox;
    Font lightFont;
    Font heavyFont;
    JButton closeButton;
    JButton searchPathsButton;
    JTextArea instructionArea;
    Dimension defaultSize = new Dimension(450, 400);
    Map<String, Map<String, ArrayList<String[]>>> autoloadData;
    int inset0 = 6;
    int inset1 = 20;
    int inset2 = 40;
    boolean refreshing = false;
    protected boolean initialized = false;

    protected AbstractAutoloadManager(JDialog dialog) {
        super((Dialog)dialog, true);
        this.setDefaultCloseOperation(1);
        this.createGUI();
        Dimension dim = new Dimension(this.defaultSize);
        double factor = 1.0 + (double)FontSizer.getLevel() * 0.25;
        dim.width = (int)((double)dim.width * factor);
        dim.height = (int)((double)dim.height * factor);
        this.setSize(dim);
    }

    public void setAutoloadData(Map<String, Map<String, ArrayList<String[]>>> data) {
        this.autoloadData = data;
        this.refreshFunctionList();
    }

    public void setInstructions(String instructions) {
        this.instructionArea.setText(instructions);
        if (instructions != null) {
            this.getContentPane().add((Component)this.instructionPanel, "North");
        } else {
            this.getContentPane().remove(this.instructionPanel);
        }
    }

    public void addSearchPath(String dir) {
        this.searchPaths.add(XML.forwardSlash(dir));
    }

    public Collection<String> getSearchPaths() {
        TreeSet<String> paths = new TreeSet<String>();
        paths.addAll(this.searchPaths);
        return paths;
    }

    protected void createGUI() {
        this.heavyFont = new JLabel().getFont().deriveFont(1);
        this.lightFont = this.heavyFont.deriveFont(0);
        this.instructionArea = new JTextArea();
        this.instructionArea.setEditable(false);
        this.instructionArea.setLineWrap(true);
        this.instructionArea.setWrapStyleWord(true);
        Border etched = BorderFactory.createEtchedBorder();
        Border empty = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        this.instructionArea.setBorder(BorderFactory.createCompoundBorder(etched, empty));
        this.instructionArea.setForeground(Color.blue);
        this.instructionPanel = new JPanel(new BorderLayout());
        this.instructionPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.instructionPanel.add((Component)this.instructionArea, "Center");
        this.functionPanel = new JPanel(new BorderLayout());
        this.functionBox = Box.createVerticalBox();
        this.functionBox.setBackground(Color.white);
        this.functionBox.setOpaque(true);
        this.refreshFunctionList();
        JScrollPane scroller = new JScrollPane(this.functionBox);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        this.functionPanel.add((Component)scroller, "Center");
        this.functionPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAutoloadManager.this.setVisible(false);
            }
        });
        this.searchPathsButton = new JButton();
        this.searchPathsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractAutoloadManager.this.searchPathDialog == null) {
                    AbstractAutoloadManager.this.searchPathDialog = new SearchPathDialog();
                    AbstractAutoloadManager.this.searchPathDialog.setLocationRelativeTo(AbstractAutoloadManager.this);
                }
                FontSizer.setFonts(AbstractAutoloadManager.this.searchPathDialog, FontSizer.getLevel());
                AbstractAutoloadManager.this.searchPathDialog.refreshGUI();
                AbstractAutoloadManager.this.searchPathDialog.refreshFileList();
                AbstractAutoloadManager.this.searchPathDialog.setVisible(true);
            }
        });
        JPanel buttonbar = new JPanel();
        buttonbar.add(this.searchPathsButton);
        buttonbar.add(this.closeButton);
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.add((Component)this.functionPanel, "Center");
        contentPane.add((Component)buttonbar, "South");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("AutoloadManager.Title"));
        this.closeButton.setText(ToolsRes.getString("Button.OK"));
        this.searchPathsButton.setText(String.valueOf(ToolsRes.getString("AutoloadManager.Button.SearchPaths")) + "...");
        this.refreshFunctionList();
    }

    protected void refreshFunctionList() {
        this.refreshing = true;
        this.functionBox.removeAll();
        if (this.autoloadData == null) {
            return;
        }
        String directoryTitle = String.valueOf(ToolsRes.getString("AutoloadManager.Directory")) + ": ";
        for (String dir : this.autoloadData.keySet()) {
            Box dirBox = Box.createVerticalBox();
            TitledBorder border = BorderFactory.createTitledBorder(String.valueOf(directoryTitle) + XML.forwardSlash(dir));
            Font titleFont = FontSizer.getResizedFont(this.heavyFont, FontSizer.getLevel());
            border.setTitleFont(titleFont);
            Border spacer = BorderFactory.createEmptyBorder(6, 0, 6, 0);
            dirBox.setBorder(BorderFactory.createCompoundBorder(spacer, border));
            this.functionBox.add(dirBox);
            Map<String, ArrayList<String[]>> functionMap = this.autoloadData.get(dir);
            TreeMap<String, String> lowercaseNames = new TreeMap<String, String>();
            for (String fileName : functionMap.keySet()) {
                lowercaseNames.put(fileName.toLowerCase(), fileName);
            }
            for (String lowercase : lowercaseNames.keySet()) {
                int top = dirBox.getComponentCount() == 0 ? 0 : 10;
                String fileName = (String)lowercaseNames.get(lowercase);
                File file = new File(dir, fileName);
                String filePath = XML.forwardSlash(file.getAbsolutePath());
                AutoloadFileCheckbox fileCheckbox = new AutoloadFileCheckbox(dir, fileName);
                fileCheckbox.setBorder(BorderFactory.createEmptyBorder(top, this.inset1, 2, 0));
                fileCheckbox.setFont(this.heavyFont);
                fileCheckbox.setSelected(this.isFileSelected(filePath));
                Box bar = Box.createHorizontalBox();
                bar.add(fileCheckbox);
                bar.add(Box.createHorizontalGlue());
                dirBox.add(bar);
                Border empty = BorderFactory.createEmptyBorder(0, 0, 0, 40);
                ArrayList<String[]> functionList = functionMap.get(fileName);
                if (functionList.isEmpty()) {
                    Box labelBox = this.getEmptyMessage(this.inset2);
                    dirBox.add(labelBox);
                }
                for (String[] f : functionList) {
                    JLabel label = null;
                    if (f.length > 3) {
                        String s = "[" + f[3] + "]";
                        label = new JLabel(s);
                        label.setBorder(empty);
                        label.setFont(this.lightFont);
                    }
                    AutoloadFunctionCheckbox checkbox = new AutoloadFunctionCheckbox(fileCheckbox, f);
                    checkbox.setFont(this.lightFont);
                    checkbox.setSelected(this.isFunctionSelected(filePath, f));
                    bar = Box.createHorizontalBox();
                    bar.add(checkbox);
                    bar.add(Box.createHorizontalGlue());
                    if (label != null) {
                        bar.add(label);
                    }
                    bar.setBorder(BorderFactory.createEmptyBorder(0, this.inset2, 0, 0));
                    dirBox.add(bar);
                }
            }
            if (dirBox.getComponentCount() != 0) continue;
            dirBox.add(this.getEmptyMessage(this.inset1));
        }
        if (this.functionBox.getComponentCount() == 0) {
            this.functionBox.add(this.getEmptyMessage(this.inset0));
        }
        FontSizer.setFonts(this.functionBox, FontSizer.getLevel());
        this.refreshing = false;
    }

    public void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        FontSizer.setFonts(this.instructionArea, level);
    }

    public String[][] getAllFunctions(String filePath) {
        String dir = XML.getDirectoryPath(filePath);
        Map<String, ArrayList<String[]>> functionMap = this.autoloadData.get(dir);
        if (functionMap == null) {
            return null;
        }
        ArrayList<String[]> functionList = functionMap.get(XML.getName(filePath));
        if (functionList == null) {
            return null;
        }
        return (String[][])functionList.toArray((T[])new String[functionList.size()][]);
    }

    protected void setFunctionSelected(String filePath, String[] function, boolean select) {
        String[] oldExclusions = this.getExclusionsMap().get(filePath);
        String[] newExclusions = null;
        if (!select) {
            if (oldExclusions == null) {
                newExclusions = new String[]{function[0]};
            } else {
                int n = oldExclusions.length;
                if (this.getAllFunctions(filePath).length == n + 1) {
                    newExclusions = new String[]{"*"};
                } else {
                    newExclusions = new String[n + 1];
                    System.arraycopy(oldExclusions, 0, newExclusions, 0, n);
                    newExclusions[n] = function[0];
                }
            }
        } else if (oldExclusions != null) {
            ArrayList<String> exclusions = new ArrayList<String>();
            if (oldExclusions.length == 1 && oldExclusions[0].equals("*")) {
                String[][] allFunctions = this.getAllFunctions(filePath);
                int i = 0;
                while (i < allFunctions.length) {
                    if (!function[0].equals(allFunctions[i][0])) {
                        exclusions.add(allFunctions[i][0]);
                    }
                    ++i;
                }
            } else {
                String[] stringArray = oldExclusions;
                int n = oldExclusions.length;
                int n2 = 0;
                while (n2 < n) {
                    String f = stringArray[n2];
                    if (!f.equals(function[0])) {
                        exclusions.add(f);
                    }
                    ++n2;
                }
            }
            newExclusions = exclusions.toArray(new String[exclusions.size()]);
        }
        this.getExclusionsMap().remove(filePath);
        if (newExclusions != null) {
            this.getExclusionsMap().put(filePath, newExclusions);
        }
    }

    protected boolean isFunctionSelected(String filePath, String[] function) {
        String[] functions = this.getExclusionsMap().get(filePath);
        if (functions == null) {
            return true;
        }
        String[] stringArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals("*")) {
                return false;
            }
            if (name.equals(function[0])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void setFileSelected(String filePath, boolean select) {
        this.getExclusionsMap().remove(filePath);
        if (!select) {
            String[] function = new String[]{"*"};
            this.getExclusionsMap().put(filePath, function);
        }
    }

    protected abstract Map<String, String[]> getExclusionsMap();

    protected boolean isFileSelected(String filePath) {
        String[] functions = this.getExclusionsMap().get(filePath);
        if (functions == null || functions.length == 0) {
            return true;
        }
        return !functions[0].equals("*") && functions.length != this.getAllFunctions(filePath).length;
    }

    protected abstract void refreshAutoloadData();

    private Box getEmptyMessage(int inset) {
        JLabel label = new JLabel(ToolsRes.getString("AutoloadManager.Label.NoFunctionsFound"));
        label.setFont(this.lightFont);
        label.setBorder(BorderFactory.createEmptyBorder(2, inset, 4, 0));
        Box bar = Box.createHorizontalBox();
        bar.add(label);
        bar.add(Box.createHorizontalGlue());
        return bar;
    }

    private class AutoloadFileCheckbox
    extends JCheckBox {
        String fileName;
        String filePath;
        ArrayList<AutoloadFunctionCheckbox> functionCheckBoxes = new ArrayList();

        private AutoloadFileCheckbox(String dir, String name) {
            this.fileName = name;
            File file = new File(dir, this.fileName);
            this.filePath = XML.forwardSlash(file.getAbsolutePath());
            this.setText(this.fileName);
            this.setIconTextGap(10);
            this.setOpaque(false);
            this.setToolTipText(ToolsRes.getString("AutoloadManager.FileCheckbox.Tooltip"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean select = AutoloadFileCheckbox.this.isSelected();
                    AbstractAutoloadManager.this.setFileSelected(AutoloadFileCheckbox.this.filePath, select);
                    int i = 0;
                    while (i < AutoloadFileCheckbox.this.functionCheckBoxes.size()) {
                        AutoloadFileCheckbox.this.functionCheckBoxes.get(i).setSelected(select);
                        ++i;
                    }
                    AutoloadFileCheckbox.this.repaint();
                }
            });
        }
    }

    private class AutoloadFunctionCheckbox
    extends JCheckBox {
        String[] function;
        AutoloadFileCheckbox fileCheckBox;

        private AutoloadFunctionCheckbox(AutoloadFileCheckbox fileCheckbox, String[] f) {
            this.fileCheckBox = fileCheckbox;
            this.function = f;
            this.fileCheckBox.functionCheckBoxes.add(this);
            this.setSelected(AbstractAutoloadManager.this.isFunctionSelected(this.fileCheckBox.filePath, this.function));
            this.setText(String.valueOf(f[0]) + " = " + f[1]);
            this.setIconTextGap(10);
            this.setOpaque(false);
            this.setToolTipText(ToolsRes.getString("AutoloadManager.FunctionCheckbox.Tooltip"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean hasSelections = false;
                    int i = 0;
                    while (i < AutoloadFunctionCheckbox.this.fileCheckBox.functionCheckBoxes.size()) {
                        hasSelections = hasSelections || AutoloadFunctionCheckbox.this.fileCheckBox.functionCheckBoxes.get(i).isSelected();
                        ++i;
                    }
                    if (hasSelections && !AutoloadFunctionCheckbox.this.fileCheckBox.isSelected()) {
                        AutoloadFunctionCheckbox.this.fileCheckBox.setSelected(true);
                    } else if (!hasSelections && AutoloadFunctionCheckbox.this.fileCheckBox.isSelected()) {
                        AutoloadFunctionCheckbox.this.fileCheckBox.setSelected(false);
                    }
                    AbstractAutoloadManager.this.setFunctionSelected(AutoloadFunctionCheckbox.this.fileCheckBox.filePath, AutoloadFunctionCheckbox.this.function, AutoloadFunctionCheckbox.this.isSelected());
                    AutoloadFunctionCheckbox.this.repaint();
                }
            });
        }
    }

    protected class SearchPathDialog
    extends JDialog {
        HashSet<File> addedFiles;
        TreeSet<String> directoryPaths;
        JButton okButton;
        JButton addButton;
        JButton removeButton;
        JList<String> directoryList;
        DefaultListModel<String> directoryListModel;

        SearchPathDialog() {
            super((Dialog)AbstractAutoloadManager.this, true);
            this.addedFiles = new HashSet();
            this.directoryPaths = new TreeSet();
            this.createGUI();
            for (String dir : AbstractAutoloadManager.this.searchPaths) {
                File file = new File(dir);
                this.addedFiles.add(file);
            }
            this.refreshFileList();
        }

        private void createGUI() {
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            this.directoryListModel = new DefaultListModel();
            this.directoryList = new JList<String>(this.directoryListModel);
            this.directoryList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String dir = SearchPathDialog.this.directoryList.getSelectedValue();
                    SearchPathDialog.this.removeButton.setEnabled(dir != null);
                }
            });
            JScrollPane scroller = new JScrollPane(this.directoryList);
            scroller.setPreferredSize(new Dimension(300, 150));
            contentPane.add((Component)scroller, "Center");
            JPanel buttonbar = new JPanel();
            this.addButton = new JButton();
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = SearchPathDialog.this.chooseSearchDirectory(SearchPathDialog.this);
                    if (file == null) {
                        return;
                    }
                    SearchPathDialog.this.addedFiles.add(file);
                    String path = XML.forwardSlash(file.getAbsolutePath());
                    AbstractAutoloadManager.this.addSearchPath(path);
                    SearchPathDialog.this.refreshFileList();
                    AbstractAutoloadManager.this.refreshAutoloadData();
                }
            });
            this.removeButton = new JButton();
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = SearchPathDialog.this.directoryList.getSelectedValue();
                    if (name != null) {
                        Iterator<File> it = SearchPathDialog.this.addedFiles.iterator();
                        while (it.hasNext()) {
                            File next = it.next();
                            String nextPath = XML.forwardSlash(next.getAbsolutePath());
                            if (!name.equals(nextPath)) continue;
                            it.remove();
                            ((SearchPathDialog)SearchPathDialog.this).AbstractAutoloadManager.this.searchPaths.remove(nextPath);
                            break;
                        }
                        SearchPathDialog.this.refreshFileList();
                        AbstractAutoloadManager.this.refreshAutoloadData();
                    }
                }
            });
            this.okButton = new JButton();
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPathDialog.this.setVisible(false);
                }
            });
            buttonbar.add(this.addButton);
            buttonbar.add(this.removeButton);
            buttonbar.add(this.okButton);
            contentPane.add((Component)buttonbar, "South");
            this.pack();
        }

        private File chooseSearchDirectory(Component parent) {
            JFileChooser chooser = new JFileChooser(AbstractAutoloadManager.this.searchPathChooserDir);
            if (OSPRuntime.isMac()) {
                chooser.setFileSelectionMode(2);
            } else {
                chooser.setFileSelectionMode(1);
            }
            FileFilter folderFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
                }
            };
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(folderFilter);
            String text = ToolsRes.getString("LibraryManager.Button.Add");
            chooser.setDialogTitle(text);
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            int result = chooser.showDialog(parent, text);
            if (result == 0) {
                AbstractAutoloadManager.this.searchPathChooserDir = chooser.getCurrentDirectory().getAbsolutePath();
                return chooser.getSelectedFile();
            }
            return null;
        }

        void refreshGUI() {
            this.setTitle(ToolsRes.getString("AutoloadManager.Button.SearchPaths"));
            this.okButton.setText(ToolsRes.getString("Button.OK"));
            this.addButton.setText(String.valueOf(ToolsRes.getString("LibraryManager.Button.Add")) + "...");
            this.removeButton.setText(ToolsRes.getString("LibraryManager.Button.Remove"));
            String dir = this.directoryList.getSelectedValue();
            this.removeButton.setEnabled(dir != null);
        }

        void refreshFileList() {
            this.directoryListModel.clear();
            this.directoryPaths.clear();
            for (File file : this.addedFiles) {
                this.directoryPaths.add(XML.forwardSlash(file.getAbsolutePath()));
            }
            for (String string : this.directoryPaths) {
                this.directoryListModel.addElement(string);
            }
        }
    }
}

