/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.opensourcephysics.tools.CheckTreeSelectionModel;
import org.opensourcephysics.tools.TristateCheckBox;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private CheckTreeSelectionModel selectionModel;
    private TreeCellRenderer delegate;
    private TristateCheckBox checkBox = new TristateCheckBox();

    public CheckTreeCellRenderer(TreeCellRenderer delegate, CheckTreeSelectionModel selectionModel) {
        this.delegate = delegate;
        this.selectionModel = selectionModel;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            if (this.selectionModel.isPathOrAncestorSelected(path)) {
                this.checkBox.setState(TristateCheckBox.SELECTED);
            } else {
                this.checkBox.setState(this.selectionModel.isPathUnselected(path) ? TristateCheckBox.NOT_SELECTED : TristateCheckBox.PART_SELECTED);
            }
        }
        this.removeAll();
        this.add((Component)this.checkBox, "West");
        this.add(renderer, "Center");
        return this;
    }
}

