/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.opensourcephysics.tools.CheckTreeCellRenderer;
import org.opensourcephysics.tools.CheckTreeSelectionModel;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener,
MouseMotionListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;
    boolean ignoreEvents;

    public CheckTreeManager(JTree tree) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.ignoreEvents = false;
        this.tree = tree;
        this.selectionModel = new CheckTreeSelectionModel(tree.getModel());
        tree.setCellRenderer(new CheckTreeCellRenderer(tree.getCellRenderer(), this.selectionModel));
        tree.addMouseListener(this);
        tree.addMouseMotionListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        if (e.getX() > this.tree.getPathBounds((TreePath)path).x + this.hotspot - 3 || e.getX() < this.tree.getPathBounds((TreePath)path).x + 2) {
            this.tree.setCursor(Cursor.getDefaultCursor());
        } else {
            this.tree.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        if (e.getX() > this.tree.getPathBounds((TreePath)path).x + this.hotspot) {
            return;
        }
        boolean selected = this.selectionModel.isPathOrAncestorSelected(path);
        try {
            this.ignoreEvents = true;
            if (selected) {
                this.selectionModel.removeSelectionPath(path);
            } else {
                this.selectionModel.addSelectionPath(path);
            }
        }
        finally {
            this.ignoreEvents = false;
            this.tree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.ignoreEvents) {
            this.tree.treeDidChange();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

