/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;
    private PropertyChangeSupport support;

    public CheckTreeSelectionModel(TreeModel model) {
        this.model = model;
        this.setSelectionMode(4);
        this.support = new SwingPropertyChangeSupport(this);
    }

    public boolean isPathUnselected(TreePath path) {
        if (this.isSelectionEmpty()) {
            return true;
        }
        if (this.isPathOrAncestorSelected(path)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths();
        int i = 0;
        while (i < selectionPaths.length) {
            if (path.isDescendant(selectionPaths[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isPathOrAncestorSelected(TreePath path) {
        while (path != null && !this.isPathSelected(path)) {
            path = path.getParentPath();
        }
        return path != null;
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        super.clearSelection();
        this.addSelectionPaths(paths);
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        TreePath path;
        if (paths == null) {
            return;
        }
        TreePath[] prev = this.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            if (this.isSelectionEmpty()) break;
            path = paths[i];
            TreePath[] selectionPaths = this.getSelectionPaths();
            ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
            int j = 0;
            while (j < selectionPaths.length) {
                if (path.isDescendant(selectionPaths[j])) {
                    toBeRemoved.add(selectionPaths[j]);
                }
                ++j;
            }
            super.removeSelectionPaths(toBeRemoved.toArray(new TreePath[0]));
            ++i;
        }
        i = 0;
        while (i < paths.length) {
            path = paths[i];
            TreePath temp = null;
            while (this.isSiblingsSelected(path)) {
                temp = path;
                if (path.getParentPath() == null) break;
                path = path.getParentPath();
            }
            if (temp != null) {
                if (temp.getParentPath() != null) {
                    this.addSelectionPath(temp.getParentPath());
                } else {
                    if (!this.isSelectionEmpty()) {
                        this.removeSelectionPaths(this.getSelectionPaths());
                    }
                    super.addSelectionPaths(new TreePath[]{temp});
                }
            } else {
                super.addSelectionPaths(new TreePath[]{path});
            }
            ++i;
        }
        this.support.firePropertyChange("treepaths", prev, this.getSelectionPaths());
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (this.isSelectionEmpty()) {
            return;
        }
        TreePath[] prev = this.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            if (path.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{path});
            } else if (this.isPathSelected(path)) {
                super.removeSelectionPaths(new TreePath[]{path});
            } else {
                this.unselectAncestor(path);
            }
            ++i;
        }
        this.support.firePropertyChange("treepaths", prev, this.getSelectionPaths());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private boolean isSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this.model.getChildCount(parentNode);
        int i = 0;
        while (i < childCount) {
            Object childNode = this.model.getChild(parentNode, i);
            if (!childNode.equals(node) && !this.isPathSelected(parent.pathByAddingChild(childNode))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void unselectAncestor(TreePath path) {
        Stack<TreePath> stack = new Stack<TreePath>();
        stack.push(path);
        TreePath ancestor = path.getParentPath();
        while (ancestor != null && !this.isPathSelected(ancestor)) {
            stack.push(ancestor);
            ancestor = ancestor.getParentPath();
        }
        if (ancestor == null) {
            return;
        }
        stack.push(ancestor);
        while (!stack.isEmpty()) {
            TreePath next = (TreePath)stack.pop();
            super.removeSelectionPaths(new TreePath[]{next});
            if (stack.isEmpty()) {
                return;
            }
            Object node = next.getLastPathComponent();
            int childCount = this.model.getChildCount(node);
            int i = 0;
            while (i < childCount) {
                Object child = this.model.getChild(node, i);
                super.addSelectionPaths(new TreePath[]{next.pathByAddingChild(child)});
                ++i;
            }
        }
    }
}

