/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javajs.async.AsyncFileChooser;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class DataBuilder
extends FunctionTool {
    private DataTool dataTool;
    private JButton loadButton;
    private JButton saveButton;

    public DataBuilder(DataTool tool) {
        this(tool, false);
    }

    public DataBuilder(DataTool tool, boolean lazyGUI) {
        super((Component)tool, false, lazyGUI);
        this.dataTool = tool;
        this.setHelpPath("data_builder_help.html");
        if (!lazyGUI) {
            this.createGUI();
        }
    }

    @Override
    protected void createGUI() {
        if (this.haveGUI()) {
            return;
        }
        super.createGUI();
        String imageFile = "/org/opensourcephysics/resources/tools/images/open.gif";
        ImageIcon openIcon = ResourceLoader.getImageIcon(imageFile);
        this.loadButton = new JButton(openIcon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsyncFileChooser chooser = OSPRuntime.createChooser(ToolsRes.getString("DataBuilder.Load.Title"), ToolsRes.getString("FileChooser.Filter.XMLFiles"), new String[]{"xml"});
                int result = ((JFileChooser)chooser).showOpenDialog(DataBuilder.this.dataTool);
                if (result == 0) {
                    OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                    final XMLControlElement control = new XMLControlElement(chooser.getSelectedFile());
                    if (control.failedToRead()) {
                        JOptionPane.showMessageDialog(DataBuilder.this.dataTool, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
                        return;
                    }
                    Class<?> type = control.getObjectClass();
                    if (DataFunctionPanel.class.isAssignableFrom(type)) {
                        DataBuilder.this.chooseDataFunctions(control, "Load", null, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (e.getID() == 1001) {
                                    control.loadObject(DataBuilder.this.getSelectedPanel());
                                }
                            }
                        });
                    } else {
                        JOptionPane.showMessageDialog(DataBuilder.this.dataTool, ToolsRes.getString("DataBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DataBuilder.Dialog.WrongType.Title"), 0);
                    }
                }
            }
        });
        imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        ImageIcon saveIcon = ResourceLoader.getImageIcon(imageFile);
        this.saveButton = new JButton(saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final XMLControlElement control = new XMLControlElement(DataBuilder.this.getSelectedPanel());
                DataBuilder.this.chooseDataFunctions(control, "Save", null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AsyncFileChooser chooser;
                        int result;
                        if (e.getID() == 1001 && (result = ((JFileChooser)(chooser = OSPRuntime.createChooser(ToolsRes.getString("DataBuilder.Save.Title"), ToolsRes.getString("FileChooser.Filter.XMLFiles"), new String[]{"xml"}))).showSaveDialog(DataBuilder.this.dataTool)) == 0) {
                            int selected;
                            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                            File file = chooser.getSelectedFile();
                            String fileName = file.getAbsolutePath();
                            if (!"xml".equals(XML.getExtension(fileName))) {
                                fileName = String.valueOf(XML.stripExtension(fileName)) + ".xml";
                                file = new File(fileName);
                            }
                            if (file.exists() && (selected = JOptionPane.showConfirmDialog(DataBuilder.this.dataTool, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 2)) != 0) {
                                return;
                            }
                            control.write(fileName);
                        }
                    }
                });
            }
        });
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton});
    }

    @Override
    protected void setTitles() {
        this.dropdownTipText = ToolsRes.getString("DataTool.DataBuilder.Dropdown.Tooltip");
        this.titleText = ToolsRes.getString("DataTool.DataBuilder.Title");
    }

    @Override
    protected void refreshGUI() {
        if (!this.haveGUI()) {
            return;
        }
        super.refreshGUI();
        if (this.loadButton != null) {
            FunctionPanel panel = this.getSelectedPanel();
            this.loadButton.setEnabled(panel != null);
            this.saveButton.setEnabled(panel != null);
            this.loadButton.setToolTipText(ToolsRes.getString("DataBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DataBuilder.Button.Save.Tooltip"));
        }
    }

    protected void refreshPanels() {
        String name;
        ArrayList<String> tabNames = new ArrayList<String>();
        int i = 0;
        while (i < this.dataTool.tabbedPane.getTabCount()) {
            DataToolTab tab = this.dataTool.getTab(i);
            tabNames.add(tab.getName());
            if (this.getPanel(tab.getName()) == null) {
                this.addPanel(tab.getName(), new DataFunctionPanel(tab.dataManager));
            }
            ++i;
        }
        ArrayList<String> remove = new ArrayList<String>();
        Iterator<Object> it = this.trackFunctionPanels.keySet().iterator();
        while (it.hasNext()) {
            name = ((String)it.next()).toString();
            if (tabNames.contains(name)) continue;
            remove.add(name);
        }
        it = remove.iterator();
        while (it.hasNext()) {
            name = ((String)it.next()).toString();
            this.removePanel(name);
        }
        FunctionPanel p = this.getSelectedPanel();
        if (p != null) {
            p.getFunctionEditor().enableMenuButtons();
            p.getParamEditor().enableMenuButtons();
        }
    }

    protected void chooseDataFunctions(final XMLControl control, String description, Collection<String[]> selectedFunctions, final ActionListener listener) {
        final ArrayList<String[]> originals = new ArrayList<String[]>();
        final ArrayList<String[]> choices = new ArrayList<String[]>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        final ArrayList functions = (ArrayList)control.getObject("functions");
        for (Object next : functions) {
            String[] function = (String[])next;
            originals.add(function);
            choices.add(function);
            names.add(function[0]);
            expressions.add(function[1]);
        }
        boolean[] selected = new boolean[choices.size()];
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DataBuilder." + description + ".Title"), ToolsRes.getString("DataBuilder." + description + ".Message"), this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    for (Object next : originals) {
                        if (choices.contains(next)) continue;
                        functions.remove(next);
                    }
                    control.setValue("functions", functions);
                }
                listener.actionPerformed(e);
            }
        });
        listChooser.setSeparator(" = ");
        listChooser.choose(choices, names, expressions, null, selected, null);
    }
}

