/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionEditor
extends FunctionEditor {
    public static final String PROPERTY_DATAFUNCTIONEDITOR_FUNCTION = "function";
    static Color[] markerColors = new Color[]{Color.green.darker(), Color.red, Color.cyan.darker(), Color.yellow.darker(), Color.blue};
    private DatasetManager data;

    public DataFunctionEditor(DatasetManager data) {
        this.data = data;
        this.init();
    }

    private void init() {
        ArrayList<Dataset> sets = this.data.getDatasetsRaw();
        int i = 0;
        int n = sets.size();
        while (i < n) {
            Dataset next = sets.get(i);
            if (next instanceof DataFunction) {
                this.objects.add((DataFunction)next);
            }
            ++i;
        }
    }

    @Override
    protected void setTitles() {
        this.titledBorderText = ToolsRes.getString("DataFunctionEditor.Border.Title");
    }

    public DatasetManager getData() {
        return this.data;
    }

    @Override
    public String getName(FunctionEditor.FObject obj) {
        return obj == null ? null : ((DataFunction)obj).getYColumnName();
    }

    @Override
    public String getExpression(FunctionEditor.FObject obj) {
        return obj == null ? null : ((DataFunction)obj).getInputString();
    }

    @Override
    public String getDescription(FunctionEditor.FObject obj) {
        return obj == null ? null : ((DataFunction)obj).getYColumnDescription();
    }

    @Override
    public void setDescription(FunctionEditor.FObject obj, String desc) {
        if (obj != null) {
            if (desc != null && desc.trim().equals("")) {
                desc = null;
            }
            ((DataFunction)obj).setYColumnDescription(desc);
            super.setDescription(obj, desc);
        }
    }

    @Override
    public String getTooltip(FunctionEditor.FObject obj) {
        return obj == null ? null : ((DataFunction)obj).getYColumnDescription();
    }

    @Override
    public boolean isNameEditable(FunctionEditor.FObject obj) {
        return true;
    }

    @Override
    public boolean isExpressionEditable(FunctionEditor.FObject obj) {
        return true;
    }

    @Override
    public void evaluateAll() {
        this.setArrays();
        int i = 0;
        while (i < this.evaluate.size()) {
            DataFunction f = (DataFunction)this.evaluate.get(i);
            f.setExpression(f.getInputString());
            ++i;
        }
    }

    @Override
    public FunctionEditor.FObject addObject(FunctionEditor.FObject obj, int row, boolean postEdit, boolean firePropertyChange) {
        if ((obj = super.addObject(obj, row, postEdit, firePropertyChange)) != null) {
            this.firePropertyChange(PROPERTY_DATAFUNCTIONEDITOR_FUNCTION, null, obj);
        }
        return obj;
    }

    @Override
    public FunctionEditor.FObject removeObject(FunctionEditor.FObject obj, boolean postEdit) {
        if ((obj = super.removeObject(obj, postEdit)) != null) {
            this.firePropertyChange(PROPERTY_DATAFUNCTIONEDITOR_FUNCTION, obj, null);
        }
        return obj;
    }

    @Override
    protected boolean isDisallowedName(FunctionEditor.FObject obj, String name) {
        ArrayList<Dataset> datasets = this.data.getDatasetsRaw();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset next = datasets.get(i);
            if (obj != null && next == obj && this.getName(obj).equals(name)) {
                return false;
            }
            if (i == 0 && TeXParser.removeSubscripting(next.getXColumnName()).equals(name)) {
                return true;
            }
            if (TeXParser.removeSubscripting(next.getYColumnName()).equals(name)) {
                return true;
            }
            ++i;
        }
        return super.isDisallowedName(obj, name);
    }

    @Override
    protected String getVariablesString(String separator) {
        StringBuffer vars = new StringBuffer("");
        if (this.paramEditor != null) {
            Parameter[] parameters = this.paramEditor.getParameters();
            int i = 0;
            while (i < parameters.length) {
                vars.append(" ");
                vars.append(parameters[i].getName());
                ++i;
            }
        }
        String nameToSkip = this.getName(this.getSelectedObject());
        ArrayList<Dataset> datasets = this.data.getDatasetsRaw();
        int i = 0;
        while (i < datasets.size()) {
            String name;
            Dataset next = datasets.get(i);
            if (i == 0) {
                name = next.getXColumnName();
                vars.append(" ");
                vars.append(TeXParser.removeSubscripting(name));
            }
            if (!(name = next.getYColumnName()).equals(nameToSkip)) {
                vars.append(" ");
                vars.append(TeXParser.removeSubscripting(name));
            }
            ++i;
        }
        return this.getVariablesString(vars, separator);
    }

    @Override
    protected boolean isInvalidExpression(FunctionEditor.FObject obj) {
        DataFunction f = (DataFunction)obj;
        return !f.getInputString().equals(f.getExpression());
    }

    @Override
    protected FunctionEditor.FObject createObject(String name, String expression, FunctionEditor.FObject obj) {
        DataFunction f = (DataFunction)obj;
        if (f != null && f.getYColumnName().equals(name) && f.getInputString().equals(expression)) {
            return f;
        }
        if (f == null) {
            f = new DataFunction(this.data);
            int i = this.objects.size();
            if (i < markerColors.length) {
                f.setMarkerColor(markerColors[i], markerColors[i].darker());
                f.setLineColor(markerColors[i]);
            }
            f.setYColumnName(name);
            f.setExpression(expression);
        } else if (!f.getYColumnName().equals(name)) {
            f.setYColumnName(name);
        } else {
            f.setExpression(expression);
        }
        return f;
    }

    @Override
    protected void pasteAction() {
        this.getClipboardContentsAsync(controls -> {
            if (controls == null) {
                return;
            }
            int i = 0;
            while (i < ((XMLControl[])controls).length) {
                DataFunction f = new DataFunction(this.data);
                FunctionEditor.FObject obj = (FunctionEditor.FObject)controls[i].loadObject(f);
                this.addObject(obj, true);
                ++i;
            }
            this.evaluateAll();
        });
    }

    @Override
    protected boolean isImportant(FunctionEditor.FObject obj) {
        return false;
    }

    @Override
    protected void setReferences(FunctionEditor.FObject obj, BitSet directRefrences) {
    }
}

